/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http.device;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.community.network.http.server.HttpExchange;
import org.jetlinks.core.message.codec.http.Header;
import org.jetlinks.core.message.codec.http.HttpExchangeMessage;
import org.jetlinks.core.message.codec.http.HttpResponseMessage;
import org.jetlinks.core.message.codec.http.MultiPart;
import org.jetlinks.core.message.codec.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

public class AsyncHttpExchangeMessage
implements HttpExchangeMessage {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpExchangeMessage.class);
    private static final AtomicReferenceFieldUpdater<AsyncHttpExchangeMessage, Boolean> RESPONDED = AtomicReferenceFieldUpdater.newUpdater(AsyncHttpExchangeMessage.class, Boolean.class, "responded");
    private final HttpExchange exchange;
    private volatile Boolean responded = false;

    public AsyncHttpExchangeMessage(HttpExchange exchange) {
        this.exchange = exchange;
    }

    @Nonnull
    public Mono<Void> response(@Nonnull HttpResponseMessage message) {
        return Mono.defer(() -> {
            if (!RESPONDED.getAndSet(this, true).booleanValue() && !this.exchange.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u54cd\u5e94HTTP\u8bf7\u6c42:\n{}", (Object)message.print());
                }
                return this.exchange.response(message);
            }
            return Mono.empty();
        });
    }

    public Mono<ByteBuf> payload() {
        return this.exchange.request().getBody();
    }

    @Nonnull
    public String getUrl() {
        return this.exchange.request().getUrl();
    }

    @Nonnull
    public HttpMethod getMethod() {
        return this.exchange.request().getMethod();
    }

    @Nullable
    public MediaType getContentType() {
        return this.exchange.request().getContentType();
    }

    @Nonnull
    public List<Header> getHeaders() {
        return this.exchange.request().getHeaders();
    }

    @Nullable
    public Map<String, String> getQueryParameters() {
        return this.exchange.request().getQueryParameters();
    }

    public Mono<MultiPart> multiPartAsync() {
        return this.exchange.request().multiPart();
    }

    @Deprecated
    @Nonnull
    public Optional<MultiPart> multiPart() {
        return Optional.ofNullable(this.multiPartAsync().toFuture().getNow(null));
    }

    @Nonnull
    public ByteBuf getPayload() {
        return this.payload().toFuture().getNow(Unpooled.EMPTY_BUFFER);
    }

    public String toString() {
        return this.print();
    }

    public String print() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getMethod()).append(" ").append(this.getPath());
        if (!CollectionUtils.isEmpty(this.getQueryParameters())) {
            builder.append("?").append(this.getQueryParameters().entrySet().stream().map(e -> ((String)e.getKey()).concat("=").concat((String)e.getValue())).collect(Collectors.joining("&"))).append("\n");
        } else {
            builder.append("\n");
        }
        for (Header header : this.getHeaders()) {
            builder.append(header.getName()).append(": ").append(String.join((CharSequence)",", header.getValue())).append("\n");
        }
        if (MultiPart.isMultiPart((MediaType)this.getContentType())) {
            MultiPart multiPart = this.multiPartAsync().toFuture().getNow(null);
            builder.append("\n");
            if (multiPart != null) {
                builder.append("\n");
                for (Part part : multiPart.getParts()) {
                    builder.append(part).append("\n");
                }
            } else {
                builder.append("\n").append("<unread multiPart>\n");
            }
        } else if (this.getMethod() != HttpMethod.GET && this.getMethod() != HttpMethod.DELETE) {
            ByteBuf payload = this.payload().toFuture().getNow(null);
            if (payload == null) {
                return builder.append("\n").append("<unread payload>\n").toString();
            }
            if (payload.refCnt() == 0) {
                return builder.append("\n").append("<payload released>\n").toString();
            }
            if (payload.readableBytes() == 0) {
                return builder.toString();
            }
            builder.append("\n");
            if (ByteBufUtil.isText((ByteBuf)payload, (Charset)StandardCharsets.UTF_8)) {
                builder.append(payload.toString(StandardCharsets.UTF_8));
            } else {
                ByteBufUtil.appendPrettyHexDump((StringBuilder)builder, (ByteBuf)payload);
            }
        }
        return builder.toString();
    }
}

