/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import java.util.Optional;
import org.springframework.util.StringUtils;

public class VertxWebUtils {
    static final String[] ipHeaders = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP"};

    public static String getIpAddr(HttpServerRequest request) {
        for (String ipHeader : ipHeaders) {
            String ip = request.getHeader(ipHeader);
            if (StringUtils.isEmpty((Object)ip) || ip.contains("unknown")) continue;
            return ip;
        }
        return Optional.ofNullable(request.remoteAddress()).map(SocketAddress::host).orElse("unknown");
    }
}

