/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetlinks.community.PropertyConstants;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.session.DeviceSessionManager;
import org.jetlinks.core.message.ChildDeviceMessage;
import org.jetlinks.core.message.ChildDeviceMessageReply;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.DeviceOfflineMessage;
import org.jetlinks.core.message.DeviceOnlineMessage;
import org.jetlinks.core.message.DeviceRegisterMessage;
import org.jetlinks.core.message.DeviceUnRegisterMessage;
import org.jetlinks.core.message.DisconnectDeviceMessage;
import org.jetlinks.core.message.DisconnectDeviceMessageReply;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.state.DeviceStateCheckMessage;
import org.jetlinks.core.message.state.DeviceStateCheckMessageReply;
import org.jetlinks.core.server.session.ChildrenDeviceSession;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.core.server.session.KeepOnlineSession;
import org.jetlinks.core.server.session.LostDeviceSession;
import org.jetlinks.supports.server.DecodedClientMessageHandler;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public class DeviceGatewayHelper {
    private final DeviceRegistry registry;
    private final DeviceSessionManager sessionManager;
    private final DecodedClientMessageHandler messageHandler;

    public static Consumer<DeviceSession> applySessionKeepaliveTimeout(DeviceMessage msg, Supplier<Duration> timeoutSupplier) {
        return session -> {
            Integer timeout = (Integer)msg.getHeaderOrElse(Headers.keepOnlineTimeoutSeconds, () -> null);
            if (null != timeout) {
                session.setKeepAliveTimeout(Duration.ofSeconds(timeout.intValue()));
            } else {
                Duration defaultTimeout = (Duration)timeoutSupplier.get();
                if (null != defaultTimeout) {
                    session.setKeepAliveTimeout(defaultTimeout);
                }
            }
        };
    }

    public Mono<DeviceOperator> handleDeviceMessage(DeviceMessage message, Function<DeviceOperator, DeviceSession> sessionBuilder) {
        return this.handleDeviceMessage(message, sessionBuilder, (DeviceSession ignore) -> {}, () -> {});
    }

    public Mono<DeviceOperator> handleDeviceMessage(DeviceMessage message, Function<DeviceOperator, DeviceSession> sessionBuilder, Consumer<DeviceSession> sessionConsumer, Runnable deviceNotFoundCallback) {
        return this.handleDeviceMessage(message, sessionBuilder, sessionConsumer, () -> Mono.fromRunnable((Runnable)deviceNotFoundCallback));
    }

    private Mono<Void> handleChildrenDeviceMessage(String deviceId, DeviceMessage children) {
        DeviceMessageReply reply;
        if (deviceId == null || children instanceof DeviceStateCheckMessage || children instanceof DeviceStateCheckMessageReply || children instanceof DisconnectDeviceMessage || children instanceof DisconnectDeviceMessageReply || ((Boolean)children.getHeaderOrDefault(Headers.ignoreSession)).booleanValue()) {
            return Mono.empty();
        }
        if (children instanceof DeviceMessageReply && !(reply = (DeviceMessageReply)children).isSuccess()) {
            return Mono.empty();
        }
        String childrenId = children.getDeviceId();
        if (children instanceof DeviceOfflineMessage || children instanceof DeviceUnRegisterMessage) {
            return this.sessionManager.remove(childrenId, this.removeSessionOnlyLocal(children)).doOnNext(total -> {
                if (total > 0L) {
                    children.addHeader(Headers.ignore, (Object)true);
                }
            }).then();
        }
        if (children instanceof DeviceOnlineMessage) {
            children.addHeader(Headers.ignore, (Object)true);
        }
        Mono sessionHandler = this.sessionManager.getSession(deviceId).flatMap(parentSession -> this.createOrUpdateSession(childrenId, children, child -> Mono.just((Object)new ChildrenDeviceSession(childrenId, parentSession, child)), Mono::empty).doOnNext(session -> {
            ChildrenDeviceSession childrenSession;
            if (session.isWrapFrom(ChildrenDeviceSession.class) && !Objects.equals(deviceId, (childrenSession = (ChildrenDeviceSession)session.unwrap(ChildrenDeviceSession.class)).getParent().getDeviceId())) {
                childrenSession.replaceWith(parentSession);
            }
        }));
        if (DeviceGatewayHelper.isDoRegister(children)) {
            return this.getDeviceForRegister(children.getDeviceId()).flatMap(device -> device.getSelfConfig(DeviceConfigKey.selfManageState).defaultIfEmpty((Object)false).filter(Boolean.FALSE::equals)).flatMap(ignore -> sessionHandler).then();
        }
        return sessionHandler.then();
    }

    public Mono<DeviceOperator> handleDeviceMessage(DeviceMessage message, Function<DeviceOperator, Mono<DeviceSession>> sessionBuilder, Function<DeviceSession, Mono<Void>> sessionConsumer, Supplier<Mono<DeviceOperator>> deviceNotFoundCallback) {
        String deviceId = message.getDeviceId();
        if (!StringUtils.hasText((String)deviceId)) {
            return Mono.empty();
        }
        Mono then = null;
        boolean doHandle = true;
        if (message instanceof ChildDeviceMessage) {
            DeviceMessage childrenMessage = (DeviceMessage)((ChildDeviceMessage)message).getChildDeviceMessage();
            then = this.handleChildrenDeviceMessage(deviceId, childrenMessage).then(this.registry.getDevice(deviceId));
        } else if (message instanceof ChildDeviceMessageReply) {
            DeviceMessage childrenMessage = (DeviceMessage)((ChildDeviceMessageReply)message).getChildDeviceMessage();
            then = this.handleChildrenDeviceMessage(deviceId, childrenMessage).then(this.registry.getDevice(deviceId));
        } else {
            if (message instanceof DeviceOfflineMessage) {
                return this.sessionManager.remove(deviceId, this.removeSessionOnlyLocal(message)).flatMap(l -> {
                    if (l == 0L) {
                        return this.registry.getDevice(deviceId).flatMap(device -> this.messageHandler.handleMessage(device, (Message)message));
                    }
                    return Mono.empty();
                }).then(this.registry.getDevice(deviceId)).contextWrite((ContextView)Context.of(DeviceMessage.class, (Object)message));
            }
            if (message instanceof DeviceOnlineMessage) {
                doHandle = message.getHeader(Headers.force).orElse(false);
            }
        }
        if (((Boolean)message.getHeaderOrDefault(Headers.ignoreSession)).booleanValue()) {
            return this.registry.getDevice(deviceId).flatMap(device -> {
                if (!DeviceGatewayHelper.isDoRegister(message)) {
                    return this.messageHandler.handleMessage(device, (Message)message).thenReturn(device);
                }
                return Mono.just((Object)device);
            });
        }
        if (then == null) {
            then = this.registry.getDevice(deviceId);
        }
        if (doHandle) {
            then = this.messageHandler.handleMessage(null, (Message)message).then(then);
        }
        return this.createOrUpdateSession(deviceId, message, sessionBuilder, deviceNotFoundCallback).flatMap(sessionConsumer).then(then).contextWrite((ContextView)Context.of(DeviceMessage.class, (Object)message));
    }

    private Mono<DeviceSession> createOrUpdateSession(String deviceId, DeviceMessage message, Function<DeviceOperator, Mono<DeviceSession>> sessionBuilder, Supplier<Mono<DeviceOperator>> deviceNotFoundCallback) {
        return this.sessionManager.getSession(deviceId, false).filterWhen(DeviceSession::isAliveAsync).map(old -> {
            if (DeviceGatewayHelper.needUpdateSession(old, message)) {
                return this.sessionManager.compute(deviceId, null, session -> this.updateSession((DeviceSession)session, message, sessionBuilder));
            }
            DeviceGatewayHelper.applySessionKeepaliveTimeout(message, old);
            old.keepAlive();
            return Mono.just((Object)old);
        }).defaultIfEmpty((Object)Mono.defer(() -> this.sessionManager.compute(deviceId, this.createNewSession(deviceId, message, sessionBuilder, () -> this.lambda$null$20(message, deviceId, (Supplier)deviceNotFoundCallback)), session -> this.updateSession((DeviceSession)session, message, sessionBuilder)))).flatMap(Function.identity());
    }

    private Mono<DeviceOperator> getDeviceForRegister(String deviceId) {
        return this.registry.getDevice(deviceId).switchIfEmpty(Mono.defer(() -> Mono.delay((Duration)Duration.ofSeconds(2L)).then(this.registry.getDevice(deviceId))));
    }

    private Mono<DeviceSession> createNewSession(String deviceId, DeviceMessage message, Function<DeviceOperator, Mono<DeviceSession>> sessionBuilder, Supplier<Mono<DeviceOperator>> deviceNotFoundCallback) {
        return this.registry.getDevice(deviceId).switchIfEmpty(Mono.defer(deviceNotFoundCallback)).flatMap(device -> ((Mono)sessionBuilder.apply((DeviceOperator)device)).map(newSession -> {
            if (message.getHeader(Headers.keepOnline).orElse(false).booleanValue()) {
                int timeout = (Integer)message.getHeaderOrDefault(Headers.keepOnlineTimeoutSeconds);
                newSession = new KeepOnlineSession(newSession, Duration.ofSeconds(timeout));
            }
            return newSession;
        }));
    }

    private Mono<DeviceSession> updateSession(DeviceSession session, DeviceMessage message, Function<DeviceOperator, Mono<DeviceSession>> sessionBuilder) {
        return session.isAliveAsync().flatMap(alive -> {
            if (alive.booleanValue()) {
                return this.updateSession0(session, message, sessionBuilder);
            }
            return this.createNewSession(message.getDeviceId(), message, sessionBuilder, Mono::empty);
        });
    }

    private Mono<DeviceSession> updateSession0(DeviceSession session, DeviceMessage message, Function<DeviceOperator, Mono<DeviceSession>> sessionBuilder) {
        Integer timeoutSeconds;
        Mono after = null;
        if (DeviceGatewayHelper.isNewKeeOnline(session, message)) {
            timeoutSeconds = (Integer)message.getHeaderOrDefault(Headers.keepOnlineTimeoutSeconds);
            session = new KeepOnlineSession(session, Duration.ofSeconds(timeoutSeconds.intValue()));
        }
        if (DeviceGatewayHelper.isKeeOnlineLost(session)) {
            timeoutSeconds = (Integer)message.getHeaderOrDefault(Headers.keepOnlineTimeoutSeconds);
            after = sessionBuilder.apply(session.getOperator()).map(newSession -> new KeepOnlineSession(newSession, Duration.ofSeconds(timeoutSeconds.intValue())));
        }
        DeviceGatewayHelper.applySessionKeepaliveTimeout(message, session);
        session.keepAlive();
        return after == null ? Mono.just((Object)session) : after;
    }

    private static void applySessionKeepaliveTimeout(DeviceMessage msg, DeviceSession session) {
        Integer timeout = (Integer)msg.getHeaderOrElse(Headers.keepOnlineTimeoutSeconds, () -> null);
        if (null != timeout) {
            session.setKeepAliveTimeout(Duration.ofSeconds(timeout.intValue()));
        }
    }

    private boolean removeSessionOnlyLocal(DeviceMessage message) {
        return message.getHeader(Headers.clearAllSession).map(val -> val == false).orElse(false);
    }

    private static boolean needUpdateSession(DeviceSession session, DeviceMessage message) {
        return DeviceGatewayHelper.isNewKeeOnline(session, message) || DeviceGatewayHelper.isKeeOnlineLost(session);
    }

    private static boolean isNewKeeOnline(DeviceSession session, DeviceMessage message) {
        return message.getHeader(Headers.keepOnline).orElse(false) != false && !(session instanceof KeepOnlineSession);
    }

    private static boolean isKeeOnlineLost(DeviceSession session) {
        if (!session.isWrapFrom(KeepOnlineSession.class)) {
            return false;
        }
        return session.isWrapFrom(LostDeviceSession.class) || !((KeepOnlineSession)session.unwrap(KeepOnlineSession.class)).getParent().isAlive();
    }

    private static boolean isDoRegister(DeviceMessage message) {
        return message instanceof DeviceRegisterMessage && message.getHeader((HeaderKey)PropertyConstants.deviceName).isPresent() && message.getHeader((HeaderKey)PropertyConstants.productId).isPresent();
    }

    public Mono<DeviceOperator> handleDeviceMessage(DeviceMessage message, Function<DeviceOperator, DeviceSession> sessionBuilder, Consumer<DeviceSession> sessionConsumer, Supplier<Mono<DeviceOperator>> deviceNotFoundCallback) {
        return this.handleDeviceMessage(message, (DeviceOperator device) -> Mono.justOrEmpty(sessionBuilder.apply((DeviceOperator)device)), (DeviceSession session) -> {
            sessionConsumer.accept((DeviceSession)session);
            return Mono.empty();
        }, deviceNotFoundCallback);
    }

    public DeviceGatewayHelper(DeviceRegistry registry, DeviceSessionManager sessionManager, DecodedClientMessageHandler messageHandler) {
        this.registry = registry;
        this.sessionManager = sessionManager;
        this.messageHandler = messageHandler;
    }

    private /* synthetic */ Mono lambda$null$20(DeviceMessage message, String deviceId, Supplier deviceNotFoundCallback) {
        if (DeviceGatewayHelper.isDoRegister(message)) {
            return this.messageHandler.handleMessage(null, (Message)message).then(Mono.delay((Duration)Duration.ofSeconds(2L))).then(this.registry.getDevice(deviceId));
        }
        if (deviceNotFoundCallback != null) {
            return (Mono)deviceNotFoundCallback.get();
        }
        return Mono.empty();
    }
}

