/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway.monitor.measurements;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.Interval;
import org.jetlinks.community.dashboard.CommonDimensionDefinition;
import org.jetlinks.community.dashboard.DimensionDefinition;
import org.jetlinks.community.dashboard.MeasurementDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.MeasurementValue;
import org.jetlinks.community.dashboard.SimpleMeasurementValue;
import org.jetlinks.community.dashboard.supports.StaticMeasurement;
import org.jetlinks.community.gateway.monitor.GatewayTimeSeriesMetric;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.community.timeseries.TimeSeriesService;
import org.jetlinks.community.timeseries.query.Aggregation;
import org.jetlinks.community.timeseries.query.AggregationQueryParam;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.StringType;
import reactor.core.publisher.Flux;

class DeviceGatewayMeasurement
extends StaticMeasurement {
    private TimeSeriesManager timeSeriesManager;
    private String type;
    private Aggregation defaultAgg;
    private String property;
    static ConfigMetadata historyConfigMetadata = new DefaultConfigMetadata().add("gatewayId", "\u7f51\u5173", "", (DataType)new StringType()).add("time", "\u5468\u671f", "\u4f8b\u5982: 1h,10m,30s", (DataType)new StringType()).add("format", "\u65f6\u95f4\u683c\u5f0f", "\u5982: MM-dd:HH", (DataType)new StringType()).add("limit", "\u6700\u5927\u6570\u636e\u91cf", "", (DataType)new IntType()).add("from", "\u65f6\u95f4\u4ece", "", (DataType)new DateTimeType().format("yyyy-MM-dd HH:mm:ss")).add("to", "\u65f6\u95f4\u81f3", "", (DataType)new DateTimeType().format("yyyy-MM-dd HH:mm:ss"));
    static ConfigMetadata aggConfigMetadata = new DefaultConfigMetadata().add("gatewayId", "\u7f51\u5173", "", (DataType)new StringType()).add("time", "\u5468\u671f", "\u4f8b\u5982: 1h,10m,30s", (DataType)new StringType()).add("format", "\u65f6\u95f4\u683c\u5f0f", "\u5982: MM-dd:HH", (DataType)new StringType()).add("agg", "\u805a\u5408\u65b9\u5f0f", "", (DataType)new EnumType().addElement(EnumType.Element.of((String)"SUM", (String)"\u603b\u548c")).addElement(EnumType.Element.of((String)"MAX", (String)"\u6700\u5927\u503c")).addElement(EnumType.Element.of((String)"MIN", (String)"\u6700\u5c0f\u503c")).addElement(EnumType.Element.of((String)"AVG", (String)"\u5e73\u5c40\u503c"))).add("limit", "\u6700\u5927\u6570\u636e\u91cf", "", (DataType)new IntType()).add("from", "\u65f6\u95f4\u4ece", "", (DataType)new DateTimeType().format("yyyy-MM-dd HH:mm:ss")).add("to", "\u65f6\u95f4\u81f3", "", (DataType)new DateTimeType().format("yyyy-MM-dd HH:mm:ss"));

    public DeviceGatewayMeasurement(MeasurementDefinition definition, String property, Aggregation defaultAgg, TimeSeriesManager timeSeriesManager) {
        super(definition);
        this.timeSeriesManager = timeSeriesManager;
        this.defaultAgg = defaultAgg;
        this.type = definition.getId();
        this.property = property;
        this.addDimension(new AggDeviceStateDimension());
        this.addDimension(new HistoryDimension());
    }

    class AggDeviceStateDimension
    implements MeasurementDimension {
        AggDeviceStateDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.agg;
        }

        public DataType getValueType() {
            return new IntType();
        }

        public ConfigMetadata getParams() {
            return aggConfigMetadata;
        }

        public boolean isRealTime() {
            return false;
        }

        public Flux<SimpleMeasurementValue> getValue(MeasurementParameter parameter) {
            return ((Flux)AggregationQueryParam.of().agg(DeviceGatewayMeasurement.this.property, parameter.get("agg", Aggregation.class).orElse(DeviceGatewayMeasurement.this.defaultAgg)).groupBy(parameter.getInterval("time").orElse(Interval.ofHours((int)1)), "time", parameter.getString("format").orElse("MM-dd:HH")).filter(query -> {
                Query cfr_ignored_0 = (Query)((Query)query.where("target", (Object)DeviceGatewayMeasurement.this.type)).is("name", parameter.getString("gatewayId").orElse(null));
            }).limit(parameter.getInt("limit").orElse(1).intValue()).from(parameter.getDate("from").orElseGet(() -> Date.from(LocalDateTime.now().plusDays(-1L).atZone(ZoneId.systemDefault()).toInstant()))).to(parameter.getDate("to").orElse(new Date())).execute(arg_0 -> ((TimeSeriesService)DeviceGatewayMeasurement.this.timeSeriesManager.getService(GatewayTimeSeriesMetric.deviceGatewayMetric())).aggregation(arg_0))).index((index, data) -> SimpleMeasurementValue.of((Object)data.getInt(DeviceGatewayMeasurement.this.property).orElse(0), (String)data.getString("time").orElse(""), (long)index)).sort();
        }
    }

    class HistoryDimension
    implements MeasurementDimension {
        HistoryDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.history;
        }

        public DataType getValueType() {
            return new IntType();
        }

        public ConfigMetadata getParams() {
            return historyConfigMetadata;
        }

        public boolean isRealTime() {
            return false;
        }

        public Flux<SimpleMeasurementValue> getValue(MeasurementParameter parameter) {
            return ((Flux)((Query)((Query)((Query)QueryParamEntity.newQuery().where("target", (Object)DeviceGatewayMeasurement.this.type)).is("name", parameter.getString("gatewayId").orElse(null))).doPaging(0, parameter.getInt("limit").orElse(1).intValue()).between("timestamp", (Object)parameter.getDate("from").orElseGet(() -> Date.from(LocalDateTime.now().plusDays(-1L).atZone(ZoneId.systemDefault()).toInstant())), (Object)parameter.getDate("to").orElseGet(Date::new))).execute(arg_0 -> ((TimeSeriesService)DeviceGatewayMeasurement.this.timeSeriesManager.getService(GatewayTimeSeriesMetric.deviceGatewayMetric())).query(arg_0))).map(data -> SimpleMeasurementValue.of((Object)data.getInt(DeviceGatewayMeasurement.this.property).orElse(0), (long)data.getTimestamp())).sort(MeasurementValue.sort());
        }
    }
}

