/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway.monitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.jetlinks.community.gateway.monitor.DeviceGatewayMonitor;

class CompositeDeviceGatewayMonitor
implements DeviceGatewayMonitor {
    private List<DeviceGatewayMonitor> monitors = new ArrayList<DeviceGatewayMonitor>();

    CompositeDeviceGatewayMonitor() {
    }

    public CompositeDeviceGatewayMonitor add(DeviceGatewayMonitor ... monitors) {
        return this.add(Arrays.asList(monitors));
    }

    public CompositeDeviceGatewayMonitor add(Collection<DeviceGatewayMonitor> monitors) {
        this.monitors.addAll(monitors);
        return this;
    }

    protected void doWith(Consumer<DeviceGatewayMonitor> monitorConsumer) {
        this.monitors.forEach(monitorConsumer);
    }

    @Override
    public void totalConnection(long total) {
        this.doWith(monitor -> monitor.totalConnection(total));
    }

    @Override
    public void connected() {
        this.doWith(DeviceGatewayMonitor::connected);
    }

    @Override
    public void rejected() {
        this.doWith(DeviceGatewayMonitor::rejected);
    }

    @Override
    public void disconnected() {
        this.doWith(DeviceGatewayMonitor::disconnected);
    }

    @Override
    public void receivedMessage() {
        this.doWith(DeviceGatewayMonitor::receivedMessage);
    }

    @Override
    public void sentMessage() {
        this.doWith(DeviceGatewayMonitor::sentMessage);
    }
}

