/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway.external;

import org.jetlinks.community.gateway.external.SimpleMessage;

public interface Message {
    public String getRequestId();

    public String getTopic();

    public Object getPayload();

    public String getMessage();

    public Type getType();

    public static Message authError() {
        return new SimpleMessage(null, null, null, Type.authError, "\u8ba4\u8bc1\u5931\u8d25");
    }

    public static Message error(String id, String topic, String message) {
        return new SimpleMessage(id, topic, null, Type.error, message);
    }

    public static Message error(String id, String topic, Throwable message) {
        return new SimpleMessage(id, topic, null, Type.error, message.getMessage() == null ? message.getClass().getSimpleName() : message.getMessage());
    }

    public static Message success(String id, String topic, Object payload) {
        return new SimpleMessage(id, topic, payload, Type.result, null);
    }

    public static Message complete(String id) {
        return new SimpleMessage(id, null, null, Type.complete, null);
    }

    public static Message pong(String id) {
        return new SimpleMessage(id, null, null, Type.pong, null);
    }

    public static enum Type {
        authError,
        result,
        error,
        complete,
        ping,
        pong;

    }
}

