/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.timeseries;

import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.jetlinks.community.elastic.search.service.AggregationService;
import org.jetlinks.community.elastic.search.service.ElasticSearchService;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.timeseries.TimeSeriesService;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.community.timeseries.query.AggregationQueryParam;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ElasticSearchTimeSeriesService
implements TimeSeriesService {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchTimeSeriesService.class);
    private final String[] index;
    private final ElasticSearchService elasticSearchService;
    private final AggregationService aggregationService;
    static DateTimeType timeType = DateTimeType.GLOBAL;

    public Flux<TimeSeriesData> query(QueryParam queryParam) {
        return this.elasticSearchService.query(this.index, this.applySort(queryParam), map -> TimeSeriesData.of((Date)timeType.convert(map.get("timestamp")), (Map)map));
    }

    public Flux<TimeSeriesData> multiQuery(Collection<QueryParam> query) {
        return this.elasticSearchService.multiQuery(this.index, (Collection<QueryParam>)query.stream().peek(this::applySort).collect(Collectors.toList()), map -> TimeSeriesData.of((Date)timeType.convert(map.get("timestamp")), (Map)map));
    }

    public Mono<Integer> count(QueryParam queryParam) {
        return this.elasticSearchService.count(this.index, queryParam).map(Long::intValue);
    }

    public Mono<PagerResult<TimeSeriesData>> queryPager(QueryParam queryParam) {
        return this.elasticSearchService.queryPager(this.index, this.applySort(queryParam), map -> TimeSeriesData.of((Date)timeType.convert(map.get("timestamp")), (Map)map));
    }

    public <T> Mono<PagerResult<T>> queryPager(QueryParam queryParam, Function<TimeSeriesData, T> mapper) {
        return this.elasticSearchService.queryPager(this.index, this.applySort(queryParam), map -> mapper.apply(TimeSeriesData.of((Date)timeType.convert(map.get("timestamp")), (Map)map)));
    }

    public Flux<AggregationData> aggregation(AggregationQueryParam queryParam) {
        return this.aggregationService.aggregation(this.index, queryParam).onErrorResume(err -> {
            log.error(err.getMessage(), err);
            return Mono.empty();
        }).map(AggregationData::of);
    }

    protected QueryParam applySort(QueryParam param) {
        if (CollectionUtils.isEmpty((Collection)param.getSorts())) {
            param.orderBy("timestamp").desc();
        }
        return param;
    }

    public Mono<Void> commit(Publisher<TimeSeriesData> data) {
        return Flux.from(data).flatMap(this::commit).then();
    }

    public Mono<Void> commit(TimeSeriesData data) {
        Map mapData = data.getData();
        mapData.put("timestamp", data.getTimestamp());
        return this.elasticSearchService.commit(this.index[0], mapData);
    }

    public Mono<Void> save(Publisher<TimeSeriesData> dateList) {
        return this.elasticSearchService.save(this.index[0], Flux.from(dateList).map(data -> {
            Map mapData = data.getData();
            mapData.put("timestamp", data.getTimestamp());
            return mapData;
        }));
    }

    public ElasticSearchTimeSeriesService(String[] index, ElasticSearchService elasticSearchService, AggregationService aggregationService) {
        this.index = index;
        this.elasticSearchService = elasticSearchService;
        this.aggregationService = aggregationService;
    }
}

