/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.index.strategies;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.IndexTemplateMetadata;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexProperties;
import org.jetlinks.community.elastic.search.index.strategies.AbstractElasticSearchIndexStrategy;
import org.jetlinks.community.elastic.search.service.reactive.ReactiveElasticsearchClient;
import reactor.core.publisher.Mono;

public abstract class TemplateElasticSearchIndexStrategy
extends AbstractElasticSearchIndexStrategy {
    public TemplateElasticSearchIndexStrategy(String id, ReactiveElasticsearchClient client, ElasticSearchIndexProperties properties) {
        super(id, client, properties);
    }

    protected String getTemplate(String index) {
        return this.wrapIndex(index).concat("_template");
    }

    protected String getAlias(String index) {
        return this.wrapIndex(index).concat("_alias");
    }

    protected List<String> getIndexPatterns(String index) {
        return Collections.singletonList(this.wrapIndex(index).concat("*"));
    }

    @Override
    public abstract String getIndexForSave(String var1);

    @Override
    public String getIndexForSearch(String index) {
        return this.getAlias(index);
    }

    @Override
    public Mono<ElasticSearchIndexMetadata> putIndex(ElasticSearchIndexMetadata metadata) {
        return this.client.putTemplate(this.createIndexTemplateRequest(metadata)).then(this.doPutIndex(metadata.newIndexName(this.getIndexForSave(metadata.getIndex())), true)).thenReturn((Object)metadata.newIndexName(this.wrapIndex(metadata.getIndex())));
    }

    protected PutIndexTemplateRequest createIndexTemplateRequest(ElasticSearchIndexMetadata metadata) {
        String index = this.wrapIndex(metadata.getIndex());
        PutIndexTemplateRequest request = new PutIndexTemplateRequest(this.getTemplate(index));
        request.alias(new Alias(this.getAlias(index)));
        request.settings(this.properties.toSettings());
        HashMap<String, Object> mappingConfig = new HashMap<String, Object>();
        mappingConfig.put("properties", this.createElasticProperties(metadata.getProperties()));
        mappingConfig.put("dynamic_templates", this.createDynamicTemplates());
        if (this.client.serverVersion().after(Version.V_7_0_0)) {
            request.mapping(mappingConfig);
        } else {
            request.mapping(Collections.singletonMap("_doc", mappingConfig));
        }
        request.patterns(this.getIndexPatterns(index));
        return request;
    }

    @Override
    public Mono<ElasticSearchIndexMetadata> loadIndexMetadata(String index) {
        return this.client.getTemplate(new GetIndexTemplatesRequest(new String[]{this.getTemplate(index)})).filter(resp -> CollectionUtils.isNotEmpty((Collection)resp.getIndexTemplates())).flatMap(resp -> Mono.justOrEmpty((Object)this.convertMetadata(index, ((IndexTemplateMetadata)resp.getIndexTemplates().get(0)).mappings())));
    }
}

