/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.aggreation.metrics;

import lombok.NonNull;
import org.hswebframework.utils.StringUtils;
import org.jetlinks.community.elastic.search.aggreation.enums.MetricsType;

public class MetricsAggregationStructure {
    @NonNull
    private String field;
    private String name;
    @NonNull
    private MetricsType type = MetricsType.COUNT;
    private Object missingValue;

    public String getName() {
        if (StringUtils.isNullOrEmpty((Object)this.name)) {
            this.name = this.type.name().concat("_").concat(this.field);
        }
        return this.name;
    }

    public static MetricsAggregationStructureBuilder builder() {
        return new MetricsAggregationStructureBuilder();
    }

    public void setField(@NonNull String field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        this.field = field;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(@NonNull MetricsType type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    public void setMissingValue(Object missingValue) {
        this.missingValue = missingValue;
    }

    @NonNull
    public String getField() {
        return this.field;
    }

    @NonNull
    public MetricsType getType() {
        return this.type;
    }

    public Object getMissingValue() {
        return this.missingValue;
    }

    public MetricsAggregationStructure(@NonNull String field, String name, @NonNull MetricsType type, Object missingValue) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.field = field;
        this.name = name;
        this.type = type;
        this.missingValue = missingValue;
    }

    public MetricsAggregationStructure() {
    }

    public static class MetricsAggregationStructureBuilder {
        private String field;
        private String name;
        private MetricsType type;
        private Object missingValue;

        MetricsAggregationStructureBuilder() {
        }

        public MetricsAggregationStructureBuilder field(@NonNull String field) {
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.field = field;
            return this;
        }

        public MetricsAggregationStructureBuilder name(String name) {
            this.name = name;
            return this;
        }

        public MetricsAggregationStructureBuilder type(@NonNull MetricsType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public MetricsAggregationStructureBuilder missingValue(Object missingValue) {
            this.missingValue = missingValue;
            return this;
        }

        public MetricsAggregationStructure build() {
            return new MetricsAggregationStructure(this.field, this.name, this.type, this.missingValue);
        }

        public String toString() {
            return "MetricsAggregationStructure.MetricsAggregationStructureBuilder(field=" + this.field + ", name=" + this.name + ", type=" + (Object)((Object)this.type) + ", missingValue=" + this.missingValue + ")";
        }
    }
}

