/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.utils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.utils.QueryParamTranslator;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.GeoPoint;
import org.jetlinks.core.metadata.types.GeoShape;
import org.jetlinks.core.metadata.types.GeoShapeType;
import org.jetlinks.core.metadata.types.GeoType;

public class ElasticSearchConverter {
    public static SearchSourceBuilder convertSearchSourceBuilder(QueryParam queryParam, ElasticSearchIndexMetadata metadata) {
        return QueryParamTranslator.convertSearchSourceBuilder(queryParam, metadata);
    }

    public static Map<String, Object> convertDataToElastic(Map<String, Object> data, List<PropertyMetadata> properties) {
        HashMap<String, Object> newValue = new HashMap<String, Object>(data);
        for (PropertyMetadata property : properties) {
            HashMap<String, Object> geoData;
            DataType type = property.getValueType();
            Object val = data.get(property.getId());
            if (val == null) continue;
            if (type instanceof GeoType) {
                GeoPoint point = ((GeoType)type).convert(val);
                geoData = new HashMap<String, Object>();
                geoData.put("lat", point.getLat());
                geoData.put("lon", point.getLon());
                newValue.put(property.getId(), geoData);
                continue;
            }
            if (type instanceof GeoShapeType) {
                GeoShape shape = ((GeoShapeType)type).convert(val);
                if (shape == null) {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684GeoShape\u683c\u5f0f:" + val);
                }
                geoData = new HashMap();
                geoData.put("type", shape.getType().name());
                geoData.put("coordinates", shape.getCoordinates());
                newValue.put(property.getId(), geoData);
                continue;
            }
            if (type instanceof DateTimeType) {
                Date date = ((DateTimeType)type).convert(val);
                newValue.put(property.getId(), date.getTime());
                continue;
            }
            if (!(type instanceof Converter)) continue;
            newValue.put(property.getId(), ((Converter)type).convert(val));
        }
        return newValue;
    }

    public static Map<String, Object> convertDataFromElastic(Map<String, Object> data, List<PropertyMetadata> properties) {
        HashMap<String, Object> newData = new HashMap<String, Object>(data);
        for (PropertyMetadata property : properties) {
            DataType type = property.getValueType();
            Object val = newData.get(property.getId());
            if (val == null) continue;
            if (type instanceof GeoType) {
                newData.put(property.getId(), ((GeoType)type).convertToMap(val));
                continue;
            }
            if (type instanceof GeoShapeType) {
                newData.put(property.getId(), GeoShape.of(val).toMap());
                continue;
            }
            if (type instanceof DateTimeType) {
                Date date = ((DateTimeType)type).convert(val);
                newData.put(property.getId(), date);
                continue;
            }
            if (!(type instanceof Converter)) continue;
            newData.put(property.getId(), ((Converter)type).convert(val));
        }
        return newData;
    }
}

