/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.service.reactive;

import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.CardinalityAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ExtendedStatsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.MedianAbsoluteDeviationAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.MinAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.StatsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.SumAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.ValueCountAggregationBuilder;

public enum AggType {
    AVG("\u5e73\u5747"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return ((AvgAggregationBuilder)AggregationBuilders.avg((String)name).field(filed)).missing((Object)0);
        }
    }
    ,
    MAX("\u6700\u5927"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return ((MaxAggregationBuilder)AggregationBuilders.max((String)name).field(filed)).missing((Object)0);
        }
    }
    ,
    MEDIAN("\u4e2d\u95f4\u503c"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return ((MedianAbsoluteDeviationAggregationBuilder)AggregationBuilders.medianAbsoluteDeviation((String)name).field(filed)).missing((Object)0);
        }
    }
    ,
    STDDEV("\u6807\u51c6\u5dee"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return ((ExtendedStatsAggregationBuilder)AggregationBuilders.extendedStats((String)name).field(filed)).missing((Object)0);
        }
    }
    ,
    COUNT("\u975e\u7a7a\u503c\u8ba1\u6570"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return ((ValueCountAggregationBuilder)AggregationBuilders.count((String)name).field(filed)).missing((Object)0);
        }
    }
    ,
    DISTINCT_COUNT("\u53bb\u91cd\u8ba1\u6570"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return ((CardinalityAggregationBuilder)AggregationBuilders.cardinality((String)name).field(filed)).missing((Object)0);
        }
    }
    ,
    MIN("\u6700\u5c0f"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return ((MinAggregationBuilder)AggregationBuilders.min((String)name).field(filed)).missing((Object)0);
        }
    }
    ,
    FIRST("\u7b2c\u4e00\u6761\u6570\u636e"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return AggregationBuilders.topHits((String)name).size(1);
        }
    }
    ,
    TOP("\u7b2cN\u6761\u6570\u636e"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return AggregationBuilders.topHits((String)name);
        }
    }
    ,
    SUM("\u603b\u6570"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return ((SumAggregationBuilder)AggregationBuilders.sum((String)name).field(filed)).missing((Object)0);
        }
    }
    ,
    STATS("\u7edf\u8ba1\u6c47\u603b"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return ((StatsAggregationBuilder)AggregationBuilders.stats((String)name).field(filed)).missing((Object)0);
        }
    };

    private final String text;

    public abstract AggregationBuilder aggregationBuilder(String var1, String var2);

    public static AggType of(String name) {
        for (AggType type : AggType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u805a\u5408\u7c7b\u578b\uff1a" + name);
    }

    private AggType(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }
}

