/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.parser;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.hswebframework.ezorm.core.param.Term;
import org.jetlinks.community.elastic.search.parser.DefaultTermTypeParser;
import org.jetlinks.community.elastic.search.parser.LinkTypeParser;
import org.jetlinks.community.elastic.search.parser.TermTypeParser;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DefaultLinkTypeParser
implements LinkTypeParser {
    private final TermTypeParser parser = new DefaultTermTypeParser();

    @Override
    public BoolQueryBuilder process(Term term, Consumer<Term> consumer, BoolQueryBuilder queryBuilders) {
        if (term.getValue() == null && CollectionUtils.isEmpty((Collection)term.getTerms())) {
            return queryBuilders;
        }
        if (term.getType() == Term.Type.or) {
            this.handleOr(queryBuilders, term, consumer);
        } else {
            this.handleAnd(queryBuilders, term, consumer);
        }
        return queryBuilders;
    }

    private void handleOr(BoolQueryBuilder queryBuilders, Term term, Consumer<Term> consumer) {
        consumer.accept(term);
        if (term.getTerms().isEmpty() && term.getValue() != null) {
            this.parser.process(() -> term, arg_0 -> ((BoolQueryBuilder)queryBuilders).should(arg_0));
        } else {
            BoolQueryBuilder nextQuery = QueryBuilders.boolQuery();
            List terms = term.getTerms();
            terms.forEach(t -> this.process((Term)t, consumer, nextQuery));
            queryBuilders.should((QueryBuilder)nextQuery);
        }
    }

    private void handleAnd(BoolQueryBuilder queryBuilders, Term term, Consumer<Term> consumer) {
        consumer.accept(term);
        if (term.getTerms().isEmpty() && term.getValue() != null) {
            this.parser.process(() -> term, arg_0 -> ((BoolQueryBuilder)queryBuilders).must(arg_0));
        } else {
            BoolQueryBuilder nextQuery = QueryBuilders.boolQuery();
            List terms = term.getTerms();
            terms.forEach(t -> this.process((Term)t, consumer, nextQuery));
            queryBuilders.must((QueryBuilder)nextQuery);
        }
    }
}

