/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.configuration;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.jetlinks.community.elastic.search.embedded.EmbeddedElasticSearch;
import org.jetlinks.community.elastic.search.embedded.EmbeddedElasticSearchProperties;
import org.jetlinks.community.elastic.search.index.DefaultElasticSearchIndexManager;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexManager;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexProperties;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexStrategy;
import org.jetlinks.community.elastic.search.index.strategies.DirectElasticSearchIndexStrategy;
import org.jetlinks.community.elastic.search.index.strategies.TimeByMonthElasticSearchIndexStrategy;
import org.jetlinks.community.elastic.search.service.AggregationService;
import org.jetlinks.community.elastic.search.service.ElasticSearchService;
import org.jetlinks.community.elastic.search.service.reactive.DefaultReactiveElasticsearchClient;
import org.jetlinks.community.elastic.search.service.reactive.ElasticSearchBufferProperties;
import org.jetlinks.community.elastic.search.service.reactive.ReactiveAggregationService;
import org.jetlinks.community.elastic.search.service.reactive.ReactiveElasticSearchService;
import org.jetlinks.community.elastic.search.service.reactive.ReactiveElasticsearchClient;
import org.jetlinks.community.elastic.search.timeseries.ElasticSearchTimeSeriesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.elasticsearch.ReactiveElasticsearchRestClientAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.reactive.HostProvider;
import org.springframework.data.elasticsearch.client.reactive.RequestCreator;
import org.springframework.data.elasticsearch.client.reactive.WebClientProvider;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={EmbeddedElasticSearchProperties.class, ElasticSearchIndexProperties.class, ElasticSearchBufferProperties.class})
@AutoConfigureAfter(value={ReactiveElasticsearchRestClientAutoConfiguration.class})
@ConditionalOnBean(value={ClientConfiguration.class})
@Generated
public class ElasticSearchConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchConfiguration.class);

    @Bean
    @Primary
    public DefaultReactiveElasticsearchClient defaultReactiveElasticsearchClient(EmbeddedElasticSearchProperties embeddedProperties, ClientConfiguration clientConfiguration) {
        if (embeddedProperties.isEnabled()) {
            log.debug("starting embedded elasticsearch on {}:{}", (Object)embeddedProperties.getHost(), (Object)embeddedProperties.getPort());
            new EmbeddedElasticSearch(embeddedProperties).start();
        }
        WebClientProvider provider = ElasticSearchConfiguration.getWebClientProvider(clientConfiguration);
        HostProvider hostProvider = HostProvider.provider((WebClientProvider)provider, (Supplier)clientConfiguration.getHeadersSupplier(), (InetSocketAddress[])clientConfiguration.getEndpoints().toArray(new InetSocketAddress[0]));
        DefaultReactiveElasticsearchClient client = new DefaultReactiveElasticsearchClient(hostProvider, new RequestCreator(){});
        client.setHeadersSupplier(clientConfiguration.getHeadersSupplier());
        return client;
    }

    private static WebClientProvider getWebClientProvider(ClientConfiguration clientConfiguration) {
        return WebClientProvider.getWebClientProvider((ClientConfiguration)clientConfiguration);
    }

    @Bean
    public DirectElasticSearchIndexStrategy directElasticSearchIndexStrategy(ReactiveElasticsearchClient elasticsearchClient, ElasticSearchIndexProperties indexProperties) {
        return new DirectElasticSearchIndexStrategy(elasticsearchClient, indexProperties);
    }

    @Bean
    public TimeByMonthElasticSearchIndexStrategy timeByMonthElasticSearchIndexStrategy(ReactiveElasticsearchClient elasticsearchClient, ElasticSearchIndexProperties indexProperties) {
        return new TimeByMonthElasticSearchIndexStrategy(elasticsearchClient, indexProperties);
    }

    @Bean
    public DefaultElasticSearchIndexManager elasticSearchIndexManager(@Autowired(required=false) List<ElasticSearchIndexStrategy> strategies) {
        return new DefaultElasticSearchIndexManager(strategies);
    }

    @Bean
    @ConditionalOnMissingBean(value={ElasticSearchService.class})
    public ReactiveElasticSearchService reactiveElasticSearchService(ReactiveElasticsearchClient elasticsearchClient, ElasticSearchIndexManager indexManager, ElasticSearchBufferProperties properties) {
        return new ReactiveElasticSearchService(elasticsearchClient, indexManager, properties);
    }

    @Bean
    public ReactiveAggregationService reactiveAggregationService(ElasticSearchIndexManager indexManager, ReactiveElasticsearchClient restClient) {
        return new ReactiveAggregationService(indexManager, restClient);
    }

    @Bean
    public ElasticSearchTimeSeriesManager elasticSearchTimeSeriesManager(ElasticSearchIndexManager indexManager, ElasticSearchService elasticSearchService, AggregationService aggregationService) {
        return new ElasticSearchTimeSeriesManager(indexManager, elasticSearchService, aggregationService);
    }
}

