/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.service.reactive;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.util.EntityUtils;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.main.MainRequest;
import org.elasticsearch.action.main.MainResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetFieldMappingsRequest;
import org.elasticsearch.client.indices.GetFieldMappingsResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesResponse;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.GetMappingsResponse;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.client.tasks.TaskSubmissionResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.jetlinks.community.elastic.search.service.reactive.RawActionResponse;
import org.jetlinks.community.elastic.search.service.reactive.ReactiveElasticsearchClient;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.client.ClientLogger;
import org.springframework.data.elasticsearch.client.ElasticsearchHost;
import org.springframework.data.elasticsearch.client.NoReachableHostException;
import org.springframework.data.elasticsearch.client.reactive.HostProvider;
import org.springframework.data.elasticsearch.client.reactive.ReactiveElasticsearchClient;
import org.springframework.data.elasticsearch.client.reactive.RequestCreator;
import org.springframework.data.elasticsearch.client.util.NamedXContents;
import org.springframework.data.elasticsearch.client.util.RequestConverters;
import org.springframework.data.elasticsearch.client.util.ScrollState;
import org.springframework.data.elasticsearch.core.ResponseConverter;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.util.Lazy;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.function.Function3;

@Generated
public class DefaultReactiveElasticsearchClient
implements ReactiveElasticsearchClient,
ReactiveElasticsearchClient.Cluster {
    private static final Logger log = LoggerFactory.getLogger(DefaultReactiveElasticsearchClient.class);
    private final HostProvider<?> hostProvider;
    private final RequestCreator requestCreator;
    private Supplier<HttpHeaders> headersSupplier = () -> HttpHeaders.EMPTY;
    private Version version = Version.CURRENT;

    public DefaultReactiveElasticsearchClient(HostProvider hostProvider, RequestCreator requestCreator) {
        Assert.notNull((Object)hostProvider, (String)"HostProvider must not be null");
        Assert.notNull((Object)requestCreator, (String)"RequestCreator must not be null");
        this.hostProvider = hostProvider;
        this.requestCreator = requestCreator;
        this.version = ((MainResponse)this.info().block(Duration.ofSeconds(10L))).getVersion();
    }

    public void setHeadersSupplier(Supplier<HttpHeaders> headersSupplier) {
        Assert.notNull(headersSupplier, (String)"headersSupplier must not be null");
        this.headersSupplier = headersSupplier;
    }

    public Mono<Boolean> ping(HttpHeaders headers) {
        return this.sendRequest((ActionRequest)new MainRequest(), this.requestCreator.ping(), (Class)RawActionResponse.class, headers).flatMap(response -> response.releaseBody().thenReturn((Object)response.statusCode().is2xxSuccessful())).onErrorResume(NoReachableHostException.class, error -> Mono.just((Object)false)).next();
    }

    public Mono<MainResponse> info(HttpHeaders headers) {
        return this.sendRequest((ActionRequest)new MainRequest(), this.requestCreator.info(), (Class)MainResponse.class, headers).next();
    }

    public Mono<GetResult> get(HttpHeaders headers, GetRequest getRequest) {
        return this.sendRequest((ActionRequest)getRequest, this.requestCreator.get(), (Class)GetResponse.class, headers).filter(GetResponse::isExists).map(DefaultReactiveElasticsearchClient::getResponseToGetResult).next();
    }

    public Flux<MultiGetItemResponse> multiGet(HttpHeaders headers, MultiGetRequest multiGetRequest) {
        return this.sendRequest((ActionRequest)multiGetRequest, this.requestCreator.multiGet(), (Class)MultiGetResponse.class, headers).map(MultiGetResponse::getResponses).flatMap(Flux::fromArray);
    }

    public Mono<Boolean> exists(HttpHeaders headers, GetRequest getRequest) {
        return this.sendRequest((ActionRequest)getRequest, this.requestCreator.exists(), (Class)RawActionResponse.class, headers).flatMap(response -> response.releaseBody().thenReturn((Object)response.statusCode().is2xxSuccessful())).next();
    }

    public Mono<IndexResponse> index(HttpHeaders headers, IndexRequest indexRequest) {
        return this.sendRequest((ActionRequest)indexRequest, this.requestCreator.index(), (Class)IndexResponse.class, headers).publishNext();
    }

    public ReactiveElasticsearchClient.Indices indices() {
        return this;
    }

    public ReactiveElasticsearchClient.Cluster cluster() {
        return this;
    }

    public Mono<UpdateResponse> update(HttpHeaders headers, UpdateRequest updateRequest) {
        return this.sendRequest((ActionRequest)updateRequest, this.requestCreator.update(), (Class)UpdateResponse.class, headers).publishNext();
    }

    public Mono<DeleteResponse> delete(HttpHeaders headers, DeleteRequest deleteRequest) {
        return this.sendRequest((ActionRequest)deleteRequest, this.requestCreator.delete(), (Class)DeleteResponse.class, headers).publishNext();
    }

    public Mono<Long> count(HttpHeaders headers, SearchRequest searchRequest) {
        searchRequest.source().trackTotalHits(true);
        searchRequest.source().size(0);
        searchRequest.source().fetchSource(false);
        return this.sendRequest((ActionRequest)searchRequest, (Function)this::buildSearchRequest, (Class)SearchResponse.class, headers).map(SearchResponse::getHits).map(searchHits -> searchHits.getTotalHits().value).next();
    }

    public Flux<SearchHit> searchTemplate(HttpHeaders headers, SearchTemplateRequest searchTemplateRequest) {
        return this.sendRequest((ActionRequest)searchTemplateRequest, this.requestCreator.searchTemplate(), (Class)SearchTemplateResponse.class, headers).map(response -> response.getResponse().getHits()).flatMap(Flux::fromIterable);
    }

    protected Request buildSearchRequest(SearchRequest request) {
        if (this.version.before(Version.V_7_0_0) && request.source().trackTotalHitsUpTo() != -1) {
            Request req = (Request)this.requestCreator.search().apply(request);
            JSONObject json = JSON.parseObject((String)this.requestBodyToString(req));
            json.put("track_total_hits", (Object)true);
            req.setJsonEntity(json.toJSONString());
            return req;
        }
        return (Request)this.requestCreator.search().apply(request);
    }

    public Flux<SearchHit> search(HttpHeaders headers, SearchRequest searchRequest) {
        return this.sendRequest((ActionRequest)searchRequest, (Function)this::buildSearchRequest, (Class)SearchResponse.class, headers).map(SearchResponse::getHits).flatMap(Flux::fromIterable);
    }

    public Mono<SearchResponse> searchForResponse(HttpHeaders headers, SearchRequest searchRequest) {
        return this.sendRequest((ActionRequest)searchRequest, this.requestCreator.search(), (Class)SearchResponse.class, headers).next();
    }

    public Flux<Suggest> suggest(HttpHeaders headers, SearchRequest searchRequest) {
        return this.sendRequest((ActionRequest)searchRequest, this.requestCreator.search(), (Class)SearchResponse.class, headers).map(SearchResponse::getSuggest);
    }

    public Flux<Aggregation> aggregate(HttpHeaders headers, SearchRequest searchRequest) {
        Assert.notNull((Object)headers, (String)"headers must not be null");
        Assert.notNull((Object)searchRequest, (String)"searchRequest must not be null");
        searchRequest.source().size(0);
        searchRequest.source().trackTotalHits(false);
        return this.sendRequest((ActionRequest)searchRequest, (Function)this::buildSearchRequest, (Class)SearchResponse.class, headers).map(SearchResponse::getAggregations).flatMap(Flux::fromIterable);
    }

    @Nonnull
    public Flux<SearchHit> scroll(@Nonnull HttpHeaders headers, SearchRequest searchRequest) {
        TimeValue scrollTimeout;
        TimeValue timeValue = scrollTimeout = searchRequest.scroll() != null ? searchRequest.scroll().keepAlive() : TimeValue.timeValueMinutes((long)1L);
        if (searchRequest.scroll() == null) {
            searchRequest.scroll(scrollTimeout);
        }
        return Flux.usingWhen((Publisher)Mono.fromSupplier(ScrollState::new), state -> this.sendRequest((ActionRequest)searchRequest, this.requestCreator.search(), (Class)SearchResponse.class, headers).expand(searchResponse -> {
            state.updateScrollId(searchResponse.getScrollId());
            if (DefaultReactiveElasticsearchClient.isEmpty(searchResponse.getHits())) {
                return Mono.empty();
            }
            return this.sendRequest((ActionRequest)new SearchScrollRequest(searchResponse.getScrollId()).scroll(scrollTimeout), this.requestCreator.scroll(), (Class)SearchResponse.class, headers);
        }), state -> this.cleanupScroll(headers, (ScrollState)state), (state, ex) -> this.cleanupScroll(headers, (ScrollState)state), state -> this.cleanupScroll(headers, (ScrollState)state)).filter(it -> !DefaultReactiveElasticsearchClient.isEmpty(it.getHits())).map(SearchResponse::getHits).flatMapIterable(Function.identity());
    }

    private static boolean isEmpty(@Nullable SearchHits hits) {
        return hits != null && hits.getHits() != null && hits.getHits().length == 0;
    }

    private Publisher<?> cleanupScroll(HttpHeaders headers, ScrollState state) {
        if (state.getScrollIds().isEmpty()) {
            return Mono.empty();
        }
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.scrollIds(state.getScrollIds());
        return this.sendRequest((ActionRequest)clearScrollRequest, this.requestCreator.clearScroll(), (Class)ClearScrollResponse.class, headers);
    }

    public Mono<BulkByScrollResponse> deleteBy(HttpHeaders headers, DeleteByQueryRequest deleteRequest) {
        return this.sendRequest((ActionRequest)deleteRequest, this.requestCreator.deleteByQuery(), (Class)BulkByScrollResponse.class, headers).publishNext();
    }

    public Mono<ByQueryResponse> updateBy(HttpHeaders headers, UpdateByQueryRequest updateRequest) {
        return this.sendRequest((ActionRequest)updateRequest, this.requestCreator.updateByQuery(), (Class)BulkByScrollResponse.class, headers).next().map(ResponseConverter::byQueryResponseOf);
    }

    static XContentType enforceSameContentType(IndexRequest indexRequest, @Nullable XContentType xContentType) {
        XContentType requestContentType = indexRequest.getContentType();
        if (requestContentType != XContentType.JSON && requestContentType != XContentType.SMILE) {
            throw new IllegalArgumentException("Unsupported content-type found for request with content-type [" + requestContentType + "], only JSON and SMILE are supported");
        }
        if (xContentType == null) {
            return requestContentType;
        }
        if (requestContentType != xContentType) {
            throw new IllegalArgumentException("Mismatching content-type found for request with content-type [" + requestContentType + "], previous requests have content-type [" + xContentType + ']');
        }
        return xContentType;
    }

    Request convertBulk(BulkRequest bulkRequest) {
        Request request = new Request(HttpMethod.POST.name(), "/_bulk");
        Params parameters = new Params(request);
        parameters.withTimeout(bulkRequest.timeout());
        parameters.withRefreshPolicy(bulkRequest.getRefreshPolicy());
        XContentType bulkContentType = null;
        for (int i = 0; i < bulkRequest.numberOfActions(); ++i) {
            DocWriteRequest action = (DocWriteRequest)bulkRequest.requests().get(i);
            DocWriteRequest.OpType opType = action.opType();
            if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                bulkContentType = DefaultReactiveElasticsearchClient.enforceSameContentType((IndexRequest)action, bulkContentType);
                continue;
            }
            if (opType != DocWriteRequest.OpType.UPDATE) continue;
            UpdateRequest updateRequest = (UpdateRequest)action;
            if (updateRequest.doc() != null) {
                bulkContentType = DefaultReactiveElasticsearchClient.enforceSameContentType(updateRequest.doc(), bulkContentType);
            }
            if (updateRequest.upsertRequest() == null) continue;
            bulkContentType = DefaultReactiveElasticsearchClient.enforceSameContentType(updateRequest.upsertRequest(), bulkContentType);
        }
        if (bulkContentType == null) {
            bulkContentType = XContentType.JSON;
        }
        byte separator = bulkContentType.xContent().streamSeparator();
        ContentType requestContentType = RequestConverters.createContentType((XContentType)bulkContentType);
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        for (DocWriteRequest action : bulkRequest.requests()) {
            BytesRef source;
            block62: {
                DocWriteRequest.OpType opType = action.opType();
                try (XContentBuilder metadata = XContentBuilder.builder((XContent)bulkContentType.xContent());){
                    VersionType versionType;
                    metadata.startObject();
                    metadata.startObject(opType.getLowercase());
                    if (Strings.hasLength((String)action.index())) {
                        metadata.field("_index", action.index());
                    }
                    if (Strings.hasLength((String)action.type())) {
                        metadata.field("_type", action.type());
                    }
                    if (Strings.hasLength((String)action.id())) {
                        metadata.field("_id", action.id());
                    }
                    if (Strings.hasLength((String)action.routing())) {
                        metadata.field("routing", action.routing());
                    }
                    if (action.version() != -3L) {
                        metadata.field("version", action.version());
                    }
                    if ((versionType = action.versionType()) != VersionType.INTERNAL) {
                        if (versionType == VersionType.EXTERNAL) {
                            metadata.field("version_type", "external");
                        } else if (versionType == VersionType.EXTERNAL_GTE) {
                            metadata.field("version_type", "external_gte");
                        }
                    }
                    if (action.ifSeqNo() != -2L) {
                        metadata.field("if_seq_no", action.ifSeqNo());
                        metadata.field("if_primary_term", action.ifPrimaryTerm());
                    }
                    if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                        IndexRequest indexRequest = (IndexRequest)action;
                        if (Strings.hasLength((String)indexRequest.getPipeline())) {
                            metadata.field("pipeline", indexRequest.getPipeline());
                        }
                    } else if (opType == DocWriteRequest.OpType.UPDATE) {
                        UpdateRequest updateRequest = (UpdateRequest)action;
                        if (updateRequest.retryOnConflict() > 0) {
                            metadata.field("retry_on_conflict", updateRequest.retryOnConflict());
                        }
                        if (updateRequest.fetchSource() != null) {
                            metadata.field("_source", (ToXContent)updateRequest.fetchSource());
                        }
                    }
                    metadata.endObject();
                    metadata.endObject();
                    BytesRef metadataSource = BytesReference.bytes((XContentBuilder)metadata).toBytesRef();
                    content.write(metadataSource.bytes, metadataSource.offset, metadataSource.length);
                    content.write(separator);
                }
                source = null;
                if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                    IndexRequest indexRequest = (IndexRequest)action;
                    BytesReference indexSource = indexRequest.source();
                    XContentType indexXContentType = indexRequest.getContentType();
                    try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)indexSource, (XContentType)indexXContentType);
                         XContentBuilder builder = XContentBuilder.builder((XContent)bulkContentType.xContent());){
                        builder.copyCurrentStructure(parser);
                        source = BytesReference.bytes((XContentBuilder)builder).toBytesRef();
                        break block62;
                    }
                }
                if (opType == DocWriteRequest.OpType.UPDATE) {
                    source = XContentHelper.toXContent((ToXContent)((UpdateRequest)action), (XContentType)bulkContentType, (boolean)false).toBytesRef();
                }
            }
            if (source == null) continue;
            content.write(source.bytes, source.offset, source.length);
            content.write(separator);
        }
        request.setEntity((HttpEntity)new ByteArrayEntity(content.toByteArray(), 0, content.size(), requestContentType));
        return request;
    }

    public Mono<BulkResponse> bulk(HttpHeaders headers, BulkRequest bulkRequest) {
        return this.sendRequest((ActionRequest)bulkRequest, (Function)this::convertBulk, (Class)BulkResponse.class, headers).publishNext();
    }

    public Mono<BulkByScrollResponse> reindex(HttpHeaders headers, ReindexRequest reindexRequest) {
        return this.sendRequest((ActionRequest)reindexRequest, this.requestCreator.reindex(), (Class)BulkByScrollResponse.class, headers).next();
    }

    public Mono<String> submitReindex(HttpHeaders headers, ReindexRequest reindexRequest) {
        return this.sendRequest((ActionRequest)reindexRequest, this.requestCreator.submitReindex(), (Class)TaskSubmissionResponse.class, headers).next().map(TaskSubmissionResponse::getTask);
    }

    public Mono<Boolean> existsIndex(HttpHeaders headers, org.elasticsearch.action.admin.indices.get.GetIndexRequest request) {
        return this.sendRequest((ActionRequest)request, this.requestCreator.indexExists(), (Class)RawActionResponse.class, headers).flatMap(response -> response.releaseBody().thenReturn((Object)response.statusCode().is2xxSuccessful())).onErrorReturn((Object)false).next();
    }

    public Mono<Boolean> existsIndex(HttpHeaders headers, GetIndexRequest getIndexRequest) {
        return this.sendRequest((ActionRequest)getIndexRequest, this.requestCreator.indexExistsRequest(), (Class)RawActionResponse.class, headers).flatMap(response -> response.releaseBody().thenReturn((Object)response.statusCode().is2xxSuccessful())).next();
    }

    public Mono<Boolean> deleteIndex(HttpHeaders headers, DeleteIndexRequest request) {
        return this.sendRequest((ActionRequest)request, this.requestCreator.indexDelete(), (Class)AcknowledgedResponse.class, headers).map(AcknowledgedResponse::isAcknowledged).next();
    }

    public Mono<Boolean> createIndex(HttpHeaders headers, org.elasticsearch.action.admin.indices.create.CreateIndexRequest createIndexRequest) {
        return this.sendRequest((ActionRequest)createIndexRequest, this.requestCreator.indexCreate().andThen(request -> {
            request.addParameter("include_type_name", "true");
            return request;
        }), (Class)AcknowledgedResponse.class, headers).map(AcknowledgedResponse::isAcknowledged).next();
    }

    public Mono<Boolean> createIndex(HttpHeaders headers, CreateIndexRequest createIndexRequest) {
        return this.sendRequest((ActionRequest)createIndexRequest, this.requestCreator.createIndexRequest(), (Class)AcknowledgedResponse.class, headers).map(AcknowledgedResponse::isAcknowledged).next();
    }

    public Mono<Void> openIndex(HttpHeaders headers, OpenIndexRequest request) {
        return this.sendRequest((ActionRequest)request, this.requestCreator.indexOpen(), (Class)AcknowledgedResponse.class, headers).then();
    }

    public Mono<Void> closeIndex(HttpHeaders headers, CloseIndexRequest closeIndexRequest) {
        return this.sendRequest((ActionRequest)closeIndexRequest, this.requestCreator.indexClose(), (Class)AcknowledgedResponse.class, headers).then();
    }

    public Mono<Void> refreshIndex(HttpHeaders headers, RefreshRequest refreshRequest) {
        return this.sendRequest((ActionRequest)refreshRequest, this.requestCreator.indexRefresh(), (Class)RefreshResponse.class, headers).then();
    }

    public Mono<Boolean> putMapping(HttpHeaders headers, PutMappingRequest putMappingRequest) {
        return this.sendRequest((ActionRequest)putMappingRequest, this.requestCreator.putMapping(), (Class)AcknowledgedResponse.class, headers).map(AcknowledgedResponse::isAcknowledged).next();
    }

    public Mono<Boolean> putMapping(HttpHeaders headers, org.elasticsearch.client.indices.PutMappingRequest putMappingRequest) {
        return this.sendRequest((ActionRequest)putMappingRequest, (Function)this::createPutMapping, (Class)AcknowledgedResponse.class, headers).map(AcknowledgedResponse::isAcknowledged).next();
    }

    private Request createPutMapping(org.elasticsearch.client.indices.PutMappingRequest putMappingRequest) {
        Request request = (Request)this.requestCreator.putMappingRequest().apply(putMappingRequest);
        Request newReq = new Request(request.getMethod(), request.getEndpoint());
        Params params = new Params(newReq).withTimeout(putMappingRequest.timeout()).withMasterTimeout(putMappingRequest.masterNodeTimeout());
        if (this.serverVersion().before(Version.V_7_0_0)) {
            params.putParam("include_type_name", "false");
        }
        newReq.setEntity(request.getEntity());
        return newReq;
    }

    public Mono<Void> flushIndex(HttpHeaders headers, FlushRequest flushRequest) {
        return this.sendRequest((ActionRequest)flushRequest, this.requestCreator.flushIndex(), (Class)FlushResponse.class, headers).then();
    }

    public Mono<GetSettingsResponse> getSettings(HttpHeaders headers, GetSettingsRequest getSettingsRequest) {
        return this.sendRequest((ActionRequest)getSettingsRequest, this.requestCreator.getSettings(), (Class)GetSettingsResponse.class, headers).next();
    }

    public <T> Mono<T> execute(ReactiveElasticsearchClient.ReactiveElasticsearchClientCallback<T> callback) {
        return this.hostProvider.getActive(HostProvider.Verification.LAZY).flatMap(arg_0 -> callback.doWithClient(arg_0)).onErrorResume(throwable -> {
            if (this.isCausedByConnectionException((Throwable)throwable)) {
                return this.hostProvider.getActive(HostProvider.Verification.ACTIVE).flatMap(arg_0 -> ((ReactiveElasticsearchClient.ReactiveElasticsearchClientCallback)callback).doWithClient(arg_0));
            }
            return Mono.error((Throwable)throwable);
        });
    }

    private boolean isCausedByConnectionException(Throwable throwable) {
        Throwable t = throwable;
        do {
            if (!(t instanceof ConnectException)) continue;
            return true;
        } while ((t = t.getCause()) != null);
        return false;
    }

    public Mono<ReactiveElasticsearchClient.Status> status() {
        return this.hostProvider.clusterInfo().map(it -> new ClientStatus(it.getNodes()));
    }

    private static GetResult getResponseToGetResult(GetResponse response) {
        return new GetResult(response.getIndex(), response.getType(), response.getId(), response.getSeqNo(), response.getPrimaryTerm(), response.getVersion(), response.isExists(), response.getSourceAsBytesRef(), response.getFields(), null);
    }

    private <REQ, RESP> Flux<RESP> sendRequest(REQ request, Function<REQ, Request> converter, Class<RESP> responseType, HttpHeaders headers) {
        return this.sendRequest(converter.apply(request), responseType, headers);
    }

    private <Resp> Flux<Resp> sendRequest(Request request, Class<Resp> responseType, HttpHeaders headers) {
        String logId = ClientLogger.newLogId();
        return Flux.from(this.execute(webClient -> this.sendRequest(webClient, logId, request, headers).exchangeToMono(clientResponse -> {
            Publisher publisher = this.readResponseBody(logId, request, (ClientResponse)clientResponse, responseType);
            return Mono.from(publisher);
        })));
    }

    private <Req extends ActionRequest, Resp> Flux<Resp> sendRequest(Req request, Function<Req, Request> converter, Class<Resp> responseType, HttpHeaders headers) {
        return this.sendRequest(request, converter, responseType, headers, DefaultReactiveElasticsearchClient::doDecode);
    }

    private <Req extends ActionRequest, Resp> Flux<Resp> sendRequest(Req request, Function<Req, Request> converter, Class<Resp> responseType, HttpHeaders headers, Function3<ClientResponse, Class<Resp>, String, Mono<Resp>> decoder) {
        return this.sendRequest(converter.apply(request), responseType, headers, decoder);
    }

    private <Resp> Flux<Resp> sendRequest(Request request, Class<Resp> responseType, HttpHeaders headers, Function3<ClientResponse, Class<Resp>, String, Mono<Resp>> decoder) {
        String logId = ClientLogger.newLogId();
        return this.execute(webClient -> Mono.just((Object)this.sendRequest(webClient, logId, request, headers))).flatMapMany(spec -> spec.exchangeToFlux(response -> Flux.from(this.readResponseBody(logId, request, (ClientResponse)response, responseType, (Function3)decoder)).cast(responseType)));
    }

    private WebClient.RequestBodySpec sendRequest(WebClient webClient, String logId, Request request, HttpHeaders headers) {
        WebClient.RequestBodySpec requestBodySpec = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.method(HttpMethod.valueOf((String)request.getMethod().toUpperCase())).uri(builder -> {
            builder = builder.path(request.getEndpoint());
            if (!ObjectUtils.isEmpty((Object)request.getParameters())) {
                for (Map.Entry entry : request.getParameters().entrySet()) {
                    builder = builder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
                }
            }
            return builder.build(new Object[0]);
        })).attribute(ClientRequest.LOG_ID_ATTRIBUTE, (Object)logId)).headers(theHeaders -> {
            theHeaders.addAll((MultiValueMap)headers);
            if (request.getOptions() != null && !ObjectUtils.isEmpty((Object)request.getOptions().getHeaders())) {
                request.getOptions().getHeaders().forEach(it -> theHeaders.add(it.getName(), it.getValue()));
            }
        });
        if (request.getEntity() != null) {
            Lazy<String> body = this.bodyExtractor(request);
            ClientLogger.logRequest((String)logId, (String)request.getMethod().toUpperCase(), (String)request.getEndpoint(), (Object)request.getParameters(), () -> body.get());
            requestBodySpec.contentType(MediaType.valueOf((String)request.getEntity().getContentType().getValue())).body((Publisher)Mono.fromSupplier(body), String.class);
        } else {
            ClientLogger.logRequest((String)logId, (String)request.getMethod().toUpperCase(), (String)request.getEndpoint(), (Object)request.getParameters());
        }
        return requestBodySpec;
    }

    private Lazy<String> bodyExtractor(Request request) {
        return Lazy.of(() -> this.requestBodyToString(request));
    }

    private String requestBodyToString(Request request) {
        return EntityUtils.toString((HttpEntity)request.getEntity());
    }

    private <T> Publisher<? extends T> readResponseBody(String logId, Request request, ClientResponse response, Class<T> responseType) {
        return this.readResponseBody(logId, request, response, responseType, DefaultReactiveElasticsearchClient::doDecode);
    }

    private <T> Publisher<? extends T> readResponseBody(String logId, Request request, ClientResponse response, Class<T> responseType, Function3<ClientResponse, Class<T>, String, Mono<T>> decoder) {
        if (RawActionResponse.class.equals(responseType)) {
            ClientLogger.logRawResponse((String)logId, (HttpStatus)response.statusCode());
            return Mono.just(responseType.cast((Object)RawActionResponse.create(response)));
        }
        if (response.statusCode().is5xxServerError()) {
            ClientLogger.logRawResponse((String)logId, (HttpStatus)response.statusCode());
            return this.handleServerError(request, response);
        }
        if (response.statusCode().is4xxClientError()) {
            ClientLogger.logRawResponse((String)logId, (HttpStatus)response.statusCode());
            return this.handleClientError(logId, request, response, responseType);
        }
        return ((Mono)response.body(BodyExtractors.toMono(byte[].class))).map(it -> new String((byte[])it, StandardCharsets.UTF_8)).doOnNext(it -> ClientLogger.logResponse((String)logId, (HttpStatus)response.statusCode(), (String)it)).flatMap(content -> (Mono)decoder.apply((Object)response, (Object)responseType, content));
    }

    private static <T> Mono<T> doDecode(ClientResponse response, Class<T> responseType, String content) {
        String mediaType = response.headers().contentType().map(MimeType::toString).orElse(XContentType.JSON.mediaType());
        try {
            Method fromXContent = ReflectionUtils.findMethod(responseType, (String)"fromXContent", (Class[])new Class[]{XContentParser.class});
            if (fromXContent == null) {
                fromXContent = ReflectionUtils.findMethod(responseType, (String)"fromXContext", (Class[])new Class[]{XContentParser.class});
            }
            return Mono.justOrEmpty(responseType.cast(ReflectionUtils.invokeMethod((Method)fromXContent, responseType, (Object[])new Object[]{DefaultReactiveElasticsearchClient.createParser(mediaType, content)})));
        }
        catch (Throwable errorParseFailure) {
            try {
                return Mono.error((Throwable)BytesRestResponse.errorFromXContent((XContentParser)DefaultReactiveElasticsearchClient.createParser(mediaType, content)));
            }
            catch (Exception e) {
                return Mono.error((Throwable)new ElasticsearchStatusException(content, RestStatus.fromCode((int)response.statusCode().value()), errorParseFailure, new Object[0]));
            }
        }
    }

    private static XContentParser createParser(String mediaType, String content) throws IOException {
        XContentType type = XContentType.fromMediaTypeOrFormat((String)mediaType);
        if (type == null) {
            throw new IOException(content);
        }
        return XContentType.fromMediaTypeOrFormat((String)mediaType).xContent().createParser(new NamedXContentRegistry(NamedXContents.getDefaultNamedXContents()), DeprecationHandler.THROW_UNSUPPORTED_OPERATION, content);
    }

    private <T> Publisher<? extends T> handleServerError(Request request, ClientResponse response) {
        int statusCode = response.statusCode().value();
        RestStatus status = RestStatus.fromCode((int)statusCode);
        String mediaType = response.headers().contentType().map(MimeType::toString).orElse(XContentType.JSON.mediaType());
        return ((Mono)response.body(BodyExtractors.toMono(byte[].class))).switchIfEmpty(Mono.error(() -> new ElasticsearchStatusException(String.format("%s request to %s returned error code %s and no body.", request.getMethod(), request.getEndpoint(), statusCode), status, new Object[0]))).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).flatMap(content -> DefaultReactiveElasticsearchClient.contentOrError(content, mediaType, status)).flatMap(unused -> Mono.error(() -> new ElasticsearchStatusException(String.format("%s request to %s returned error code %s.", request.getMethod(), request.getEndpoint(), statusCode), status, new Object[0])));
    }

    private <T> Publisher<? extends T> handleClientError(String logId, Request request, ClientResponse response, Class<T> responseType) {
        int statusCode = response.statusCode().value();
        RestStatus status = RestStatus.fromCode((int)statusCode);
        String mediaType = response.headers().contentType().map(MimeType::toString).orElse(XContentType.JSON.mediaType());
        return ((Mono)response.body(BodyExtractors.toMono(byte[].class))).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).flatMap(content -> DefaultReactiveElasticsearchClient.contentOrError(content, mediaType, status)).doOnNext(content -> ClientLogger.logResponse((String)logId, (HttpStatus)response.statusCode(), (String)content)).flatMap(content -> DefaultReactiveElasticsearchClient.doDecode(response, responseType, content));
    }

    private static Mono<String> contentOrError(String content, String mediaType, RestStatus status) {
        ElasticsearchException exception = DefaultReactiveElasticsearchClient.getElasticsearchException(content, mediaType, status);
        if (exception != null) {
            if (status == RestStatus.NOT_FOUND) {
                log.warn(exception.getMessage(), (Throwable)exception);
                return Mono.empty();
            }
            StringBuilder sb = new StringBuilder();
            DefaultReactiveElasticsearchClient.buildExceptionMessages(sb, (Throwable)exception);
            return Mono.error((Throwable)new ElasticsearchStatusException(sb.toString(), status, (Throwable)exception, new Object[0]));
        }
        return Mono.just((Object)content);
    }

    @Nullable
    private static ElasticsearchException getElasticsearchException(String content, String mediaType, RestStatus status) {
        try {
            XContentParser parser = DefaultReactiveElasticsearchClient.createParser(mediaType, content);
            XContentParser.Token token = parser.nextToken();
            do {
                token = parser.nextToken();
                if (!"error".equals(parser.currentName())) continue;
                return ElasticsearchException.failureFromXContent((XContentParser)parser);
            } while (token == XContentParser.Token.FIELD_NAME);
            return null;
        }
        catch (IOException e) {
            return new ElasticsearchStatusException(content, status, new Object[0]);
        }
    }

    private static void buildExceptionMessages(StringBuilder sb, Throwable t) {
        sb.append(t.getMessage());
        for (Throwable throwable : t.getSuppressed()) {
            sb.append(", ");
            DefaultReactiveElasticsearchClient.buildExceptionMessages(sb, throwable);
        }
    }

    @Override
    public Mono<SearchResponse> searchForPage(SearchRequest request) {
        request.source().trackTotalHits(true);
        return this.sendRequest((ActionRequest)request, (Function)this::buildSearchRequest, (Class)SearchResponse.class, HttpHeaders.EMPTY).singleOrEmpty().doOnSuccess(res -> log.trace("execute search {} {} : {}", new Object[]{request.indices(), res.getTook(), request.source()})).doOnError(err -> log.warn("execute search {} error : {}", new Object[]{request.indices(), request.source(), err}));
    }

    protected Request convertMultiSearchRequest(MultiSearchRequest searchRequest) {
        Request request = RequestConverters.multiSearch((MultiSearchRequest)searchRequest);
        if (log.isTraceEnabled()) {
            log.trace("execute elasticsearch multi search: {}", (Object)this.requestBodyToString(request));
        }
        return request;
    }

    @Override
    public Mono<MultiSearchResponse> multiSearch(MultiSearchRequest request) {
        Function3 decoder = this.version.before(Version.V_7_0_0) ? (clientResponse, multiSearchResponseClass, s) -> {
            JSONObject data = JSON.parseObject((String)s);
            int took = data.getJSONArray("responses").stream().map(JSONObject.class::cast).map(json -> json.getIntValue("took")).reduce(Math::addExact).orElse(0);
            data.put("took", (Object)took);
            return DefaultReactiveElasticsearchClient.doDecode(clientResponse, multiSearchResponseClass, data.toJSONString());
        } : DefaultReactiveElasticsearchClient::doDecode;
        return this.sendRequest(request, this::convertMultiSearchRequest, MultiSearchResponse.class, HttpHeaders.EMPTY, decoder).singleOrEmpty();
    }

    Request convertGetMappingRequest(org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest getMappingsRequest) {
        CharSequence[] indices = getMappingsRequest.indices() == null ? Strings.EMPTY_ARRAY : getMappingsRequest.indices();
        Request request = new Request("GET", "/" + String.join((CharSequence)",", indices) + "/_mapping");
        Params parameters = new Params(request);
        parameters.withMasterTimeout(getMappingsRequest.masterNodeTimeout());
        parameters.withIndicesOptions(getMappingsRequest.indicesOptions());
        parameters.withLocal(getMappingsRequest.local());
        parameters.putParam("include_type_name", "true");
        return request;
    }

    @Override
    public Mono<org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse> getMapping(org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest request) {
        return this.sendRequest((ActionRequest)request, (Function)this::convertGetMappingRequest, (Class)org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse.class, HttpHeaders.EMPTY).singleOrEmpty();
    }

    public Mono<org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse> getMapping(HttpHeaders headers, org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest getMappingsRequest) {
        return this.sendRequest((ActionRequest)getMappingsRequest, this.requestCreator.getMapping(), (Class)org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse.class, headers).next();
    }

    public Mono<GetMappingsResponse> getMapping(HttpHeaders headers, GetMappingsRequest getMappingsRequest) {
        return this.sendRequest((ActionRequest)getMappingsRequest, this.requestCreator.getMappingRequest(), (Class)GetMappingsResponse.class, headers).next();
    }

    public Mono<GetFieldMappingsResponse> getFieldMapping(HttpHeaders headers, GetFieldMappingsRequest getFieldMappingsRequest) {
        return this.sendRequest((ActionRequest)getFieldMappingsRequest, this.requestCreator.getFieldMapping(), (Class)GetFieldMappingsResponse.class, headers).next();
    }

    public Mono<Boolean> updateAliases(HttpHeaders headers, IndicesAliasesRequest indicesAliasesRequest) {
        return this.sendRequest((ActionRequest)indicesAliasesRequest, this.requestCreator.updateAlias(), (Class)AcknowledgedResponse.class, headers).map(AcknowledgedResponse::isAcknowledged).next();
    }

    public Mono<GetAliasesResponse> getAliases(HttpHeaders headers, GetAliasesRequest getAliasesRequest) {
        return this.sendRequest((ActionRequest)getAliasesRequest, this.requestCreator.getAlias(), (Class)GetAliasesResponse.class, headers).next();
    }

    public Mono<Boolean> putTemplate(HttpHeaders headers, PutIndexTemplateRequest putIndexTemplateRequest) {
        return this.sendRequest((ActionRequest)putIndexTemplateRequest, this.requestCreator.putTemplate(), (Class)AcknowledgedResponse.class, headers).map(AcknowledgedResponse::isAcknowledged).next();
    }

    public Mono<GetIndexTemplatesResponse> getTemplate(HttpHeaders headers, GetIndexTemplatesRequest getIndexTemplatesRequest) {
        return this.sendRequest((ActionRequest)getIndexTemplatesRequest, this.requestCreator.getTemplates(), (Class)GetIndexTemplatesResponse.class, headers).next();
    }

    public Mono<Boolean> existsTemplate(HttpHeaders headers, IndexTemplatesExistRequest indexTemplatesExistRequest) {
        return this.sendRequest((ActionRequest)indexTemplatesExistRequest, this.requestCreator.templatesExist(), (Class)RawActionResponse.class, headers).flatMap(response -> response.releaseBody().thenReturn((Object)response.statusCode().is2xxSuccessful())).next();
    }

    public Mono<Boolean> deleteTemplate(HttpHeaders headers, DeleteIndexTemplateRequest deleteIndexTemplateRequest) {
        return this.sendRequest((ActionRequest)deleteIndexTemplateRequest, this.requestCreator.deleteTemplate(), (Class)AcknowledgedResponse.class, headers).map(AcknowledgedResponse::isAcknowledged).next();
    }

    public Mono<GetIndexResponse> getIndex(HttpHeaders headers, GetIndexRequest getIndexRequest) {
        return this.sendRequest((ActionRequest)getIndexRequest, this.requestCreator.getIndex(), (Class)GetIndexResponse.class, headers).next();
    }

    Request convertGetIndexTemplateRequest(org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest getIndexTemplatesRequest) {
        Request request = new Request("GET", "/_template/" + String.join((CharSequence)",", getIndexTemplatesRequest.names()));
        Params params = new Params(request);
        params.putParam("include_type_name", "true");
        return request;
    }

    @Override
    public Mono<org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse> getTemplate(org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest request) {
        return this.sendRequest((ActionRequest)request, (Function)this::convertGetIndexTemplateRequest, (Class)org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse.class, HttpHeaders.EMPTY).singleOrEmpty();
    }

    Request convertPutIndexTemplateRequest(org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest putIndexTemplateRequest) {
        Request request = new Request("PUT", "/_template/" + putIndexTemplateRequest.name());
        Params params = new Params(request);
        params.withMasterTimeout(putIndexTemplateRequest.masterNodeTimeout());
        if (putIndexTemplateRequest.create()) {
            params.putParam("create", Boolean.TRUE.toString());
        }
        if (Strings.hasText((String)putIndexTemplateRequest.cause())) {
            params.putParam("cause", putIndexTemplateRequest.cause());
        }
        params.putParam("include_type_name", "true");
        BytesRef source = XContentHelper.toXContent((ToXContent)putIndexTemplateRequest, (XContentType)XContentType.JSON, (boolean)false).toBytesRef();
        request.setEntity((HttpEntity)new ByteArrayEntity(source.bytes, source.offset, source.length, ContentType.APPLICATION_JSON));
        return request;
    }

    @Override
    public Mono<AcknowledgedResponse> updateTemplate(org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest request) {
        return this.sendRequest((ActionRequest)request, (Function)this::convertPutIndexTemplateRequest, (Class)AcknowledgedResponse.class, HttpHeaders.EMPTY).singleOrEmpty();
    }

    @Override
    public Version serverVersion() {
        return this.version;
    }

    public Mono<ClusterHealthResponse> health(HttpHeaders headers, ClusterHealthRequest clusterHealthRequest) {
        return this.sendRequest((ActionRequest)clusterHealthRequest, this.requestCreator.clusterHealth(), (Class)ClusterHealthResponse.class, headers).next();
    }

    @Generated
    static class Params {
        private final Request request;

        Params(Request request) {
            this.request = request;
        }

        Params putParam(String name, String value) {
            if (Strings.hasLength((String)value)) {
                this.request.addParameter(name, value);
            }
            return this;
        }

        Params putParam(String key, TimeValue value) {
            if (value != null) {
                return this.putParam(key, value.getStringRep());
            }
            return this;
        }

        Params withDocAsUpsert(boolean docAsUpsert) {
            if (docAsUpsert) {
                return this.putParam("doc_as_upsert", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withFetchSourceContext(FetchSourceContext fetchSourceContext) {
            if (fetchSourceContext != null) {
                if (!fetchSourceContext.fetchSource()) {
                    this.putParam("_source", Boolean.FALSE.toString());
                }
                if (fetchSourceContext.includes() != null && fetchSourceContext.includes().length > 0) {
                    this.putParam("_source_includes", String.join((CharSequence)",", fetchSourceContext.includes()));
                }
                if (fetchSourceContext.excludes() != null && fetchSourceContext.excludes().length > 0) {
                    this.putParam("_source_excludes", String.join((CharSequence)",", fetchSourceContext.excludes()));
                }
            }
            return this;
        }

        Params withFields(String[] fields) {
            if (fields != null && fields.length > 0) {
                return this.putParam("fields", String.join((CharSequence)",", fields));
            }
            return this;
        }

        Params withMasterTimeout(TimeValue masterTimeout) {
            return this.putParam("master_timeout", masterTimeout);
        }

        Params withPipeline(String pipeline) {
            return this.putParam("pipeline", pipeline);
        }

        Params withPreference(String preference) {
            return this.putParam("preference", preference);
        }

        Params withRealtime(boolean realtime) {
            if (!realtime) {
                return this.putParam("realtime", Boolean.FALSE.toString());
            }
            return this;
        }

        Params withRefresh(boolean refresh) {
            if (refresh) {
                return this.withRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            }
            return this;
        }

        Params withRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            if (refreshPolicy != WriteRequest.RefreshPolicy.NONE) {
                return this.putParam("refresh", refreshPolicy.getValue());
            }
            return this;
        }

        Params withRequestsPerSecond(float requestsPerSecond) {
            if (Float.isFinite(requestsPerSecond)) {
                return this.putParam("requests_per_second", Float.toString(requestsPerSecond));
            }
            return this.putParam("requests_per_second", "-1");
        }

        Params withRetryOnConflict(int retryOnConflict) {
            if (retryOnConflict > 0) {
                return this.putParam("retry_on_conflict", String.valueOf(retryOnConflict));
            }
            return this;
        }

        Params withRouting(String routing) {
            return this.putParam("routing", routing);
        }

        Params withStoredFields(String[] storedFields) {
            if (storedFields != null && storedFields.length > 0) {
                return this.putParam("stored_fields", String.join((CharSequence)",", storedFields));
            }
            return this;
        }

        Params withTimeout(TimeValue timeout) {
            return this.putParam("timeout", timeout);
        }

        Params withVersion(long version) {
            if (version != -3L) {
                return this.putParam("version", Long.toString(version));
            }
            return this;
        }

        Params withVersionType(VersionType versionType) {
            if (versionType != VersionType.INTERNAL) {
                return this.putParam("version_type", versionType.name().toLowerCase(Locale.ROOT));
            }
            return this;
        }

        Params withIfSeqNo(long seqNo) {
            if (seqNo != -2L) {
                return this.putParam("if_seq_no", Long.toString(seqNo));
            }
            return this;
        }

        Params withIfPrimaryTerm(long primaryTerm) {
            if (primaryTerm != 0L) {
                return this.putParam("if_primary_term", Long.toString(primaryTerm));
            }
            return this;
        }

        Params withWaitForActiveShards(ActiveShardCount activeShardCount) {
            return this.withWaitForActiveShards(activeShardCount, ActiveShardCount.DEFAULT);
        }

        Params withWaitForActiveShards(ActiveShardCount activeShardCount, ActiveShardCount defaultActiveShardCount) {
            if (activeShardCount != null && activeShardCount != defaultActiveShardCount) {
                String value = activeShardCount == ActiveShardCount.DEFAULT ? "1" : activeShardCount.toString().toLowerCase(Locale.ROOT);
                return this.putParam("wait_for_active_shards", value);
            }
            return this;
        }

        Params withIndicesOptions(IndicesOptions indicesOptions) {
            String expandWildcards;
            this.withIgnoreUnavailable(indicesOptions.ignoreUnavailable());
            this.putParam("allow_no_indices", Boolean.toString(indicesOptions.allowNoIndices()));
            if (!indicesOptions.expandWildcardsOpen() && !indicesOptions.expandWildcardsClosed()) {
                expandWildcards = "none";
            } else {
                StringJoiner joiner = new StringJoiner(",");
                if (indicesOptions.expandWildcardsOpen()) {
                    joiner.add("open");
                }
                if (indicesOptions.expandWildcardsClosed()) {
                    joiner.add("closed");
                }
                expandWildcards = joiner.toString();
            }
            this.putParam("expand_wildcards", expandWildcards);
            return this;
        }

        Params withIgnoreUnavailable(boolean ignoreUnavailable) {
            this.putParam("ignore_unavailable", Boolean.toString(ignoreUnavailable));
            return this;
        }

        Params withHuman(boolean human) {
            if (human) {
                this.putParam("human", "true");
            }
            return this;
        }

        Params withLocal(boolean local) {
            if (local) {
                this.putParam("local", "true");
            }
            return this;
        }

        Params withIncludeDefaults(boolean includeDefaults) {
            if (includeDefaults) {
                return this.putParam("include_defaults", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withPreserveExisting(boolean preserveExisting) {
            if (preserveExisting) {
                return this.putParam("preserve_existing", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withDetailed(boolean detailed) {
            if (detailed) {
                return this.putParam("detailed", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForCompletion(Boolean waitForCompletion) {
            return this.putParam("wait_for_completion", waitForCompletion.toString());
        }

        Params withNodes(String[] nodes) {
            if (nodes != null && nodes.length > 0) {
                return this.putParam("nodes", String.join((CharSequence)",", nodes));
            }
            return this;
        }

        Params withActions(String[] actions) {
            if (actions != null && actions.length > 0) {
                return this.putParam("actions", String.join((CharSequence)",", actions));
            }
            return this;
        }

        Params withTaskId(TaskId taskId) {
            if (taskId != null && taskId.isSet()) {
                return this.putParam("task_id", taskId.toString());
            }
            return this;
        }

        Params withParentTaskId(TaskId parentTaskId) {
            if (parentTaskId != null && parentTaskId.isSet()) {
                return this.putParam("parent_task_id", parentTaskId.toString());
            }
            return this;
        }

        Params withVerify(boolean verify) {
            if (verify) {
                return this.putParam("verify", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForStatus(ClusterHealthStatus status) {
            if (status != null) {
                return this.putParam("wait_for_status", status.name().toLowerCase(Locale.ROOT));
            }
            return this;
        }

        Params withWaitForNoRelocatingShards(boolean waitNoRelocatingShards) {
            if (waitNoRelocatingShards) {
                return this.putParam("wait_for_no_relocating_shards", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForNoInitializingShards(boolean waitNoInitShards) {
            if (waitNoInitShards) {
                return this.putParam("wait_for_no_initializing_shards", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForNodes(String waitForNodes) {
            return this.putParam("wait_for_nodes", waitForNodes);
        }

        Params withLevel(ClusterHealthRequest.Level level) {
            return this.putParam("level", level.name().toLowerCase(Locale.ROOT));
        }

        Params withWaitForEvents(Priority waitForEvents) {
            if (waitForEvents != null) {
                return this.putParam("wait_for_events", waitForEvents.name().toLowerCase(Locale.ROOT));
            }
            return this;
        }
    }

    @Generated
    static class ClientStatus
    implements ReactiveElasticsearchClient.Status {
        private final Collection<ElasticsearchHost> connectedHosts;

        ClientStatus(Collection<ElasticsearchHost> connectedHosts) {
            this.connectedHosts = connectedHosts;
        }

        public Collection<ElasticsearchHost> hosts() {
            return this.connectedHosts;
        }
    }
}

