/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.index.strategies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.compress.CompressedXContent;
import org.jetlinks.community.elastic.search.enums.ElasticDateFormat;
import org.jetlinks.community.elastic.search.enums.ElasticPropertyType;
import org.jetlinks.community.elastic.search.index.DefaultElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexProperties;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexStrategy;
import org.jetlinks.community.elastic.search.service.reactive.ReactiveElasticsearchClient;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.Metadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.DoubleType;
import org.jetlinks.core.metadata.types.FloatType;
import org.jetlinks.core.metadata.types.GeoShapeType;
import org.jetlinks.core.metadata.types.GeoType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.LongType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

public abstract class AbstractElasticSearchIndexStrategy
implements ElasticSearchIndexStrategy {
    private static final Logger log = LoggerFactory.getLogger(AbstractElasticSearchIndexStrategy.class);
    private final String id;
    protected ReactiveElasticsearchClient client;
    protected ElasticSearchIndexProperties properties;

    protected String wrapIndex(String index) {
        return index.toLowerCase();
    }

    protected Mono<Boolean> indexExists(String index) {
        return this.client.existsIndex(new GetIndexRequest(new String[]{this.wrapIndex(index)}));
    }

    protected Mono<Void> doCreateIndex(ElasticSearchIndexMetadata metadata) {
        return this.client.createIndex(this.createIndexRequest(metadata)).then();
    }

    protected Mono<Void> doPutIndex(ElasticSearchIndexMetadata metadata, boolean justUpdateMapping) {
        String index = this.wrapIndex(metadata.getIndex());
        return this.indexExists(index).flatMap(exists -> {
            if (exists.booleanValue()) {
                return this.doLoadIndexMetadata(index).flatMap(oldMapping -> Mono.justOrEmpty((Object)this.createPutMappingRequest(metadata, (ElasticSearchIndexMetadata)oldMapping))).flatMap(request -> this.client.putMapping((PutMappingRequest)request)).then();
            }
            if (justUpdateMapping) {
                return Mono.empty();
            }
            return this.doCreateIndex(metadata);
        });
    }

    protected Mono<ElasticSearchIndexMetadata> doLoadIndexMetadata(String _index) {
        String index = this.wrapIndex(_index);
        return this.client.getMapping(new GetMappingsRequest().indices(new String[]{index})).flatMap(resp -> Mono.justOrEmpty((Object)this.convertMetadata(index, (MappingMetadata)resp.mappings().get(index))));
    }

    protected CreateIndexRequest createIndexRequest(ElasticSearchIndexMetadata metadata) {
        CreateIndexRequest request = new CreateIndexRequest(this.wrapIndex(metadata.getIndex()));
        request.settings(this.properties.toSettings());
        HashMap<String, Object> mappingConfig = new HashMap<String, Object>();
        mappingConfig.put("properties", this.createElasticProperties(metadata.getProperties()));
        mappingConfig.put("dynamic_templates", this.createDynamicTemplates());
        if (this.client.serverVersion().after(Version.V_7_0_0)) {
            request.mapping(mappingConfig);
        } else {
            request.mapping(Collections.singletonMap("_doc", mappingConfig));
        }
        return request;
    }

    private PutMappingRequest createPutMappingRequest(ElasticSearchIndexMetadata metadata, ElasticSearchIndexMetadata ignore) {
        Map<String, Object> properties = this.createElasticProperties(metadata.getProperties());
        Map<String, Object> ignoreProperties = this.createElasticProperties(ignore.getProperties());
        for (Map.Entry<String, Object> en : ignoreProperties.entrySet()) {
            log.trace("ignore update index [{}] mapping property:{},{}", new Object[]{this.wrapIndex(metadata.getIndex()), en.getKey(), en.getValue()});
            properties.remove(en.getKey());
        }
        if (properties.isEmpty()) {
            log.debug("ignore update index [{}] mapping", (Object)this.wrapIndex(metadata.getIndex()));
            return null;
        }
        HashMap<String, Map<String, Object>> mappingConfig = new HashMap<String, Map<String, Object>>();
        PutMappingRequest request = new PutMappingRequest(new String[]{this.wrapIndex(metadata.getIndex())});
        ArrayList<PropertyMetadata> allProperties = new ArrayList<PropertyMetadata>();
        allProperties.addAll(metadata.getProperties());
        allProperties.addAll(ignore.getProperties());
        mappingConfig.put("properties", this.createElasticProperties(allProperties));
        request.source(mappingConfig);
        return request;
    }

    protected Map<String, Object> createElasticProperties(List<PropertyMetadata> metadata) {
        if (metadata == null) {
            return new HashMap<String, Object>();
        }
        return metadata.stream().collect(Collectors.toMap(Metadata::getId, prop -> this.createElasticProperty(prop.getValueType()), (a, v) -> a));
    }

    protected Map<String, Object> createElasticProperty(DataType type) {
        HashMap<String, Object> property = new HashMap<String, Object>();
        if (type instanceof DateTimeType) {
            property.put("type", "date");
            property.put("format", ElasticDateFormat.getFormat(ElasticDateFormat.epoch_millis, ElasticDateFormat.strict_date_hour_minute_second, ElasticDateFormat.strict_date_time, ElasticDateFormat.strict_date));
        } else if (type instanceof DoubleType) {
            property.put("type", "double");
        } else if (type instanceof LongType) {
            property.put("type", "long");
        } else if (type instanceof IntType) {
            property.put("type", "integer");
        } else if (type instanceof FloatType) {
            property.put("type", "float");
        } else if (type instanceof BooleanType) {
            property.put("type", "boolean");
        } else if (type instanceof GeoType) {
            property.put("type", "geo_point");
        } else if (type instanceof GeoShapeType) {
            property.put("type", "geo_shape");
        } else {
            if (type instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)type;
                return this.createElasticProperty(arrayType.getElementType());
            }
            if (type instanceof ObjectType) {
                property.put("type", "nested");
                ObjectType objectType = (ObjectType)type;
                if (!CollectionUtils.isEmpty((Collection)objectType.getProperties())) {
                    property.put("properties", this.createElasticProperties(objectType.getProperties()));
                }
            } else {
                property.put("type", "keyword");
                property.put("ignore_above", 512);
            }
        }
        return property;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ElasticSearchIndexMetadata convertMetadata(String index, MappingMetadata metadata) {
        void var4_9;
        Object var4_3 = null;
        Map metaData = metadata.getSourceAsMap();
        if (metaData.containsKey("properties")) {
            Object res = metaData.get("properties");
            if (res instanceof Map) {
                Object v = res;
            } else if (res instanceof MappingMetadata) {
                MappingMetadata mappingMetadata = (MappingMetadata)res;
                Map map = mappingMetadata.sourceAsMap();
            } else {
                if (!(res instanceof CompressedXContent)) throw new UnsupportedOperationException("unsupported index metadata" + metaData);
                MappingMetadata mappingMetadata = new MappingMetadata((CompressedXContent)res);
                Map map = mappingMetadata.sourceAsMap();
            }
        } else {
            MappingMetadata mappingMetadata;
            Object res = metaData.get("_doc");
            if (res instanceof MappingMetadata) {
                mappingMetadata = (MappingMetadata)res;
            } else {
                if (!(res instanceof CompressedXContent)) throw new UnsupportedOperationException("unsupported index metadata" + metaData);
                mappingMetadata = new MappingMetadata((CompressedXContent)res);
            }
            Object v = mappingMetadata.getSourceAsMap().get("properties");
        }
        if (var4_9 != null) return new DefaultElasticSearchIndexMetadata(index, this.convertProperties(var4_9));
        throw new UnsupportedOperationException("unsupported index metadata" + metaData);
    }

    protected List<PropertyMetadata> convertProperties(Object properties) {
        if (properties == null) {
            return new ArrayList<PropertyMetadata>();
        }
        return ((Map)properties).entrySet().stream().map(entry -> this.convertProperty((String)entry.getKey(), (Map)entry.getValue())).collect(Collectors.toList());
    }

    private PropertyMetadata convertProperty(String property, Map<String, Object> map) {
        String type = String.valueOf(map.get("type"));
        SimplePropertyMetadata metadata = new SimplePropertyMetadata();
        metadata.setId(property);
        metadata.setName(property);
        ElasticPropertyType elasticPropertyType = ElasticPropertyType.of(type);
        if (null != elasticPropertyType) {
            Map nestProperties;
            DataType dataType = elasticPropertyType.getType();
            if ((elasticPropertyType == ElasticPropertyType.OBJECT || elasticPropertyType == ElasticPropertyType.NESTED) && dataType instanceof ObjectType && null != (nestProperties = (Map)map.get("properties"))) {
                ObjectType objectType = (ObjectType)dataType;
                objectType.setProperties(this.convertProperties(nestProperties));
            }
            metadata.setValueType(dataType);
        } else {
            metadata.setValueType((DataType)StringType.GLOBAL);
        }
        return metadata;
    }

    protected List<?> createDynamicTemplates() {
        ArrayList maps = new ArrayList();
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("match_mapping_type", "string");
        config.put("mapping", this.createElasticProperty((DataType)StringType.GLOBAL));
        maps.add(Collections.singletonMap("string_fields", config));
        config = new HashMap();
        config.put("match_mapping_type", "date");
        config.put("mapping", this.createElasticProperty((DataType)DateTimeType.GLOBAL));
        maps.add(Collections.singletonMap("date_fields", config));
        return maps;
    }

    public AbstractElasticSearchIndexStrategy(String id, ReactiveElasticsearchClient client, ElasticSearchIndexProperties properties) {
        this.id = id;
        this.client = client;
        this.properties = properties;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

