/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web.excel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hswebframework.reactor.excel.Cell;
import org.hswebframework.reactor.excel.converter.RowWrapper;
import org.jetlinks.community.device.web.excel.PropertyMetadataExcelInfo;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.ConfigPropertyMetadata;

public class PropertyMetadataWrapper
extends RowWrapper<PropertyMetadataExcelInfo> {
    private final Map<String, String> propertyMapping = new HashMap<String, String>();

    public PropertyMetadataWrapper(List<ConfigMetadata> expands) {
        this.propertyMapping.put("\u5c5e\u6027ID", "property");
        this.propertyMapping.put("\u5c5e\u6027\u540d\u79f0", "name");
        this.propertyMapping.put("\u6570\u636e\u7c7b\u578b", "dataType");
        this.propertyMapping.put("\u5355\u4f4d", "unit");
        this.propertyMapping.put("\u7cbe\u5ea6", "scale");
        this.propertyMapping.put("\u6570\u636e\u7c7b\u578b\u914d\u7f6e", "valueType");
        this.propertyMapping.put("\u6765\u6e90", "source");
        this.propertyMapping.put("\u5c5e\u6027\u8bf4\u660e", "description");
        this.propertyMapping.put("\u8bfb\u5199\u7c7b\u578b", "type");
        for (ConfigMetadata expand : expands) {
            for (ConfigPropertyMetadata property : expand.getProperties()) {
                this.propertyMapping.put(expand.getName() + "-" + property.getName(), property.getProperty());
                this.propertyMapping.put(property.getName(), property.getProperty());
            }
        }
    }

    protected PropertyMetadataExcelInfo newInstance() {
        return new PropertyMetadataExcelInfo();
    }

    protected PropertyMetadataExcelInfo wrap(PropertyMetadataExcelInfo instance, Cell header, Cell dataCell) {
        String headerText = header.valueAsText().orElse("null");
        String value = dataCell.valueAsText().orElse("");
        if (this.propertyMapping.containsKey(headerText)) {
            instance.with(this.propertyMapping.get(headerText), this.propertyTypeToLowerCase(headerText, value));
        }
        instance.setRowNumber(dataCell.getRowIndex() + 1L);
        return instance;
    }

    private Object propertyTypeToLowerCase(String headerText, Object value) {
        if ("\u7c7b\u578b".equals(headerText)) {
            return value.toString().toLowerCase();
        }
        return value;
    }
}

