/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service;

import java.util.List;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.events.DeviceProductDeployEvent;
import org.jetlinks.community.device.service.LocalDeviceProductService;
import org.jetlinks.core.device.DeviceRegistry;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class DeviceProductHandler {
    private final LocalDeviceProductService productService;
    private final DeviceRegistry deviceRegistry;
    private final ApplicationEventPublisher eventPublisher;

    @EventListener
    public void handleProductSaveEvent(EntitySavedEvent<DeviceProductEntity> event) {
        event.async(this.applyProductConfig(event.getEntity()));
    }

    @EventListener
    public void handleProductSaveEvent(EntityModifyEvent<DeviceProductEntity> event) {
        event.async(this.applyProductConfig(event.getBefore()));
    }

    private Mono<Void> applyProductConfig(List<DeviceProductEntity> entities) {
        return ((Flux)Flux.fromIterable(entities).map(DeviceProductEntity::getId).as(arg_0 -> ((LocalDeviceProductService)this.productService).findById(arg_0))).filter(product -> product.getState() == 1).flatMap(product -> this.deviceRegistry.register(product.toProductInfo()).flatMap(i -> ((DeviceProductDeployEvent)((Object)((Object)((Object)FastBeanCopier.copy((Object)product, (Object)((Object)new DeviceProductDeployEvent()), (String[])new String[0]))))).publish(this.eventPublisher))).then();
    }

    public DeviceProductHandler(LocalDeviceProductService productService, DeviceRegistry deviceRegistry, ApplicationEventPublisher eventPublisher) {
        this.productService = productService;
        this.deviceRegistry = deviceRegistry;
        this.eventPublisher = eventPublisher;
    }
}

