/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.crud.events.EntityDeletedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntityPrepareCreateEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.exception.BusinessException;
import org.jetlinks.community.PropertyConstants;
import org.jetlinks.community.device.entity.DeviceCategoryEntity;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.service.LocalDeviceProductService;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.supports.official.JetLinksDeviceMetadataCodec;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class DeviceEntityEventHandler {
    private static final Logger log = LoggerFactory.getLogger(DeviceEntityEventHandler.class);
    private final LocalDeviceProductService productService;
    private final DeviceRegistry registry;
    private final ProtocolSupports supports;

    @EventListener
    public void handleDeviceEvent(EntitySavedEvent<DeviceInstanceEntity> event) {
        event.first((Publisher)Flux.fromIterable((Iterable)event.getEntity()).filter(device -> StringUtils.hasText((String)device.getName())).flatMap(device -> this.registry.getDevice(device.getId()).flatMap(deviceOperator -> deviceOperator.setConfig((ConfigKey)PropertyConstants.deviceName, (Object)device.getName()))));
    }

    @EventListener
    public void handleDeviceEvent(EntityModifyEvent<DeviceInstanceEntity> event) {
        Map olds = event.getBefore().stream().filter(device -> StringUtils.hasText((String)device.getId())).collect(Collectors.toMap(DeviceInstanceEntity::getId, Function.identity()));
        event.first((Publisher)Flux.fromIterable((Iterable)event.getAfter()).filter(device -> {
            DeviceInstanceEntity old = (DeviceInstanceEntity)((Object)((Object)olds.get(device.getId())));
            return old != null && !Objects.equals(device.getName(), old.getName());
        }).flatMap(device -> this.registry.getDevice(device.getId()).flatMap(deviceOperator -> deviceOperator.setConfig((ConfigKey)PropertyConstants.deviceName, (Object)device.getName()))));
    }

    @EventListener
    public void handleProductDefaultMetadata(EntityPrepareCreateEvent<DeviceProductEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).flatMap(product -> {
            if (product.getMetadata() == null && StringUtils.hasText((String)product.getMessageProtocol()) && StringUtils.hasText((String)product.getTransportProtocol())) {
                return this.supports.getProtocol(product.getMessageProtocol()).flatMapMany(support -> support.getDefaultMetadata(Transport.of((String)product.getTransportProtocol())).flatMap(arg_0 -> ((JetLinksDeviceMetadataCodec)JetLinksDeviceMetadataCodec.getInstance()).encode(arg_0)).doOnNext(product::setMetadata)).onErrorResume(err -> {
                    log.warn("auto set product[{}] default metadata error", (Object)product.getName(), err);
                    return Mono.empty();
                });
            }
            return Mono.empty();
        }));
    }

    @EventListener
    public void handleCategoryDelete(EntityDeletedEvent<DeviceCategoryEntity> event) {
        event.async((Publisher)((ReactiveQuery)this.productService.createQuery().in(DeviceProductEntity::getClassifiedId, (Collection)event.getEntity().stream().map(DeviceCategoryEntity::getId).collect(Collectors.toList()))).count().doOnNext(i -> {
            if (i > 0) {
                throw new BusinessException("error.device_category_has_bean_use_by_product");
            }
        }));
    }

    @EventListener
    public void handleCategorySave(EntitySavedEvent<DeviceCategoryEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).flatMap(category -> ((ReactiveUpdate)((ReactiveUpdate)this.productService.createUpdate().set(DeviceProductEntity::getClassifiedName, (Object)category.getName())).where(DeviceProductEntity::getClassifiedId, (Object)category.getId())).execute().then()));
    }

    public DeviceEntityEventHandler(LocalDeviceProductService productService, DeviceRegistry registry, ProtocolSupports supports) {
        this.productService = productService;
        this.registry = registry;
        this.supports = supports;
    }
}

