/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.message;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.service.LocalDeviceInstanceService;
import org.jetlinks.community.gateway.external.SubscribeRequest;
import org.jetlinks.community.gateway.external.SubscriptionProvider;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;

@Component
public class DeviceCurrentStateSubscriptionProvider
implements SubscriptionProvider {
    private final LocalDeviceInstanceService instanceService;

    public String id() {
        return "device-state-subscriber";
    }

    public String name() {
        return "\u8bbe\u5907\u5f53\u524d\u72b6\u6001\u6d88\u606f";
    }

    public String[] getTopicPattern() {
        return new String[]{"/device-current-state"};
    }

    public Flux<Map<String, Object>> subscribe(SubscribeRequest request) {
        List deviceId = request.get("deviceId").map(List.class::cast).orElseThrow(() -> new IllegalArgumentException("deviceId\u4e0d\u80fd\u4e3a\u7a7a"));
        return Flux.fromIterable((Iterable)deviceId).buffer(200).concatMap(buf -> ((ReactiveQuery)((ReactiveQuery)this.instanceService.createQuery().select(new StaticMethodReferenceColumn[]{DeviceInstanceEntity::getId, DeviceInstanceEntity::getState})).in(DeviceInstanceEntity::getId, (Collection)buf)).fetch()).map(instance -> Collections.singletonMap(instance.getId(), instance.getState().name()));
    }

    public DeviceCurrentStateSubscriptionProvider(LocalDeviceInstanceService instanceService) {
        this.instanceService = instanceService;
    }
}

