/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.measurements;

import java.util.Optional;
import org.jetlinks.community.dashboard.DashboardObject;
import org.jetlinks.community.dashboard.Measurement;
import org.jetlinks.community.dashboard.ObjectDefinition;
import org.jetlinks.community.device.measurements.DeviceEventMeasurement;
import org.jetlinks.community.device.measurements.DeviceEventsMeasurement;
import org.jetlinks.community.device.measurements.DevicePropertiesMeasurement;
import org.jetlinks.community.device.measurements.DevicePropertyMeasurement;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DeviceDashboardObject
implements DashboardObject {
    private final String id;
    private final String name;
    private final DeviceProductOperator productOperator;
    private final EventBus eventBus;
    private final DeviceDataService deviceDataService;

    private DeviceDashboardObject(String id, String name, DeviceProductOperator productOperator, EventBus eventBus, DeviceDataService dataService) {
        this.id = id;
        this.name = name;
        this.productOperator = productOperator;
        this.eventBus = eventBus;
        this.deviceDataService = dataService;
    }

    public static DeviceDashboardObject of(String id, String name, DeviceProductOperator productOperator, EventBus eventBus, DeviceDataService dataService) {
        return new DeviceDashboardObject(id, name, productOperator, eventBus, dataService);
    }

    public ObjectDefinition getDefinition() {
        return new ObjectDefinition(){

            public String getId() {
                return DeviceDashboardObject.this.id;
            }

            public String getName() {
                return DeviceDashboardObject.this.name;
            }
        };
    }

    public Flux<Measurement> getMeasurements() {
        return Flux.concat((Publisher[])new Publisher[]{this.productOperator.getMetadata().flatMapIterable(DeviceMetadata::getEvents).map(event -> new DeviceEventMeasurement(this.productOperator.getId(), this.eventBus, (EventMetadata)event, this.deviceDataService)), this.productOperator.getMetadata().map(metadata -> new DevicePropertiesMeasurement(this.productOperator.getId(), this.eventBus, this.deviceDataService, (DeviceMetadata)metadata)), this.productOperator.getMetadata().map(metadata -> new DeviceEventsMeasurement(this.productOperator.getId(), this.eventBus, (DeviceMetadata)metadata, this.deviceDataService)), this.productOperator.getMetadata().flatMapIterable(DeviceMetadata::getProperties).map(event -> new DevicePropertyMeasurement(this.productOperator.getId(), this.eventBus, (PropertyMetadata)event, this.deviceDataService))});
    }

    public Mono<Measurement> getMeasurement(String id) {
        if ("properties".equals(id)) {
            return this.productOperator.getMetadata().map(metadata -> new DevicePropertiesMeasurement(this.productOperator.getId(), this.eventBus, this.deviceDataService, (DeviceMetadata)metadata));
        }
        if ("events".equals(id)) {
            return this.productOperator.getMetadata().map(metadata -> new DeviceEventsMeasurement(this.productOperator.getId(), this.eventBus, (DeviceMetadata)metadata, this.deviceDataService));
        }
        return this.productOperator.getMetadata().flatMap(metadata -> Mono.justOrEmpty((Optional)metadata.getEvent(id))).map(event -> new DeviceEventMeasurement(this.productOperator.getId(), this.eventBus, (EventMetadata)event, this.deviceDataService)).switchIfEmpty(this.productOperator.getMetadata().flatMap(metadata -> Mono.justOrEmpty((Optional)metadata.getProperty(id))).map(event -> new DevicePropertyMeasurement(this.productOperator.getId(), this.eventBus, (PropertyMetadata)event, this.deviceDataService)));
    }
}

