/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.reactor.excel.ReactorExcel;
import org.hswebframework.reactor.excel.converter.RowWrapper;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.service.DeviceConfigMetadataManager;
import org.jetlinks.community.device.service.LocalDeviceProductService;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.community.device.web.excel.PropertyMetadataExcelInfo;
import org.jetlinks.community.device.web.excel.PropertyMetadataWrapper;
import org.jetlinks.community.device.web.request.AggRequest;
import org.jetlinks.community.io.excel.ImportExportService;
import org.jetlinks.community.io.utils.FileUtils;
import org.jetlinks.community.things.data.ThingsDataRepositoryStrategy;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.community.web.response.ValidationResult;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.ConfigScope;
import org.jetlinks.core.metadata.DeviceConfigScope;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.DeviceMetadataCodec;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.SimpleDeviceMetadata;
import org.jetlinks.supports.official.JetLinksDeviceMetadataCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/device-product", "/device/product"})
@Resource(id="device-product", name="\u8bbe\u5907\u4ea7\u54c1")
@Tag(name="\u8bbe\u5907\u4ea7\u54c1\u63a5\u53e3")
public class DeviceProductController
implements ReactiveServiceCrudController<DeviceProductEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(DeviceProductController.class);
    private final LocalDeviceProductService productService;
    private final List<ThingsDataRepositoryStrategy> policies;
    private final DeviceDataService deviceDataService;
    private final DeviceConfigMetadataManager configMetadataManager;
    private final ObjectProvider<DeviceMetadataCodec> metadataCodecs;
    private final DeviceMetadataCodec defaultCodec = new JetLinksDeviceMetadataCodec();
    private final DataBufferFactory bufferFactory = new DefaultDataBufferFactory();
    private final ImportExportService importExportService;

    public DeviceProductController(LocalDeviceProductService productService, List<ThingsDataRepositoryStrategy> policies, DeviceDataService deviceDataService, DeviceConfigMetadataManager configMetadataManager, ObjectProvider<DeviceMetadataCodec> metadataCodecs, ImportExportService importExportService) {
        this.productService = productService;
        this.policies = policies;
        this.deviceDataService = deviceDataService;
        this.configMetadataManager = configMetadataManager;
        this.metadataCodecs = metadataCodecs;
        this.importExportService = importExportService;
    }

    public LocalDeviceProductService getService() {
        return this.productService;
    }

    @GetMapping(value={"/{id:.+}/config-metadata"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u4ea7\u54c1\u9700\u8981\u7684\u914d\u7f6e\u5b9a\u4e49\u4fe1\u606f")
    public Flux<ConfigMetadata> getDeviceConfigMetadata(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String id) {
        System.out.println("=============getDeviceConfigMetadata============================" + id);
        return this.configMetadataManager.getProductConfigMetadata(id);
    }

    @GetMapping(value={"/{id:.+}/{accessId:.+}/config-metadata"})
    @QueryAction
    @Operation(summary="\u6839\u636e\u6307\u5b9a\u7684\u63a5\u5165\u65b9\u5f0f\u83b7\u53d6\u4ea7\u54c1\u9700\u8981\u7684\u914d\u7f6e\u5b9a\u4e49\u4fe1\u606f")
    public Flux<ConfigMetadata> getProductConfigMetadataByAccessId(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String id, @PathVariable @Parameter(description="\u63a5\u5165\u65b9\u5f0fID") String accessId) {
        return this.configMetadataManager.getProductConfigMetadataByAccessId(id, accessId);
    }

    @GetMapping(value={"/{id:.+}/config-metadata/{metadataType}/{metadataId}/{typeId}"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u4ea7\u54c1\u7269\u6a21\u578b\u7684\u62d3\u5c55\u914d\u7f6e\u5b9a\u4e49")
    public Flux<ConfigMetadata> getExpandsConfigMetadata(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String id, @PathVariable @Parameter(description="\u7269\u6a21\u578b\u7c7b\u578b") DeviceMetadataType metadataType, @PathVariable @Parameter(description="\u7269\u6a21\u578bID") String metadataId, @PathVariable @Parameter(description="\u7c7b\u578bID") String typeId) {
        return this.configMetadataManager.getMetadataExpandsConfig(id, metadataType, metadataId, typeId, new ConfigScope[]{DeviceConfigScope.product});
    }

    @GetMapping(value={"/metadata/codecs"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u652f\u6301\u7684\u7269\u6a21\u578b\u683c\u5f0f")
    public Flux<DeviceMetadataCodec> getMetadataCodec() {
        return Flux.fromIterable(this.metadataCodecs);
    }

    @PostMapping(value={"/metadata/convert-to/{id}"})
    @QueryAction
    @Operation(summary="\u8f6c\u6362\u5e73\u53f0\u7684\u7269\u6a21\u578b\u4e3a\u6307\u5b9a\u7684\u7269\u6a21\u578b\u683c\u5f0f")
    public Mono<String> convertMetadataTo(@RequestBody Mono<String> metadata, @PathVariable String id) {
        return metadata.flatMap(str -> Flux.fromIterable(this.metadataCodecs).filter(codec -> codec.getId().equals(id)).next().flatMap(codec -> this.defaultCodec.decode(str).flatMap(arg_0 -> ((DeviceMetadataCodec)codec).encode(arg_0))));
    }

    @PostMapping(value={"/metadata/convert-from/{id}"})
    @QueryAction
    @Operation(summary="\u8f6c\u6362\u6307\u5b9a\u7684\u7269\u6a21\u578b\u4e3a\u5e73\u53f0\u7684\u7269\u6a21\u578b\u683c\u5f0f")
    public Mono<String> convertMetadataFrom(@RequestBody Mono<String> metadata, @PathVariable String id) {
        return metadata.flatMap(str -> Flux.fromIterable(this.metadataCodecs).filter(codec -> codec.getId().equals(id)).next().flatMap(codec -> codec.decode(str).flatMap(arg_0 -> ((DeviceMetadataCodec)this.defaultCodec).encode(arg_0))));
    }

    @PostMapping(value={"/{productId:.+}/deploy"})
    @SaveAction
    @Operation(summary="\u6fc0\u6d3b\u4ea7\u54c1")
    public Mono<Integer> deviceDeploy(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String productId) {
        return this.productService.deploy(productId);
    }

    @PostMapping(value={"/{productId:.+}/undeploy"})
    @SaveAction
    @Operation(summary="\u6ce8\u9500\u4ea7\u54c1")
    public Mono<Integer> cancelDeploy(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String productId) {
        return this.productService.cancelDeploy(productId);
    }

    @GetMapping(value={"/storage/policies"})
    @Operation(summary="\u83b7\u53d6\u652f\u6301\u7684\u6570\u636e\u5b58\u50a8\u7b56\u7565")
    public Flux<DeviceDataStorePolicyInfo> storePolicy() {
        return Flux.fromIterable(this.policies).map(DeviceDataStorePolicyInfo::of);
    }

    @PostMapping(value={"/{productId:.+}/agg/_query"})
    @QueryAction
    @Operation(summary="\u805a\u5408\u67e5\u8be2\u4ea7\u54c1\u4e0b\u8bbe\u5907\u5c5e\u6027")
    public Flux<Map<String, Object>> aggDeviceProperty(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String productId, @RequestBody Mono<AggRequest> param) {
        return param.flatMapMany(request -> this.deviceDataService.aggregationPropertiesByProduct(productId, request.getQuery(), request.getColumns().toArray(new DeviceDataService.DevicePropertyAggregation[0]))).map(AggregationData::values);
    }

    @GetMapping(value={"/{id:.+}/exists"})
    @QueryAction
    @Operation(summary="\u9a8c\u8bc1\u4ea7\u54c1ID\u662f\u5426\u5b58\u5728")
    public Mono<Boolean> deviceIdValidate(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String id) {
        return this.productService.findById(id).hasElement();
    }

    @GetMapping(value={"/id/_validate"})
    @QueryAction
    @Operation(summary="\u9a8c\u8bc1\u4ea7\u54c1ID\u662f\u5426\u5408\u6cd5")
    public Mono<ValidationResult> deviceIdValidate2(@RequestParam @Parameter(description="\u4ea7\u54c1ID") String id) {
        return LocaleUtils.currentReactive().flatMap(locale -> {
            DeviceProductEntity entity = new DeviceProductEntity();
            entity.setId(id);
            entity.validateId();
            return this.productService.findById(id).map(product -> ValidationResult.error((String)LocaleUtils.resolveMessage((String)"error.product_ID_already_exists", (Object[])new Object[]{locale}))).defaultIfEmpty((Object)ValidationResult.success());
        }).onErrorResume(ValidationException.class, e -> Mono.just((Object)e.getI18nCode()).map(ValidationResult::error));
    }

    @GetMapping(value={"/{productId}/property-metadata/template.{format}"})
    @QueryAction
    @Operation(summary="\u4e0b\u8f7d\u4ea7\u54c1\u7269\u6a21\u578b\u5c5e\u6027\u5bfc\u5165\u6a21\u5757")
    public Mono<Void> downloadExportPropertyMetadataTemplate(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String productId, ServerHttpResponse response, @PathVariable @Parameter(description="\u6587\u4ef6\u683c\u5f0f,\u652f\u6301csv,xlsx") String format) throws IOException {
        response.getHeaders().set("Content-Disposition", "attachment; filename=".concat(URLEncoder.encode("\u7269\u6a21\u578b\u5bfc\u5165\u6a21\u5757." + format, StandardCharsets.UTF_8.displayName())));
        return (Mono)this.configMetadataManager.getMetadataExpandsConfig(productId, DeviceMetadataType.property, "*", "*", new ConfigScope[]{DeviceConfigScope.product}).collectList().map(PropertyMetadataExcelInfo::getTemplateHeaderMapping).flatMapMany(headers -> ReactorExcel.writer((String)format).headers((Collection)headers).converter(PropertyMetadataExcelInfo::toMap).writeBuffer(PropertyMetadataExcelInfo.getTemplateContentMapping())).doOnError(err -> log.error(err.getMessage(), err)).map(arg_0 -> ((DataBufferFactory)this.bufferFactory).wrap(arg_0)).as(arg_0 -> ((ServerHttpResponse)response).writeWith(arg_0));
    }

    @PostMapping(value={"/{productId}/property-metadata/import"})
    @SaveAction
    @Operation(summary="\u89e3\u6790\u6587\u4ef6\u4e3a\u5c5e\u6027\u7269\u6a21\u578b")
    public Mono<String> importPropertyMetadata(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String productId, @RequestParam @Parameter(description="\u6587\u4ef6\u5730\u5740,\u652f\u6301csv,xlsx\u6587\u4ef6\u683c\u5f0f") String fileUrl) {
        return this.configMetadataManager.getMetadataExpandsConfig(productId, DeviceMetadataType.property, "*", "*", new ConfigScope[]{DeviceConfigScope.product}).collectList().map(PropertyMetadataWrapper::new).flatMap(wrapper -> this.importExportService.getInputStream(fileUrl).flatMapMany(inputStream -> ReactorExcel.read((InputStream)inputStream, (String)FileUtils.getExtension((String)fileUrl), (RowWrapper)wrapper)).map(PropertyMetadataExcelInfo::toMetadata).collectList()).filter(CollectionUtils::isNotEmpty).map(list -> {
            SimpleDeviceMetadata metadata = new SimpleDeviceMetadata();
            list.forEach(arg_0 -> ((SimpleDeviceMetadata)metadata).addProperty(arg_0));
            return JetLinksDeviceMetadataCodec.getInstance().doEncode((DeviceMetadata)metadata);
        });
    }

    public static class DeviceDataStorePolicyInfo {
        private String id;
        private String name;
        private String description;
        private ConfigMetadata configMetadata;

        public static DeviceDataStorePolicyInfo of(ThingsDataRepositoryStrategy strategy) {
            return new DeviceDataStorePolicyInfo(strategy.getId(), strategy.getName(), null, null);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public ConfigMetadata getConfigMetadata() {
            return this.configMetadata;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setConfigMetadata(ConfigMetadata configMetadata) {
            this.configMetadata = configMetadata;
        }

        public DeviceDataStorePolicyInfo(String id, String name, String description, ConfigMetadata configMetadata) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.configMetadata = configMetadata;
        }

        public DeviceDataStorePolicyInfo() {
        }
    }
}

