/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service;

import java.util.Collection;
import org.hswebframework.web.crud.events.EntityBeforeDeleteEvent;
import org.hswebframework.web.crud.events.EntityCreatedEvent;
import org.hswebframework.web.crud.events.EntityModifyEvent;
import org.hswebframework.web.crud.events.EntitySavedEvent;
import org.hswebframework.web.exception.BusinessException;
import org.jetlinks.community.device.entity.ProtocolSupportEntity;
import org.jetlinks.community.reference.DataReferenceManager;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoader;
import org.jetlinks.supports.protocol.management.ProtocolSupportManager;
import org.reactivestreams.Publisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class ProtocolSupportHandler {
    private final DataReferenceManager referenceManager;
    private ProtocolSupportLoader loader;
    private ProtocolSupportManager supportManager;

    @EventListener
    public void handleProtocolDelete(EntityBeforeDeleteEvent<ProtocolSupportEntity> event) {
        event.async((Publisher)Flux.fromIterable((Iterable)event.getEntity()).flatMap(protocol -> this.referenceManager.assertNotReferenced("protocol", (String)protocol.getId())));
    }

    @EventListener
    public void handleCreated(EntityCreatedEvent<ProtocolSupportEntity> event) {
        event.async(this.reloadProtocol(event.getEntity()));
    }

    @EventListener
    public void handleSaved(EntitySavedEvent<ProtocolSupportEntity> event) {
        event.async(this.reloadProtocol(event.getEntity()));
    }

    @EventListener
    public void handleModify(EntityModifyEvent<ProtocolSupportEntity> event) {
        event.async(this.reloadProtocol(event.getAfter()));
    }

    private Mono<Void> reloadProtocol(Collection<ProtocolSupportEntity> protocol) {
        return Flux.fromIterable(protocol).filter(entity -> entity.getState() != null).map(entity -> entity.getState() == 1 ? entity.toDeployDefinition() : entity.toUnDeployDefinition()).flatMap(def -> this.loader.load(def).doOnNext(ProtocolSupport::dispose).thenReturn(def)).onErrorMap(err -> new BusinessException("error.unable_to_load_protocol", 500, new Object[]{err.getMessage()})).flatMap(arg_0 -> ((ProtocolSupportManager)this.supportManager).save(arg_0)).then();
    }

    public ProtocolSupportHandler(DataReferenceManager referenceManager, ProtocolSupportLoader loader, ProtocolSupportManager supportManager) {
        this.referenceManager = referenceManager;
        this.loader = loader;
        this.supportManager = supportManager;
    }
}

