/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service;

import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.exception.NotFoundException;
import org.jetlinks.community.device.entity.ProtocolSupportEntity;
import org.jetlinks.community.reference.DataReferenceManager;
import org.jetlinks.supports.protocol.management.ProtocolSupportManager;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class LocalProtocolSupportService
extends GenericReactiveCrudService<ProtocolSupportEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(LocalProtocolSupportService.class);
    @Autowired
    private ProtocolSupportManager supportManager;
    @Autowired
    private DataReferenceManager referenceManager;

    public Mono<Integer> deleteById(Publisher<String> idPublisher) {
        return (Mono)Flux.from(idPublisher).flatMap(id -> this.supportManager.remove(id).thenReturn(id)).as(x$0 -> super.deleteById(x$0));
    }

    public Mono<Boolean> deploy(String id) {
        return this.findById(Mono.just((Object)id)).switchIfEmpty(Mono.error(NotFoundException::new)).flatMap(r -> ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(ProtocolSupportEntity::getState, (Object)1)).where(GenericEntity::getId, (Object)id)).execute()).map(i -> i > 0);
    }

    public Mono<Boolean> unDeploy(String id) {
        return this.referenceManager.assertNotReferenced("protocol", id).then(this.findById(Mono.just((Object)id))).switchIfEmpty(Mono.error(NotFoundException::new)).flatMap(r -> ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(ProtocolSupportEntity::getState, (Object)0)).where(GenericEntity::getId, (Object)id)).execute()).map(i -> i > 0);
    }
}

