/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service;

import java.util.Collection;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.exception.BusinessException;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.enums.DeviceProductState;
import org.jetlinks.community.device.events.DeviceProductDeployEvent;
import org.jetlinks.core.device.DeviceRegistry;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class LocalDeviceProductService
extends GenericReactiveCrudService<DeviceProductEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(LocalDeviceProductService.class);
    @Autowired
    private DeviceRegistry registry;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private ReactiveRepository<DeviceInstanceEntity, String> instanceRepository;

    public Mono<Integer> deploy(String id) {
        return this.findById(Mono.just((Object)id)).doOnNext(this::validateDeviceProduct).flatMap(product -> this.registry.register(product.toProductInfo()).onErrorMap(e -> new BusinessException("error.unable_to_load_protocol_by_access_id", 404, new Object[]{product.getMessageProtocol()})).then(((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(DeviceProductEntity::getState, (Object)DeviceProductState.registered.getValue())).where(DeviceProductEntity::getId, (Object)id)).execute()).flatMap(i -> ((DeviceProductDeployEvent)((Object)((Object)((Object)FastBeanCopier.copy((Object)product, (Object)((Object)new DeviceProductDeployEvent()), (String[])new String[0]))))).publish(this.eventPublisher).thenReturn(i)));
    }

    private void validateDeviceProduct(DeviceProductEntity product) {
        Assert.hasText((String)product.getMessageProtocol(), (String)"error.please_select_the_access_mode_first");
    }

    public Mono<Integer> cancelDeploy(String id) {
        return ((ReactiveUpdate)((ReactiveUpdate)this.createUpdate().set(DeviceProductEntity::getState, (Object)DeviceProductState.unregistered.getValue())).where(DeviceProductEntity::getId, (Object)id)).execute();
    }

    public Mono<Integer> deleteById(Publisher<String> idPublisher) {
        return Flux.from(idPublisher).collectList().flatMap(idList -> ((ReactiveQuery)((ReactiveQuery)this.instanceRepository.createQuery().where()).in(DeviceInstanceEntity::getProductId, (Collection)idList)).count().flatMap(i -> {
            if (i > 0) {
                return Mono.error((Throwable)new IllegalArgumentException("\u5b58\u5728\u5173\u8054\u8bbe\u5907,\u65e0\u6cd5\u5220\u9664!"));
            }
            return super.deleteById((Publisher)Flux.fromIterable((Iterable)idList));
        }));
    }
}

