/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.response;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetlinks.community.device.entity.DevicePropertiesEntity;
import org.jetlinks.community.device.enums.DeviceState;
import org.jetlinks.community.device.response.DeviceInfo;
import org.jetlinks.community.device.response.DeviceRunInfo;

public class DeviceAllInfoResponse {
    private DeviceInfo deviceInfo;
    private DeviceState realState;
    private long onlineTime;
    private long offlineTime;
    private Map<String, Object> properties;
    private Map<String, Integer> eventCounts;

    public static DeviceAllInfoResponse of(DeviceInfo deviceInfo, DeviceRunInfo deviceRunInfo) {
        DeviceAllInfoResponse info = new DeviceAllInfoResponse();
        info.setDeviceInfo(deviceInfo);
        info.setOfflineTime(deviceRunInfo.getOfflineTime());
        info.setOnlineTime(deviceRunInfo.getOnlineTime());
        info.setRealState(deviceRunInfo.getState());
        return info;
    }

    public DeviceAllInfoResponse ofProperties(List<DevicePropertiesEntity> properties) {
        this.setProperties(properties.stream().collect(Collectors.toMap(DevicePropertiesEntity::getProperty, DevicePropertiesEntity::getFormatValue)));
        return this;
    }

    public DeviceAllInfoResponse ofEventCounts(Map<String, Integer> eventCounts) {
        this.setEventCounts(eventCounts);
        return this;
    }

    public DeviceInfo getDeviceInfo() {
        return this.deviceInfo;
    }

    public DeviceState getRealState() {
        return this.realState;
    }

    public long getOnlineTime() {
        return this.onlineTime;
    }

    public long getOfflineTime() {
        return this.offlineTime;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Map<String, Integer> getEventCounts() {
        return this.eventCounts;
    }

    public void setDeviceInfo(DeviceInfo deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public void setRealState(DeviceState realState) {
        this.realState = realState;
    }

    public void setOnlineTime(long onlineTime) {
        this.onlineTime = onlineTime;
    }

    public void setOfflineTime(long offlineTime) {
        this.offlineTime = offlineTime;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setEventCounts(Map<String, Integer> eventCounts) {
        this.eventCounts = eventCounts;
    }
}

