/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.relation;

import org.jetlinks.community.PropertyConstants;
import org.jetlinks.community.device.service.LocalDeviceInstanceService;
import org.jetlinks.community.relation.RelationObjectProvider;
import org.jetlinks.community.relation.impl.SimpleObjectType;
import org.jetlinks.community.relation.impl.property.PropertyOperationStrategy;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.message.DeviceDataManager;
import org.jetlinks.core.things.relation.ObjectType;
import org.jetlinks.core.things.relation.PropertyOperation;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class DeviceObjectProvider
implements RelationObjectProvider {
    private final DeviceDataManager deviceDataManager;
    private final LocalDeviceInstanceService instanceService;
    private final DeviceRegistry registry;

    public String getTypeId() {
        return "device";
    }

    public Mono<ObjectType> getType() {
        return Mono.just((Object)new SimpleObjectType(this.getTypeId(), "\u8bbe\u5907", "\u8bbe\u5907"));
    }

    public PropertyOperation properties(String id) {
        return PropertyOperationStrategy.composite((PropertyOperationStrategy[])new PropertyOperationStrategy[]{PropertyOperationStrategy.simple((Mono)this.registry.getDevice(id), strategy -> strategy.addMapper("id", DeviceOperator::getDeviceId).addAsyncMapper((ConfigKey)PropertyConstants.deviceName, DeviceOperator::getSelfConfig).addAsyncMapper((ConfigKey)PropertyConstants.productName, DeviceOperator::getSelfConfig).addAsyncMapper((ConfigKey)PropertyConstants.productId, DeviceOperator::getSelfConfig).addAsyncMapper((ConfigKey)DeviceConfigKey.deviceType, DeviceOperator::getSelfConfig).addAsyncMapper((ConfigKey)DeviceConfigKey.parentGatewayId, DeviceOperator::getSelfConfig).addAsyncMapper(DeviceConfigKey.firstPropertyTime, DeviceOperator::getSelfConfig)), PropertyOperationStrategy.detect(strategy -> strategy.addOperation("property", key -> this.getDeviceProperty(id, key)).addOperation("tag", key -> this.deviceDataManager.getTags(id, new String[]{key}).map(DeviceDataManager.TagValue::getValue).singleOrEmpty()).addOperation("config", key -> this.registry.getDevice(id).flatMap(device -> device.getConfig(key))))});
    }

    protected Mono<Object> getDeviceProperty(String deviceId, String property) {
        if (!property.contains(".")) {
            return this.getPropertyValue(deviceId, property).map(DeviceDataManager.PropertyValue::getValue);
        }
        String[] arr = property.split("[.]");
        String propertyKey = arr[0];
        String valueType = arr[1];
        Mono<DeviceDataManager.PropertyValue> propertyValueMono = this.getPropertyValue(deviceId, propertyKey);
        if ("timestamp".equals(valueType)) {
            return propertyValueMono.map(DeviceDataManager.PropertyValue::getTimestamp);
        }
        if ("state".equals(valueType)) {
            return propertyValueMono.mapNotNull(DeviceDataManager.PropertyValue::getState);
        }
        return propertyValueMono.map(DeviceDataManager.PropertyValue::getValue);
    }

    Mono<DeviceDataManager.PropertyValue> getPropertyValue(String deviceId, String property) {
        return this.deviceDataManager.getLastProperty(deviceId, property);
    }

    public DeviceDataManager getDeviceDataManager() {
        return this.deviceDataManager;
    }

    public LocalDeviceInstanceService getInstanceService() {
        return this.instanceService;
    }

    public DeviceRegistry getRegistry() {
        return this.registry;
    }

    public DeviceObjectProvider(DeviceDataManager deviceDataManager, LocalDeviceInstanceService instanceService, DeviceRegistry registry) {
        this.deviceDataManager = deviceDataManager;
        this.instanceService = instanceService;
        this.registry = registry;
    }
}

