/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.measurements.status;

import io.micrometer.core.instrument.MeterRegistry;
import org.jetlinks.community.dashboard.DashboardDefinition;
import org.jetlinks.community.dashboard.Measurement;
import org.jetlinks.community.dashboard.ObjectDefinition;
import org.jetlinks.community.dashboard.supports.StaticMeasurementProvider;
import org.jetlinks.community.device.measurements.DeviceDashboardDefinition;
import org.jetlinks.community.device.measurements.DeviceObjectDefinition;
import org.jetlinks.community.device.measurements.status.DeviceStatusChangeMeasurement;
import org.jetlinks.community.device.measurements.status.DeviceStatusRecordMeasurement;
import org.jetlinks.community.device.service.LocalDeviceInstanceService;
import org.jetlinks.community.device.timeseries.DeviceTimeSeriesMetric;
import org.jetlinks.community.gateway.annotation.Subscribe;
import org.jetlinks.community.micrometer.MeterRegistryManager;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.message.DeviceMessage;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class DeviceStatusMeasurementProvider
extends StaticMeasurementProvider {
    private final MeterRegistry registry;

    public DeviceStatusMeasurementProvider(MeterRegistryManager registryManager, LocalDeviceInstanceService instanceService, TimeSeriesManager timeSeriesManager, EventBus eventBus) {
        super((DashboardDefinition)DeviceDashboardDefinition.instance, (ObjectDefinition)DeviceObjectDefinition.status);
        this.addMeasurement((Measurement)new DeviceStatusChangeMeasurement(timeSeriesManager, eventBus));
        this.addMeasurement((Measurement)new DeviceStatusRecordMeasurement(instanceService, timeSeriesManager));
        this.registry = registryManager.getMeterRegister(DeviceTimeSeriesMetric.deviceMetrics().getId(), new String[]{"target", "msgType", "productId"});
    }

    @Subscribe(value={"/device/*/*/online"})
    public Mono<Void> incrementOnline(DeviceMessage msg) {
        return Mono.fromRunnable(() -> {
            String productId = this.parseProductId(msg);
            this.registry.counter("online", new String[]{"productId", productId}).increment();
        });
    }

    @Subscribe(value={"/device/*/*/offline"})
    public Mono<Void> incrementOffline(DeviceMessage msg) {
        return Mono.fromRunnable(() -> {
            String productId = this.parseProductId(msg);
            this.registry.counter("offline", new String[]{"productId", productId}).increment();
        });
    }

    private String parseProductId(DeviceMessage msg) {
        return msg.getHeader("productId").map(String::valueOf).orElse("unknown");
    }
}

