/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.enums;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.web.dict.EnumDict;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.MessageType;

public enum DeviceLogType implements EnumDict<String>
{
    event("\u4e8b\u4ef6\u4e0a\u62a5"),
    readProperty("\u8bfb\u53d6\u5c5e\u6027"),
    writeProperty("\u4fee\u6539\u5c5e\u6027"),
    writePropertyReply("\u4fee\u6539\u5c5e\u6027\u56de\u590d"),
    reportProperty("\u5c5e\u6027\u4e0a\u62a5"),
    readPropertyReply("\u8bfb\u53d6\u5c5e\u6027\u56de\u590d"),
    child("\u5b50\u8bbe\u5907\u6d88\u606f"),
    childReply("\u5b50\u8bbe\u5907\u6d88\u606f\u56de\u590d"),
    functionInvoke("\u8c03\u7528\u529f\u80fd"),
    functionReply("\u8c03\u7528\u529f\u80fd\u56de\u590d"),
    register("\u8bbe\u5907\u6ce8\u518c"),
    unregister("\u8bbe\u5907\u6ce8\u9500"),
    log("\u65e5\u5fd7"),
    tag("\u6807\u7b7e\u66f4\u65b0"),
    offline("\u79bb\u7ebf"),
    online("\u4e0a\u7ebf"),
    other("\u5176\u5b83");

    @JSONField(serialize=false)
    private final String text;
    private static final Map<MessageType, DeviceLogType> typeMapping;

    public String getValue() {
        return this.name();
    }

    public static DeviceLogType of(DeviceMessage message) {
        return Optional.ofNullable(typeMapping.get(message.getMessageType())).orElse(other);
    }

    private DeviceLogType(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    static {
        typeMapping = new EnumMap<MessageType, DeviceLogType>(MessageType.class);
        typeMapping.put(MessageType.EVENT, event);
        typeMapping.put(MessageType.ONLINE, online);
        typeMapping.put(MessageType.OFFLINE, offline);
        typeMapping.put(MessageType.CHILD, child);
        typeMapping.put(MessageType.CHILD_REPLY, childReply);
        typeMapping.put(MessageType.LOG, log);
        typeMapping.put(MessageType.UPDATE_TAG, tag);
        typeMapping.put(MessageType.REPORT_PROPERTY, reportProperty);
        typeMapping.put(MessageType.READ_PROPERTY, readProperty);
        typeMapping.put(MessageType.READ_PROPERTY_REPLY, readPropertyReply);
        typeMapping.put(MessageType.INVOKE_FUNCTION, functionInvoke);
        typeMapping.put(MessageType.INVOKE_FUNCTION_REPLY, functionReply);
        typeMapping.put(MessageType.WRITE_PROPERTY, writeProperty);
        typeMapping.put(MessageType.WRITE_PROPERTY_REPLY, writePropertyReply);
        typeMapping.put(MessageType.REGISTER, register);
        typeMapping.put(MessageType.UN_REGISTER, unregister);
    }
}

