/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.entity;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.api.crud.entity.RecordModifierEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import org.hswebframework.web.validator.UpdateGroup;
import org.jetlinks.community.PropertyConstants;
import org.jetlinks.community.device.enums.DeviceType;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.ProductInfo;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.SimpleDeviceMetadata;
import org.jetlinks.supports.official.JetLinksDeviceMetadataCodec;
import org.springframework.util.StringUtils;

@Table(name="dev_product", indexes={@Index(name="idx_prod_class_id", columnList="classified_id")})
@Comment(value="\u4ea7\u54c1\u4fe1\u606f\u8868")
@EnableEntityEvent
public class DeviceProductEntity
extends GenericEntity<String>
implements RecordCreationEntity,
RecordModifierEntity {
    @Column(name="name")
    @NotBlank(message="\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u4ea7\u54c1\u540d\u79f0")
    private @NotBlank(message="\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String name;
    @Schema(description="\u6240\u5c5e\u9879\u76ee")
    @Column(name="project_id", length=64)
    @Hidden
    private String projectId;
    @Column(name="photo_url", length=1024)
    @Schema(description="\u56fe\u7247\u5730\u5740")
    private String photoUrl;
    @Schema(description="\u9879\u76ee\u540d\u79f0")
    @Column(name="project_name")
    @Hidden
    private String projectName;
    @Column(name="describe")
    @Schema(description="\u8bf4\u660e")
    private String describe;
    @Column(name="classified_id", length=64)
    @Schema(description="\u6240\u5c5e\u54c1\u7c7bID")
    private String classifiedId;
    @Column(name="classified_name")
    @Schema(description="\u6240\u5c5e\u54c1\u7c7b\u540d\u79f0")
    private String classifiedName;
    @Column(name="message_protocol")
    @Length(min=1, max=256, groups={CreateGroup.class, UpdateGroup.class})
    @Schema(description="\u6d88\u606f\u534f\u8baeID")
    private @Length(min=1, max=256, groups={CreateGroup.class, UpdateGroup.class}) String messageProtocol;
    @Column
    @Schema(description="\u6d88\u606f\u534f\u8bae\u540d\u79f0")
    @Deprecated
    private String protocolName;
    @Column(name="metadata")
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR)
    @Schema(description="\u7269\u6a21\u578b\u5b9a\u4e49")
    private String metadata;
    @Column(name="transport_protocol")
    @Schema(description="\u4f20\u8f93\u534f\u8bae")
    private String transportProtocol;
    @Column(name="network_way")
    @Schema(description="\u5165\u7f51\u65b9\u5f0f")
    private String networkWay;
    @Column(name="device_type")
    @ColumnType(javaType=String.class)
    @EnumCodec
    @Schema(description="\u8bbe\u5907\u7c7b\u578b")
    private DeviceType deviceType;
    @Column(name="configuration")
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR)
    @Schema(description="\u534f\u8bae\u76f8\u5173\u914d\u7f6e")
    private Map<String, Object> configuration;
    @Column(name="state")
    @DefaultValue(value="0")
    @Schema(description="\u4ea7\u54c1\u72b6\u6001 1\u6b63\u5e38,0\u7981\u7528")
    private Byte state;
    @Column(name="creator_id", updatable=false)
    @Schema(description="\u521b\u5efa\u8005ID(\u53ea\u8bfb)")
    private String creatorId;
    @Column(name="create_time", updatable=false)
    @Schema(description="\u521b\u5efa\u8005\u65f6\u95f4(\u53ea\u8bfb)")
    @DefaultValue(generator="current_time")
    private Long createTime;
    @Column(name="org_id", length=64)
    @Schema(description="\u673a\u6784ID")
    @Deprecated
    @Hidden
    private String orgId;
    @Column(length=64)
    @Schema(description="\u8bbe\u5907\u63a5\u5165\u65b9\u5f0fID")
    private String accessId;
    @Column(length=64)
    @Schema(description="\u8bbe\u5907\u63a5\u5165\u65b9\u5f0f")
    private String accessProvider;
    @Column
    @Schema(description="\u8bbe\u5907\u63a5\u5165\u65b9\u5f0f\u540d\u79f0")
    private String accessName;
    @Column
    @Schema(description="\u6570\u636e\u5b58\u50a8\u7b56\u7565")
    private String storePolicy;
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.CLOB)
    @Schema(description="\u6570\u636e\u5b58\u50a8\u7b56\u7565\u76f8\u5173\u914d\u7f6e")
    private Map<String, Object> storePolicyConfiguration;
    @Column(length=64)
    @Schema(description="\u4fee\u6539\u4eba")
    private String modifierId;
    @Column
    @Schema(description="\u4fee\u6539\u65f6\u95f4")
    private Long modifyTime;

    @GeneratedValue(generator="snow_flake")
    @Pattern(regexp="^[0-9a-zA-Z_\\-]+$", message="ID\u53ea\u80fd\u7531\u6570\u5b57,\u5b57\u6bcd,\u4e0b\u5212\u7ebf\u548c\u4e2d\u5212\u7ebf\u7ec4\u6210", groups={CreateGroup.class})
    @Schema(description="ID")
    public @Pattern(regexp="^[0-9a-zA-Z_\\-]+$", message="ID\u53ea\u80fd\u7531\u6570\u5b57,\u5b57\u6bcd,\u4e0b\u5212\u7ebf\u548c\u4e2d\u5212\u7ebf\u7ec4\u6210", groups={CreateGroup.class}) String getId() {
        return (String)super.getId();
    }

    public Optional<Transport> getTransportEnum(Collection<? extends Transport> candidates) {
        for (Transport transport : candidates) {
            if (!transport.isSame(this.transportProtocol)) continue;
            return Optional.of(transport);
        }
        return Optional.empty();
    }

    public ProductInfo toProductInfo() {
        return ProductInfo.builder().id(this.getId()).protocol(this.getMessageProtocol()).metadata(this.getMetadata()).build().addConfig(DeviceConfigKey.isGatewayDevice, (Object)(this.getDeviceType() == DeviceType.gateway ? 1 : 0)).addConfig("storePolicy", (Object)this.storePolicy).addConfig("storePolicyConfiguration", this.storePolicyConfiguration).addConfig("deviceType", (Object)(this.deviceType == null ? "device" : this.deviceType.getValue())).addConfig((ConfigKey)PropertyConstants.accessId, (Object)this.accessId).addConfig((ConfigKey)PropertyConstants.accessProvider, (Object)this.accessProvider).addConfigs(this.configuration);
    }

    public DeviceMetadata parseMetadata() {
        if (StringUtils.hasText((String)this.metadata)) {
            return JetLinksDeviceMetadataCodec.getInstance().doDecode(this.metadata);
        }
        return new SimpleDeviceMetadata();
    }

    public void validateId() {
        this.tryValidate(DeviceProductEntity::getId, new Class[]{CreateGroup.class});
    }

    public String getName() {
        return this.name;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getDescribe() {
        return this.describe;
    }

    public String getClassifiedId() {
        return this.classifiedId;
    }

    public String getClassifiedName() {
        return this.classifiedName;
    }

    public String getMessageProtocol() {
        return this.messageProtocol;
    }

    @Deprecated
    public String getProtocolName() {
        return this.protocolName;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public String getTransportProtocol() {
        return this.transportProtocol;
    }

    public String getNetworkWay() {
        return this.networkWay;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public Byte getState() {
        return this.state;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    @Deprecated
    public String getOrgId() {
        return this.orgId;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getAccessProvider() {
        return this.accessProvider;
    }

    public String getAccessName() {
        return this.accessName;
    }

    public String getStorePolicy() {
        return this.storePolicy;
    }

    public Map<String, Object> getStorePolicyConfiguration() {
        return this.storePolicyConfiguration;
    }

    public String getModifierId() {
        return this.modifierId;
    }

    public Long getModifyTime() {
        return this.modifyTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public void setClassifiedId(String classifiedId) {
        this.classifiedId = classifiedId;
    }

    public void setClassifiedName(String classifiedName) {
        this.classifiedName = classifiedName;
    }

    public void setMessageProtocol(String messageProtocol) {
        this.messageProtocol = messageProtocol;
    }

    @Deprecated
    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setTransportProtocol(String transportProtocol) {
        this.transportProtocol = transportProtocol;
    }

    public void setNetworkWay(String networkWay) {
        this.networkWay = networkWay;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    @Deprecated
    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public void setAccessProvider(String accessProvider) {
        this.accessProvider = accessProvider;
    }

    public void setAccessName(String accessName) {
        this.accessName = accessName;
    }

    public void setStorePolicy(String storePolicy) {
        this.storePolicy = storePolicy;
    }

    public void setStorePolicyConfiguration(Map<String, Object> storePolicyConfiguration) {
        this.storePolicyConfiguration = storePolicyConfiguration;
    }

    public void setModifierId(String modifierId) {
        this.modifierId = modifierId;
    }

    public void setModifyTime(Long modifyTime) {
        this.modifyTime = modifyTime;
    }
}

