/*
 * Decompiled with CFR 0.152.
 */
package net.zstong.awump.device.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.zstong.awump.base.service.AwIntensiveFrameService;
import net.zstong.awump.device.repository.DeviceInsanceRepository;
import net.zstong.awump.device.web.response.CountDeviceData;
import net.zstong.awump.device.web.response.DeviceInfo;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.api.crud.entity.QueryNoPagingOperation;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.Resource;
import org.jetlinks.community.device.service.LocalDeviceInstanceService;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/aw/dev/overview"})
@Resource(id="aw-dev-overview", name="\u8bbe\u5907\u76d1\u6d4b\u63a5\u53e3")
@Tag(name="\u8bbe\u5907\u76d1\u6d4b\u63a5\u53e3")
public class DevViewController {
    private static final Logger log = LoggerFactory.getLogger(DevViewController.class);
    @Autowired
    private LocalDeviceInstanceService deviceInstanceService;
    @Autowired
    private AwIntensiveFrameService awIntensiveFrameService;
    @Autowired
    private DeviceInsanceRepository deviceInsanceRepository;

    @GetMapping(value={"/{productId}/{deviceId}"})
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f")
    @Authorize(merge=false)
    public Mono<DeviceInfo> getDeviceInfo(@PathVariable @Parameter(description="\u4ea7\u54c1\u5206\u7c7b") String productId, @PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId) {
        return Mono.just((Object)productId).flatMap(p -> {
            if ("MJJ".equals(p)) {
                return ((ReactiveQuery)this.awIntensiveFrameService.createQuery().where("id", (Object)deviceId)).fetchOne().map(d -> DeviceInfo.of(d));
            }
            return ((ReactiveQuery)this.deviceInstanceService.createQuery().where("id", (Object)deviceId)).fetchOne().map(d -> DeviceInfo.of(d));
        });
    }

    @PostMapping(value={"/count"})
    @Operation(summary="\u7edf\u8ba1\u8bbe\u5907\u60c5\u51b5")
    @Authorize(merge=false)
    public Flux<CountDeviceData> countDevice(@RequestBody Map params) {
        return this.deviceInsanceRepository.countByWarehouse().flatMap(w -> {
            if (w.getWarehouse() == null) {
                w.setWarehouse("unknow");
                w.setWarehouseName("\u672a\u77e5");
                return this.deviceInsanceRepository.countByNonWarehouse().collectList().map(l -> {
                    w.setDetail((List<CountDeviceData>)l);
                    return w;
                });
            }
            return this.deviceInsanceRepository.countByWarehouse(w.getWarehouse()).collectList().map(l -> {
                w.setDetail((List<CountDeviceData>)l);
                return w;
            });
        }).sort(Comparator.comparing(CountDeviceData::getWarehouseName)).mergeWith((Publisher)Mono.just((Object)new CountDeviceData("all", "\u5168\u90e8", null, 0, null)).flatMap(a -> this.deviceInsanceRepository.countByState().collectList().map(l -> {
            a.setDetail((List<CountDeviceData>)l);
            l.forEach(x -> a.setTotal(a.getTotal() + x.getTotal()));
            return a;
        })));
    }
}

