/*
 * Decompiled with CFR 0.152.
 */
package net.zstong.awump.device.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.util.Map;
import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.validator.CreateGroup;
import org.jetlinks.community.device.enums.DeviceFeature;
import org.jetlinks.community.device.enums.DeviceState;
import org.jetlinks.community.device.enums.DeviceType;
import org.springframework.data.relational.core.mapping.Table;

@Table(name="dev_device_instance")
@Comment(value="\u8bbe\u5907\u4fe1\u606f\u8868")
public class DeviceInstance {
    private String id;
    @Schema(description="\u6240\u5c5e\u5e93\u623f")
    @Column(name="warehouse_id_", length=64)
    private String warehouseId;
    @Schema(description="\u8bbe\u5907\u7f16\u7801")
    @Column(name="code_", length=64)
    private String code;
    @Schema(description="\u54c1\u724c")
    @Column(name="brand_", length=200)
    private String brand;
    @Schema(description="\u8bbe\u5907\u578b\u53f7")
    @Column(name="model_", length=200)
    private String model;
    @Schema(description="\u8d1f\u8d23\u4eba")
    @Column(name="custodian_", length=32)
    private String custodian;
    @Schema(description="\u8d1f\u8d23\u4eba\u8054\u7cfb\u65b9\u5f0f")
    @Column(name="phone_", length=32)
    private String phone;
    @Schema(description="\u8bbe\u5907\u4f4d\u7f6e")
    @Column(name="location_", length=64)
    private String location;
    @Schema(description="\u51fa\u5382\u65e5\u671f")
    @Column(name="manufacture_date_")
    @JsonFormat(pattern="yyyy-MM-dd")
    private LocalDate manufactureDate;
    @Column(name="photo_url", length=2048)
    @Schema(description="\u56fe\u7247\u5730\u5740")
    private String photoUrl;
    @Column(name="name")
    @NotBlank(message="\u8bbe\u5907\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u8bbe\u5907\u540d\u79f0")
    private @NotBlank(message="\u8bbe\u5907\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String name;
    @Column
    @ColumnType(javaType=String.class)
    @EnumCodec
    @Schema(description="\u8bbe\u5907\u7c7b\u578b")
    private DeviceType deviceType;
    @Comment(value="\u8bf4\u660e")
    @Column(name="describe")
    @Schema(description="\u8bf4\u660e")
    private String describe;
    @Column(name="product_id", length=64)
    @NotBlank(message="\u4ea7\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u4ea7\u54c1ID")
    private @NotBlank(message="\u4ea7\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String productId;
    @Column(name="product_name")
    @NotBlank(message="\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u4ea7\u54c1\u540d\u79f0")
    private @NotBlank(message="\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String productName;
    @Column(name="configuration")
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR)
    @JsonCodec
    @Schema(description="\u914d\u7f6e\u4fe1\u606f")
    private Map<String, Object> configuration;
    @Column(name="derive_metadata")
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR)
    @Schema(description="\u6d3e\u751f(\u72ec\u7acb)\u7269\u6a21\u578b")
    private String deriveMetadata;
    @Column(name="state", length=16)
    @EnumCodec
    @ColumnType(javaType=String.class)
    @DefaultValue(value="notActive")
    @Schema(description="\u72b6\u6001(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY, defaultValue="notActive")
    private DeviceState state;
    @Column(name="creator_id", updatable=false)
    @Schema(description="\u521b\u5efa\u8005ID(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private String creatorId;
    @Column(name="creator_name", updatable=false)
    @Schema(description="\u521b\u5efa\u8005\u540d\u79f0(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private String creatorName;
    @Column(name="create_time", updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private Long createTime;
    @Column(name="registry_time")
    @Schema(description="\u6fc0\u6d3b\u65f6\u95f4", accessMode=Schema.AccessMode.READ_ONLY)
    private Long registryTime;
    @Column(name="org_id", length=64)
    @Schema(description="\u673a\u6784ID", hidden=true)
    @Deprecated
    private String orgId;
    @Column(name="parent_id", length=64)
    @Schema(description="\u7236\u7ea7\u8bbe\u5907ID")
    private String parentId;
    @Column
    @ColumnType(javaType=Long.class, jdbcType=JDBCType.BIGINT)
    @EnumCodec(toMask=true)
    @Schema(description="\u8bbe\u5907\u7279\u6027")
    @DefaultValue(value="0")
    private DeviceFeature[] features;
    @Column
    @DefaultValue(generator="current_time")
    @Schema(description="\u4fee\u6539\u65f6\u95f4", accessMode=Schema.AccessMode.READ_ONLY)
    private Long modifyTime;
    @Column(length=64)
    @Schema(description="\u4fee\u6539\u4ebaID", accessMode=Schema.AccessMode.READ_ONLY)
    private String modifierId;
    @Column(length=64)
    @Schema(description="\u4fee\u6539\u4eba\u540d\u79f0", accessMode=Schema.AccessMode.READ_ONLY)
    private String modifierName;

    public String getId() {
        return this.id;
    }

    public String getWarehouseId() {
        return this.warehouseId;
    }

    public String getCode() {
        return this.code;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getModel() {
        return this.model;
    }

    public String getCustodian() {
        return this.custodian;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getLocation() {
        return this.location;
    }

    public LocalDate getManufactureDate() {
        return this.manufactureDate;
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public String getName() {
        return this.name;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public String getDescribe() {
        return this.describe;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductName() {
        return this.productName;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getDeriveMetadata() {
        return this.deriveMetadata;
    }

    public DeviceState getState() {
        return this.state;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getRegistryTime() {
        return this.registryTime;
    }

    @Deprecated
    public String getOrgId() {
        return this.orgId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public DeviceFeature[] getFeatures() {
        return this.features;
    }

    public Long getModifyTime() {
        return this.modifyTime;
    }

    public String getModifierId() {
        return this.modifierId;
    }

    public String getModifierName() {
        return this.modifierName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setCustodian(String custodian) {
        this.custodian = custodian;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @JsonFormat(pattern="yyyy-MM-dd")
    public void setManufactureDate(LocalDate manufactureDate) {
        this.manufactureDate = manufactureDate;
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public void setDeriveMetadata(String deriveMetadata) {
        this.deriveMetadata = deriveMetadata;
    }

    public void setState(DeviceState state) {
        this.state = state;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setRegistryTime(Long registryTime) {
        this.registryTime = registryTime;
    }

    @Deprecated
    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setFeatures(DeviceFeature[] features) {
        this.features = features;
    }

    public void setModifyTime(Long modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setModifierId(String modifierId) {
        this.modifierId = modifierId;
    }

    public void setModifierName(String modifierName) {
        this.modifierName = modifierName;
    }
}

