/*
 * Decompiled with CFR 0.152.
 */
package net.zstong.awump.base.service;

import java.util.Collection;
import java.util.List;
import net.zstong.awump.base.entity.AwInstitutionEntity;
import net.zstong.awump.base.entity.AwRegionEntity;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.crud.service.GenericReactiveTreeSupportCrudService;
import org.hswebframework.web.id.IDGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class AwRegionService
extends GenericReactiveTreeSupportCrudService<AwRegionEntity, String> {
    @Autowired
    private ReactiveRepository<AwInstitutionEntity, String> institutionRepository;

    public IDGenerator<String> getIDGenerator() {
        return IDGenerator.MD5;
    }

    public void setChildren(AwRegionEntity entity, List<AwRegionEntity> children) {
        entity.setChildren(children);
    }

    public Flux<AwRegionEntity> getAllCategoryTreeByQueryParam(Mono<QueryParamEntity> query) {
        return this.query(query).flatMap(r -> ((ReactiveQuery)this.institutionRepository.createQuery().where(AwInstitutionEntity::getRegionId, r.getId())).count().map(count -> {
            r.setCountInstitution((Integer)count);
            return r;
        })).collectList().flatMapMany(all -> {
            List t = TreeSupportEntity.list2tree((Collection)all, AwRegionEntity::setChildren);
            this.countInstitutionNum(t);
            return Flux.fromIterable((Iterable)t);
        });
    }

    private int countInstitutionNum(List<AwRegionEntity> t) {
        int count = 0;
        for (AwRegionEntity e : t) {
            if (e.getChildren() != null && e.getChildren().size() > 0) {
                e.setCountInstitution(e.getCountInstitution() + this.countInstitutionNum(e.getChildren()));
            }
            count += e.getCountInstitution().intValue();
        }
        return count;
    }
}

