/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.message;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.service.LocalDeviceInstanceService;
import org.jetlinks.community.gateway.external.SubscribeRequest;
import org.jetlinks.community.gateway.external.SubscriptionProvider;
import org.jetlinks.core.utils.TopicUtils;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@Component
public class DeviceBatchOperationSubscriptionProvider
implements SubscriptionProvider {
    private final LocalDeviceInstanceService instanceService;

    public DeviceBatchOperationSubscriptionProvider(LocalDeviceInstanceService instanceService) {
        this.instanceService = instanceService;
    }

    public String id() {
        return "device-batch-operator";
    }

    public String name() {
        return "\u8bbe\u5907\u6279\u91cf\u64cd\u4f5c";
    }

    public String[] getTopicPattern() {
        return new String[]{"/device-batch/*"};
    }

    public Flux<?> subscribe(SubscribeRequest request) {
        String type;
        String topic = request.getTopic();
        QueryParamEntity queryParamEntity = request.get("query").map(json -> {
            if (json instanceof Map) {
                return new JSONObject((Map)json);
            }
            return JSON.parseObject((String)String.valueOf(json));
        }).map(json -> (QueryParamEntity)json.toJavaObject(QueryParamEntity.class)).orElseGet(QueryParamEntity::new);
        Map var = TopicUtils.getPathVariables((String)"/device-batch/{type}", (String)topic);
        switch (type = (String)var.get("type")) {
            case "state-sync": {
                return this.handleStateSync(queryParamEntity);
            }
            case "deploy": {
                return this.handleDeploy(queryParamEntity);
            }
        }
        return Flux.error((Throwable)new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b:" + type));
    }

    private Flux<?> handleDeploy(QueryParamEntity queryParamEntity) {
        return (Flux)this.instanceService.query((QueryParamEntity)queryParamEntity.noPaging().includes(new String[]{"id"})).as(this.instanceService::deploy);
    }

    private Flux<?> handleStateSync(QueryParamEntity queryParamEntity) {
        return this.instanceService.query((QueryParamEntity)queryParamEntity.noPaging().includes(new String[]{"id"})).map(DeviceInstanceEntity::getId).buffer(200).publishOn(Schedulers.single()).concatMap(flux -> this.instanceService.syncStateBatch((Flux<List<String>>)Flux.just((Object)flux), true)).flatMap(Flux::fromIterable);
    }
}

