/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.message;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.device.entity.DeviceTagEntity;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.community.gateway.DeviceMessageUtils;
import org.jetlinks.community.gateway.annotation.Subscribe;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.message.DeviceDataManager;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class DefaultDeviceDataManager
implements DeviceDataManager {
    private final DeviceRegistry registry;
    private final DeviceDataService dataService;
    private final EventBus eventBus;
    private final ReactiveRepository<DeviceTagEntity, String> tagRepository;
    private final Map<String, DevicePropertyRef> localCache = DefaultDeviceDataManager.newCache();
    static Object NULL = new Object();

    static <K, V> Map<K, V> newCache() {
        return Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).removalListener((key, value, removalCause) -> {
            if (value instanceof Disposable) {
                ((Disposable)value).dispose();
            }
        }).build().asMap();
    }

    public Mono<DeviceDataManager.PropertyValue> getLastProperty(@Nonnull String deviceId, @Nonnull String propertyId) {
        return this.localCache.computeIfAbsent(deviceId, id -> new DevicePropertyRef((String)id, this.eventBus, this.dataService)).getLastProperty(propertyId, System.currentTimeMillis());
    }

    public Mono<DeviceDataManager.PropertyValue> getLastProperty(@Nonnull String deviceId, @Nonnull String propertyId, long baseTime) {
        return this.localCache.computeIfAbsent(deviceId, id -> new DevicePropertyRef((String)id, this.eventBus, this.dataService)).getLastProperty(propertyId, baseTime);
    }

    public Mono<Long> getLastPropertyTime(@Nonnull String deviceId, long baseTime) {
        return this.localCache.computeIfAbsent(deviceId, id -> new DevicePropertyRef((String)id, this.eventBus, this.dataService)).getRecentPropertyTime(baseTime);
    }

    public Mono<Long> getFirstPropertyTime(@Nonnull String deviceId) {
        return this.registry.getDevice(deviceId).flatMap(device -> device.getSelfConfig(DeviceConfigKey.firstPropertyTime));
    }

    public Mono<DeviceDataManager.PropertyValue> getFirstProperty(@Nonnull String deviceId, @Nonnull String propertyId) {
        return this.localCache.computeIfAbsent(deviceId, id -> new DevicePropertyRef((String)id, this.eventBus, this.dataService)).getFirstProperty(propertyId);
    }

    public Flux<DeviceDataManager.TagValue> getTags(@Nonnull String deviceId, String ... tagIdList) {
        Assert.hasText((String)deviceId, (String)"deviceId must not be empty");
        return this.registry.getDevice(deviceId).flatMap(DeviceOperator::getMetadata).flatMapMany(metadata -> ((ReactiveQuery)((ReactiveQuery)this.tagRepository.createQuery().where(DeviceTagEntity::getDeviceId, (Object)deviceId)).when(tagIdList != null && tagIdList.length > 0, q -> {
            ReactiveQuery cfr_ignored_0 = (ReactiveQuery)q.in(DeviceTagEntity::getKey, (Object[])tagIdList);
        })).fetch().map(tag -> DefaultTagValue.of(tag.getKey(), tag.getValue(), metadata.getTagOrNull(tag.getKey()))));
    }

    @Subscribe(topics={"/device/*/*/message/property/report", "/device/*/*/message/property/read,write/reply"}, features={Subscription.Feature.local})
    public Mono<Void> upgradeDeviceFirstPropertyTime(DeviceMessage message) {
        return this.registry.getDevice(message.getDeviceId()).flatMap(device -> device.getSelfConfig(DeviceConfigKey.firstPropertyTime).switchIfEmpty(device.setConfig(DeviceConfigKey.firstPropertyTime, (Object)message.getTimestamp()).thenReturn((Object)message.getTimestamp()))).then();
    }

    public DefaultDeviceDataManager(DeviceRegistry registry, DeviceDataService dataService, EventBus eventBus, ReactiveRepository<DeviceTagEntity, String> tagRepository) {
        this.registry = registry;
        this.dataService = dataService;
        this.eventBus = eventBus;
        this.tagRepository = tagRepository;
    }

    static class DevicePropertyRef
    implements Disposable {
        Disposable disposable;
        Map<String, PropertyRef> refs = DefaultDeviceDataManager.newCache();
        String deviceId;
        DeviceDataService dataService;
        private long lastPropertyTime;
        private long propertyTime;

        public DevicePropertyRef(String deviceId, EventBus eventBus, DeviceDataService dataService) {
            this.dataService = dataService;
            this.deviceId = deviceId;
            Subscription subscription = Subscription.builder().subscriberId("device_recent_property:" + deviceId).topics(new String[]{"/device/*/" + deviceId + "/message/property/report", "/device/*/" + deviceId + "/message/property/read,write/reply"}).broker().local().build();
            this.disposable = eventBus.subscribe(subscription, DeviceMessage.class).subscribe(this::upgrade);
        }

        private void upgrade(DeviceMessage message) {
            Map properties = DeviceMessageUtils.tryGetProperties((DeviceMessage)message).orElseGet(Collections::emptyMap);
            Map propertyTime = DeviceMessageUtils.tryGetPropertySourceTimes((DeviceMessage)message).orElseGet(Collections::emptyMap);
            Map propertyState = DeviceMessageUtils.tryGetPropertyStates((DeviceMessage)message).orElse(Collections.emptyMap());
            for (Map.Entry entry : properties.entrySet()) {
                PropertyRef ref = this.refs.get(entry.getKey());
                if (null == ref) continue;
                ref.setValue(entry.getValue(), propertyTime.getOrDefault(entry.getKey(), message.getTimestamp()), propertyState.getOrDefault(entry.getKey(), ref.state));
            }
            this.updatePropertyTime(message.getTimestamp());
        }

        private long updatePropertyTime(long timestamp) {
            if (this.propertyTime <= timestamp) {
                this.lastPropertyTime = this.propertyTime;
                this.propertyTime = timestamp;
            }
            return this.propertyTime;
        }

        public Mono<DeviceDataManager.PropertyValue> getFirstProperty(String property) {
            PropertyRef ref = this.refs.computeIfAbsent(property, ignore -> new PropertyRef());
            if (ref.first != null && ref.first.getValue() != null) {
                if (ref.first.getValue() == NULL) {
                    return Mono.empty();
                }
                return Mono.just((Object)ref.first);
            }
            return this.dataService.queryProperty(this.deviceId, (QueryParamEntity)QueryParamEntity.newQuery().orderByAsc("timestamp").getParam(), new String[0]).take(1L).singleOrEmpty().map(prop -> ref.setFirst(prop.getValue(), prop.getTimestamp())).switchIfEmpty(Mono.fromRunnable(ref::setFirstNull));
        }

        public Mono<Long> getRecentPropertyTime(long baseTime) {
            if (this.propertyTime == -1L) {
                return Mono.empty();
            }
            if (this.propertyTime > 0L && this.propertyTime < baseTime) {
                return Mono.just((Object)this.propertyTime);
            }
            if (this.lastPropertyTime > 0L && this.lastPropertyTime < baseTime) {
                return Mono.just((Object)this.lastPropertyTime);
            }
            return ((Flux)((Query)QueryParamEntity.newQuery().orderByDesc("timestamp").when(this.propertyTime > 0L, q -> {
                Query cfr_ignored_0 = (Query)q.lt("timestamp", (Object)baseTime);
            })).doPaging(0, 1).execute(param -> this.dataService.queryProperty(this.deviceId, (QueryParamEntity)param, new String[0]))).take(1L).singleOrEmpty().map(val -> {
                if (this.propertyTime <= 0L) {
                    this.updatePropertyTime(val.getTimestamp());
                }
                return val.getTimestamp();
            }).switchIfEmpty(Mono.fromRunnable(() -> {
                if (this.propertyTime == 0L) {
                    this.propertyTime = -1L;
                }
            }));
        }

        public Mono<DeviceDataManager.PropertyValue> getLastProperty(String key, long baseTime) {
            Function<Mono, Mono> resultHandler;
            PropertyRef ref = this.refs.computeIfAbsent(key, ignore -> new PropertyRef());
            Object val = ref.getValue();
            if (val == NULL) {
                return Mono.empty();
            }
            if (val != null) {
                if (ref.timestamp < baseTime) {
                    return Mono.just((Object)ref.copy());
                }
                if (ref.pre != null && ref.pre.timestamp < baseTime && ref.pre.value != NULL) {
                    return Mono.just((Object)ref.pre.copy());
                }
                resultHandler = prop -> prop.map(deviceProperty -> new PropertyRef().setValue(deviceProperty.getValue(), deviceProperty.getTimestamp(), deviceProperty.getState()));
            } else {
                resultHandler = prop -> prop.map(deviceProperty -> ref.setValue(deviceProperty.getValue(), deviceProperty.getTimestamp(), deviceProperty.getState())).switchIfEmpty(Mono.fromRunnable(ref::setNull));
            }
            return (Mono)((Flux)((Query)((Query)QueryParamEntity.newQuery().orderByDesc("timestamp").doPaging(0, 1).where()).lt("timestamp", (Object)baseTime)).execute(param -> this.dataService.queryProperty(this.deviceId, (QueryParamEntity)param, key))).take(1L).singleOrEmpty().as(resultHandler);
        }

        public void dispose() {
            this.disposable.dispose();
        }
    }

    private static class PropertyRef
    implements DeviceDataManager.PropertyValue {
        private volatile Object value;
        private volatile long timestamp;
        private volatile String state;
        private transient PropertyRef pre;
        private transient PropertyRef first;

        private PropertyRef() {
        }

        PropertyRef setValue(Object value, long ts, String state) {
            if (this.value == null || this.value == NULL || ts >= this.timestamp) {
                if (this.pre == null) {
                    this.pre = new PropertyRef();
                }
                this.pre.value = this.value;
                this.pre.timestamp = this.timestamp;
                this.pre.state = this.state;
                this.value = value;
                this.timestamp = ts;
                this.state = state;
            }
            return this;
        }

        void setNull() {
            if (this.value == null) {
                this.value = NULL;
            }
        }

        PropertyRef setFirst(Object value, long ts) {
            if (this.first == null) {
                this.first = new PropertyRef();
            }
            if (this.first.value == null || this.first.value == NULL || ts <= this.first.timestamp) {
                this.first.value = value;
                this.first.timestamp = ts;
            }
            return this.first;
        }

        PropertyRef setFirstNull() {
            if (this.first == null) {
                this.first = new PropertyRef();
                this.first.value = NULL;
                this.first.state = null;
            }
            return this.first;
        }

        PropertyRef copy() {
            PropertyRef ref = new PropertyRef();
            ref.state = this.state;
            ref.timestamp = this.timestamp;
            ref.value = this.value;
            return ref;
        }

        public Object getValue() {
            return this.value;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getState() {
            return this.state;
        }
    }

    public static class DefaultTagValue
    implements DeviceDataManager.TagValue {
        private String tagId;
        private Object value;

        public static DefaultTagValue of(String id, String value, PropertyMetadata metadata) {
            DefaultTagValue tagValue = new DefaultTagValue();
            tagValue.tagId = id;
            tagValue.value = metadata != null && metadata.getValueType() instanceof Converter ? ((Converter)metadata.getValueType()).convert((Object)value) : value;
            return tagValue;
        }

        public String getTagId() {
            return this.tagId;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

