/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.codec.digest.DigestUtils;
import org.hibernate.validator.constraints.Length;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import org.jetlinks.core.metadata.Converter;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;

@Table(name="dev_device_tags", indexes={@Index(name="dev_dev_id_idx", columnList="device_id"), @Index(name="dev_tag_idx", columnList="device_id,key,value")})
@EnableEntityEvent
public class DeviceTagEntity
extends GenericEntity<String> {
    @Column(length=64, nullable=false, updatable=false)
    @NotBlank(message="[deviceId]\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u8bbe\u5907ID")
    private @NotBlank(message="[deviceId]\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String deviceId;
    @Column(length=32, updatable=false, nullable=false)
    @NotBlank(message="[key]\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Schema(description="\u6807\u7b7e\u6807\u8bc6")
    private @NotBlank(message="[key]\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String key;
    @Column
    @Schema(description="\u6807\u7b7e\u540d\u79f0")
    private String name;
    @Column(length=256, nullable=false)
    @NotNull(message="[value]\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    @Length(max=256, message="[value]\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e256", groups={CreateGroup.class})
    @Schema(description="\u6807\u7b7e\u503c")
    private @NotNull(message="[value]\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) @Length(max=256, message="[value]\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e256", groups={CreateGroup.class}) String value;
    @Column(length=32, nullable=false)
    @DefaultValue(value="string")
    @Schema(description="\u7c7b\u578b", defaultValue="string")
    private String type;
    @Column(updatable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4(\u53ea\u8bfb)")
    private Date createTime;
    @Column
    @Schema(description="\u8bf4\u660e")
    private String description;

    public static DeviceTagEntity of(PropertyMetadata property) {
        DeviceTagEntity entity = new DeviceTagEntity();
        entity.setKey(property.getId());
        entity.setName(property.getName());
        entity.setType(property.getValueType().getId());
        entity.setDescription(property.getDescription());
        entity.setCreateTime(new Date());
        return entity;
    }

    public static DeviceTagEntity of(PropertyMetadata property, Object value) {
        Object newValue;
        DeviceTagEntity tag = DeviceTagEntity.of(property);
        DataType type = property.getValueType();
        if (type instanceof Converter && (newValue = ((Converter)type).convert(value)) != null) {
            value = newValue;
        }
        tag.setValue(String.valueOf(value));
        return tag;
    }

    public static String createTagId(String deviceId, String key) {
        return DigestUtils.md5Hex((String)(deviceId + ":" + key));
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @NotNull(message="[value]\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class})
    public @NotNull(message="[value]\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(@NotNull(message="[value]\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) @NotNull(message="[value]\u4e0d\u80fd\u4e3a\u7a7a", groups={CreateGroup.class}) String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

