/*
 * Decompiled with CFR 0.152.
 */
package net.zstong.awump.monitoring.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import net.zstong.awump.monitoring.entity.AwMonitoringAreaEntity;
import net.zstong.awump.monitoring.service.AwMonitoringAreaService;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.api.crud.entity.QueryNoPagingOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.exception.NotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/aw/monitoring/area"})
@Tag(name="\u76d1\u63a7\u533a\u57df\u4fe1\u606f\u7ba1\u7406")
@Resource(id="aw-base-region", name="\u76d1\u63a7\u533a\u57df\u4fe1\u606f\u7ba1\u7406")
public class AwMonitoringAreaController
implements ReactiveServiceCrudController<AwMonitoringAreaEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(AwMonitoringAreaController.class);
    private final AwMonitoringAreaService awMonitoringAreaService;

    public ReactiveCrudService<AwMonitoringAreaEntity, String> getService() {
        return this.awMonitoringAreaService;
    }

    @GetMapping
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u5168\u90e8\u533a\u57df")
    @Authorize(merge=false)
    public Flux<AwMonitoringAreaEntity> getAllCategory(@Parameter(hidden=true) QueryParamEntity query) {
        return ((ReactiveQuery)this.awMonitoringAreaService.createQuery().setParam((QueryParam)query)).fetch();
    }

    @GetMapping(value={"/_tree"})
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u5168\u90e8\u533a\u57df(\u6811\u7ed3\u6784)")
    @Authorize(merge=false)
    public Flux<AwMonitoringAreaEntity> getAllCategoryTree(@Parameter(hidden=true) QueryParamEntity query) {
        return ((ReactiveQuery)this.awMonitoringAreaService.createQuery().setParam((QueryParam)query)).fetch().collectList().flatMapMany(all -> Flux.fromIterable((Iterable)TreeSupportEntity.list2tree((Collection)all, AwMonitoringAreaEntity::setChildren)));
    }

    @PostMapping(value={"/_tree"})
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u5168\u90e8\u533a\u57df(\u6811\u7ed3\u6784)")
    @Authorize(merge=false)
    public Flux<AwMonitoringAreaEntity> getAllCategoryTreeByQueryParam(@RequestBody Mono<QueryParamEntity> query) {
        return this.awMonitoringAreaService.getAllCategoryTreeByQueryParam(query);
    }

    @PutMapping(value={"/{id}"})
    @SaveAction
    @Operation(summary="\u6839\u636eID\u4fee\u6539\u6570\u636e")
    public Mono<Boolean> update(@PathVariable String id, @RequestBody Mono<AwMonitoringAreaEntity> payload) {
        return Authentication.currentReactive().flatMap(auth -> payload.map(entity -> (AwMonitoringAreaEntity)((Object)((Object)((Object)this.applyAuthentication(entity, (Authentication)auth)))))).switchIfEmpty(payload).flatMap(entity -> this.getService().updateById((Object)id, Mono.just((Object)entity))).doOnNext(i -> {
            if (i == 0) {
                throw new NotFoundException();
            }
        }).thenReturn((Object)true);
    }

    public AwMonitoringAreaController(AwMonitoringAreaService awMonitoringAreaService) {
        this.awMonitoringAreaService = awMonitoringAreaService;
    }
}

