/*
 * Decompiled with CFR 0.152.
 */
package net.zstong.awump.device.web;

import com.alibaba.fastjson.JSON;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryNoPagingOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Resource;
import org.jetlinks.community.device.service.LocalDeviceInstanceService;
import org.jetlinks.community.rule.engine.entity.SceneEntity;
import org.jetlinks.community.rule.engine.executor.device.SelectorValue;
import org.jetlinks.community.rule.engine.service.SceneService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/aw/dev/rule"})
@Resource(id="aw-dev-rule", name="\u8bbe\u5907\u8054\u52a8\u89c4\u5219\u63a5\u53e3")
@Tag(name="\u8bbe\u5907\u8054\u52a8\u89c4\u5219\u63a5\u53e3")
public class RuleController {
    private static final Logger log = LoggerFactory.getLogger(RuleController.class);
    @Autowired
    private LocalDeviceInstanceService deviceInstanceService;
    @Autowired
    private SceneService sceneService;

    @PostMapping(value={"/scene"})
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u8bbe\u5907\u8054\u52a8\u89c4\u5219")
    public Mono<PagerResult<SceneEntity>> getDeviceInfo(@RequestBody Mono<QueryParamEntity> query) {
        System.out.println("================query===========" + JSON.toJSON(query));
        return query.flatMap(q -> {
            q.setPaging(false);
            Object deviceId = null;
            for (Term t : q.getTerms()) {
                if (!"deviceId".equals(t.getColumn())) continue;
                deviceId = t.getValue();
            }
            Object devId = deviceId;
            return this.sceneService.queryPager(q).map(p -> PagerResult.of((int)p.getTotal(), p.getData().stream().filter(e -> {
                if (e.getTrigger() != null && e.getTrigger().getDevice() != null && e.getTrigger().getDevice().getSelectorValues() != null) {
                    for (SelectorValue s : e.getTrigger().getDevice().getSelectorValues()) {
                        if (!s.getValue().equals(devId)) continue;
                        return true;
                    }
                }
                return false;
            }).collect(Collectors.toList()), (QueryParam)q));
        });
    }
}

