/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service.data;

import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.device.entity.DeviceEvent;
import org.jetlinks.community.device.entity.DeviceOperationLogEntity;
import org.jetlinks.community.device.entity.DeviceProperty;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.community.things.ThingsDataRepository;
import org.jetlinks.community.things.data.AggregationRequest;
import org.jetlinks.community.things.data.PropertyAggregation;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.core.device.DeviceThingType;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.ThingMessage;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.things.ThingMetadata;
import org.reactivestreams.Publisher;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class ThingsBridgingDeviceDataService
implements DeviceDataService {
    private final ThingsDataRepository repository;
    static final String thingType = DeviceThingType.device.getId();

    @Override
    public Mono<Void> registerMetadata(@Nonnull String productId, @Nonnull DeviceMetadata metadata) {
        return this.repository.opsForTemplate(thingType, productId).flatMap(opt -> opt.forDDL().registerMetadata((ThingMetadata)metadata));
    }

    @Override
    public Mono<Void> reloadMetadata(@Nonnull String productId, @Nonnull DeviceMetadata metadata) {
        return this.repository.opsForTemplate(thingType, productId).flatMap(opt -> opt.forDDL().reloadMetadata((ThingMetadata)metadata));
    }

    @Override
    @Nonnull
    public Mono<Void> saveDeviceMessage(@Nonnull DeviceMessage message) {
        return this.repository.opsForSave().save((ThingMessage)message);
    }

    @Override
    @Nonnull
    public Mono<Void> saveDeviceMessage(@Nonnull Publisher<DeviceMessage> message) {
        return this.repository.opsForSave().save(message);
    }

    @Override
    @Nonnull
    public Flux<DeviceProperty> queryEachOneProperties(@Nonnull String deviceId, @Nonnull QueryParamEntity query, String ... properties) {
        return this.queryEachProperties(deviceId, (QueryParamEntity)query.clone().doPaging(0, 1), properties);
    }

    @Override
    @Nonnull
    public Flux<DeviceProperty> queryEachProperties(@Nonnull String deviceId, @Nonnull QueryParamEntity query, String ... properties) {
        return this.repository.opsForThing(thingType, deviceId).flatMapMany(opt -> opt.forQuery().queryEachProperty(query, properties)).map(DeviceProperty::of);
    }

    @Override
    @Nonnull
    public Flux<DeviceProperty> queryProperty(@Nonnull String deviceId, @Nonnull QueryParamEntity query, String ... property) {
        return this.repository.opsForThing(thingType, deviceId).flatMapMany(opt -> opt.forQuery().queryProperty(query, property)).map(DeviceProperty::of);
    }

    @Nonnull
    public Flux<DeviceProperty> queryPropertyByProductId(@Nonnull String productId, @Nonnull QueryParamEntity query, String ... property) {
        return this.repository.opsForTemplate(thingType, productId).flatMapMany(opt -> opt.forQuery().queryProperty(query, property)).map(DeviceProperty::of);
    }

    @Nonnull
    public Flux<DeviceProperty> queryTopProperty(@Nonnull String deviceId, @Nonnull DeviceDataService.AggregationRequest request, int numberOfTop, String ... properties) {
        return Flux.error((Throwable)new UnsupportedOperationException("unsupported"));
    }

    @Override
    public Flux<AggregationData> aggregationPropertiesByProduct(@Nonnull String productId, @Nonnull DeviceDataService.AggregationRequest request, DeviceDataService.DevicePropertyAggregation ... properties) {
        return this.repository.opsForTemplate(thingType, productId).flatMapMany(opt -> opt.forQuery().aggregationProperties((AggregationRequest)FastBeanCopier.copy((Object)request, (Object)new AggregationRequest(), (String[])new String[0]), (PropertyAggregation[])Stream.of(properties).map(prop -> (PropertyAggregation)FastBeanCopier.copy((Object)prop, (Object)new PropertyAggregation(), (String[])new String[0])).toArray(PropertyAggregation[]::new)));
    }

    @Override
    public Flux<AggregationData> aggregationPropertiesByDevice(@Nonnull String deviceId, @Nonnull DeviceDataService.AggregationRequest request, DeviceDataService.DevicePropertyAggregation ... properties) {
        return this.repository.opsForThing(thingType, deviceId).flatMapMany(opt -> opt.forQuery().aggregationProperties((AggregationRequest)FastBeanCopier.copy((Object)request, (Object)new AggregationRequest(), (String[])new String[0]), (PropertyAggregation[])Stream.of(properties).map(prop -> (PropertyAggregation)FastBeanCopier.copy((Object)prop, (Object)new PropertyAggregation(), (String[])new String[0])).toArray(PropertyAggregation[]::new)));
    }

    @Override
    @Nonnull
    public Mono<PagerResult<DeviceProperty>> queryPropertyPage(@Nonnull String deviceId, @Nonnull String property, @Nonnull QueryParamEntity query) {
        return this.queryPropertyPage(deviceId, query, property);
    }

    @Nonnull
    public Mono<PagerResult<DeviceProperty>> queryPropertyPage(@Nonnull String deviceId, @Nonnull QueryParamEntity query, String ... property) {
        return this.repository.opsForThing(thingType, deviceId).flatMap(opt -> opt.forQuery().queryPropertyPage(query, property)).map(page -> this.convertPage((PagerResult)page, DeviceProperty::of));
    }

    private <R, T> PagerResult<R> convertPage(PagerResult<T> source, Function<T, R> mapper) {
        PagerResult newResult = (PagerResult)FastBeanCopier.copy(source, source.getClass(), (String[])new String[0]);
        newResult.setData(source.getData().stream().map(mapper).collect(Collectors.toList()));
        return newResult;
    }

    @Nonnull
    public Mono<PagerResult<DeviceProperty>> queryPropertyPageByProductId(@Nonnull String productId, @Nonnull String property, @Nonnull QueryParamEntity query) {
        return this.queryPropertyPageByProductId(property, query, property);
    }

    @Nonnull
    public Mono<PagerResult<DeviceProperty>> queryPropertyPageByProductId(@Nonnull String productId, @Nonnull QueryParamEntity query, String ... property) {
        return this.repository.opsForTemplate(thingType, productId).flatMap(opt -> opt.forQuery().queryPropertyPage(query, property)).map(page -> this.convertPage((PagerResult)page, DeviceProperty::of));
    }

    @Override
    public Mono<PagerResult<DeviceOperationLogEntity>> queryDeviceMessageLog(@Nonnull String deviceId, @Nonnull QueryParamEntity query) {
        return this.repository.opsForThing(thingType, deviceId).flatMap(opt -> opt.forQuery().queryMessageLogPage(query)).map(page -> this.convertPage((PagerResult)page, DeviceOperationLogEntity::of));
    }

    public Flux<DeviceOperationLogEntity> queryDeviceMessageLogNoPaging(@Nonnull String deviceId, @Nonnull QueryParamEntity query) {
        return this.repository.opsForThing(thingType, deviceId).flatMapMany(opt -> opt.forQuery().queryMessageLog(query)).map(DeviceOperationLogEntity::of);
    }

    public Flux<DeviceOperationLogEntity> queryDeviceMessageLogNoPagingByProduct(@Nonnull String productId, @Nonnull QueryParamEntity query) {
        return this.repository.opsForTemplate(thingType, productId).flatMapMany(opt -> opt.forQuery().queryMessageLog(query)).map(DeviceOperationLogEntity::of);
    }

    @Override
    @Nonnull
    public Flux<DeviceEvent> queryEvent(@Nonnull String deviceId, @Nonnull String event, @Nonnull QueryParamEntity query, boolean format) {
        return this.repository.opsForThing(thingType, deviceId).flatMapMany(opt -> opt.forQuery().queryEvent(event, query, format)).map(DeviceEvent::new);
    }

    @Override
    @Nonnull
    public Mono<PagerResult<DeviceEvent>> queryEventPage(@Nonnull String deviceId, @Nonnull String event, @Nonnull QueryParamEntity query, boolean format) {
        return this.repository.opsForThing(thingType, deviceId).flatMap(opt -> opt.forQuery().queryEventPage(event, query, format)).map(page -> this.convertPage((PagerResult)page, DeviceEvent::new));
    }

    @Nonnull
    public Mono<PagerResult<DeviceEvent>> queryEventPageByProductId(@Nonnull String productId, @Nonnull String event, @Nonnull QueryParamEntity query, boolean format) {
        return this.repository.opsForTemplate(thingType, productId).flatMap(opt -> opt.forQuery().queryEventPage(event, query, format)).map(page -> this.convertPage((PagerResult)page, DeviceEvent::new));
    }

    public ThingsBridgingDeviceDataService(ThingsDataRepository repository) {
        this.repository = repository;
    }
}

