/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.MapUtils;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.entity.DeviceTagEntity;
import org.jetlinks.community.device.enums.DeviceState;
import org.jetlinks.community.device.enums.DeviceType;
import org.jetlinks.community.relation.service.response.RelatedInfo;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.metadata.ConfigPropertyMetadata;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.Feature;
import org.jetlinks.core.metadata.SimpleFeature;
import org.jetlinks.supports.official.JetLinksDeviceMetadataCodec;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class DeviceDetail {
    @Schema(description="\u8bbe\u5907ID")
    private String id;
    @Schema(description="\u8bbe\u5907\u540d\u79f0")
    private String name;
    @Schema(description="\u56fe\u7247\u5730\u5740")
    private String photoUrl;
    @Schema(description="\u6d88\u606f\u534f\u8baeID")
    private String protocol;
    @Schema(description="\u6d88\u606f\u534f\u8bae\u540d\u79f0")
    private String protocolName;
    @Schema(description="\u901a\u4fe1\u534f\u8bae")
    private String transport;
    @Schema(description="\u673a\u6784ID")
    private String orgId;
    @Schema(description="\u673a\u6784\u540d\u79f0")
    private String orgName;
    @Schema(description="\u4ea7\u54c1ID")
    private String productId;
    @Schema(description="\u4ea7\u54c1\u540d\u79f0")
    private String productName;
    @Schema(description="\u8bbe\u5907\u7c7b\u578b")
    private DeviceType deviceType;
    @Schema(description="\u8bbe\u5907\u72b6\u6001")
    private DeviceState state;
    @Schema(description="ip\u5730\u5740")
    private String address;
    @Schema(description="\u4e0a\u7ebf\u65f6\u95f4")
    private long onlineTime;
    @Schema(description="\u79bb\u7ebf\u65f6\u95f4")
    private long offlineTime;
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    private long createTime;
    @Schema(description="\u6fc0\u6d3b\u65f6\u95f4")
    private long registerTime;
    @Schema(description="\u7269\u6a21\u578b")
    private String metadata;
    @Schema(description="\u662f\u5426\u4e3a\u72ec\u7acb\u7269\u6a21\u578b")
    private boolean independentMetadata;
    @Schema(description="\u914d\u7f6e\u4fe1\u606f")
    private Map<String, Object> configuration = new HashMap<String, Object>();
    @Schema(description="\u5df2\u751f\u6548\u7684\u914d\u7f6e\u4fe1\u606f")
    private Map<String, Object> cachedConfiguration = new HashMap<String, Object>();
    @Schema(description="\u662f\u5426\u4e3a\u5355\u72ec\u7684\u914d\u7f6e,false\u8868\u793a\u90e8\u5206\u914d\u7f6e\u4fe1\u606f\u7ee7\u627f\u81ea\u4ea7\u54c1.")
    private boolean aloneConfiguration;
    @Schema(description="\u7236\u8bbe\u5907ID")
    private String parentId;
    @Schema(description="\u6807\u7b7e\u4fe1\u606f")
    private List<DeviceTagEntity> tags = new ArrayList<DeviceTagEntity>();
    @Schema(description="\u8bbe\u5907\u63cf\u8ff0")
    private String description;
    @Schema(description="\u5173\u7cfb\u4fe1\u606f")
    private List<RelatedInfo> relations;
    @Schema(description="\u8bbe\u5907\u7279\u6027")
    private List<Feature> features = new ArrayList<Feature>();
    @Schema(description="\u8bbe\u5907\u63a5\u5165\u65b9\u5f0fID")
    private String accessId;
    @Schema(description="\u8bbe\u5907\u63a5\u5165\u65b9\u5f0f")
    private String accessProvider;
    @Schema(description="\u8bbe\u5907\u63a5\u5165\u65b9\u5f0f\u540d\u79f0")
    private String accessName;
    @Schema(description="\u4ea7\u54c1\u6240\u5c5e\u54c1\u7c7bID")
    private String classifiedId;
    @Schema(description="\u4ea7\u54c1\u6240\u5c5e\u54c1\u7c7b\u540d\u79f0")
    private String classifiedName;
    @Schema(description="\u6240\u5c5e\u5e93\u623f")
    private String warehouseId;
    @Schema(description="\u8bbe\u5907\u7f16\u7801")
    private String code;
    @Schema(description="\u54c1\u724c")
    private String brand;
    @Schema(description="\u8bbe\u5907\u578b\u53f7")
    private String model;
    @Schema(description="\u8d1f\u8d23\u4eba")
    private String custodian;
    @Schema(description="\u8d1f\u8d23\u4eba\u8054\u7cfb\u65b9\u5f0f")
    private String phone;
    @Schema(description="\u51fa\u5382\u65e5\u671f")
    @JsonFormat(pattern="yyyy-MM-dd")
    private LocalDate manufactureDate;
    @Schema(description="\u8bbe\u5907\u4f4d\u7f6e")
    private String location;

    public DeviceDetail notActive() {
        this.state = DeviceState.notActive;
        this.initTags();
        return this;
    }

    private DeviceMetadata decodeMetadata() {
        if (StringUtils.isEmpty((Object)this.metadata)) {
            return null;
        }
        return JetLinksDeviceMetadataCodec.getInstance().doDecode(this.metadata);
    }

    private void initTags() {
        DeviceMetadata metadata = this.decodeMetadata();
        if (null != metadata) {
            this.with(metadata.getTags().stream().map(DeviceTagEntity::of).collect(Collectors.toList()));
        }
    }

    public Mono<DeviceDetail> with(DeviceOperator operator, List<ConfigPropertyMetadata> configs) {
        return Mono.zip((Mono)operator.getAddress().defaultIfEmpty((Object)"/"), (Mono)operator.getOnlineTime().defaultIfEmpty((Object)0L), (Mono)operator.getOfflineTime().defaultIfEmpty((Object)0L), (Mono)operator.getMetadata().switchIfEmpty(Mono.fromSupplier(this::decodeMetadata)), (Mono)operator.getSelfConfigs((Collection)configs.stream().map(ConfigPropertyMetadata::getProperty).collect(Collectors.toList())).defaultIfEmpty((Object)Values.of(Collections.emptyMap()))).doOnNext(tp -> {
            this.setOnlineTime((Long)tp.getT2());
            this.setOfflineTime((Long)tp.getT3());
            this.setAddress((String)tp.getT1());
            this.with(((DeviceMetadata)tp.getT4()).getTags().stream().map(DeviceTagEntity::of).collect(Collectors.toList()));
            Map cachedConfigs = ((Values)tp.getT5()).getAllValues();
            this.cachedConfiguration.putAll(cachedConfigs);
        }).thenReturn((Object)this);
    }

    public synchronized DeviceDetail with(List<DeviceTagEntity> tags) {
        if (CollectionUtils.isEmpty(tags)) {
            return this;
        }
        Map map = Stream.concat(tags.stream(), this.tags.stream()).collect(Collectors.toMap(DeviceTagEntity::getKey, Function.identity(), (_1, _2) -> StringUtils.hasText((String)_1.getValue()) ? _1 : _2));
        this.tags = new ArrayList(map.values());
        this.tags.sort(Comparator.comparing(DeviceTagEntity::getCreateTime));
        if (StringUtils.hasText((String)this.id)) {
            for (DeviceTagEntity tag : this.getTags()) {
                tag.setId(DeviceTagEntity.createTagId(this.id, tag.getKey()));
            }
        }
        return this;
    }

    public DeviceDetail withRelation(List<RelatedInfo> relations) {
        this.relations = relations;
        return this;
    }

    public DeviceDetail with(DeviceProductEntity productEntity) {
        if (productEntity == null) {
            return this;
        }
        if (StringUtils.isEmpty((Object)this.metadata)) {
            this.setMetadata(productEntity.getMetadata());
        }
        if (CollectionUtils.isEmpty(this.configuration) && !CollectionUtils.isEmpty(productEntity.getConfiguration())) {
            this.configuration.putAll(productEntity.getConfiguration());
        }
        this.setProtocol(productEntity.getMessageProtocol());
        this.setTransport(productEntity.getTransportProtocol());
        this.setPhotoUrl(productEntity.getPhotoUrl());
        this.setProductId(productEntity.getId());
        this.setProductName(productEntity.getName());
        this.setDeviceType(productEntity.getDeviceType());
        this.setProtocolName(productEntity.getProtocolName());
        this.setAccessProvider(productEntity.getAccessProvider());
        this.setAccessId(productEntity.getAccessId());
        this.setAccessName(productEntity.getAccessName());
        this.setClassifiedId(productEntity.getClassifiedId());
        this.setClassifiedName(productEntity.getClassifiedName());
        return this;
    }

    public DeviceDetail with(DeviceInstanceEntity device) {
        this.setId(device.getId());
        this.setName(device.getName());
        this.setState(device.getState());
        this.setOrgId(device.getOrgId());
        this.setParentId(device.getParentId());
        this.setDescription(device.getDescribe());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)device.getPhotoUrl())) {
            this.setPhotoUrl(device.getPhotoUrl());
        }
        this.setWarehouseId(device.getWarehouseId());
        this.setModel(device.getModel());
        this.setCode(device.getCode());
        this.setBrand(device.getBrand());
        this.setPhone(device.getPhone());
        this.setCustodian(device.getCustodian());
        this.setManufactureDate(device.getManufactureDate());
        this.setLocation(device.getLocation());
        if (device.getFeatures() != null) {
            this.withFeatures(Arrays.asList(device.getFeatures()));
        }
        Optional.ofNullable(device.getRegistryTime()).ifPresent(this::setRegisterTime);
        Optional.ofNullable(device.getCreateTime()).ifPresent(this::setCreateTime);
        if (MapUtils.isNotEmpty(device.getConfiguration())) {
            boolean hasConfig = device.getConfiguration().keySet().stream().map(this.configuration::get).anyMatch(Objects::nonNull);
            if (hasConfig) {
                this.setAloneConfiguration(true);
            }
            this.configuration.putAll(device.getConfiguration());
        }
        if (StringUtils.hasText((String)device.getDeriveMetadata())) {
            this.setMetadata(device.getDeriveMetadata());
            this.setIndependentMetadata(true);
        }
        for (DeviceTagEntity tag : this.getTags()) {
            tag.setId(DeviceTagEntity.createTagId(this.id, tag.getKey()));
        }
        return this;
    }

    public DeviceDetail withFeatures(Collection<? extends Feature> features) {
        for (Feature feature : features) {
            this.features.add((Feature)new SimpleFeature(feature.getId(), feature.getName()));
        }
        return this;
    }

    public Mono<DeviceDetail> with(DeviceProductOperator product) {
        return Mono.zip((Mono)product.getProtocol().mapNotNull(ProtocolSupport::getName).defaultIfEmpty((Object)""), (Mono)product.getConfig((ConfigKey)DeviceConfigKey.metadata).defaultIfEmpty((Object)"")).doOnNext(tp2 -> {
            this.setProtocolName((String)tp2.getT1());
            if (!this.independentMetadata && StringUtils.hasText((String)((String)tp2.getT2()))) {
                this.setMetadata((String)tp2.getT2());
            }
        }).thenReturn((Object)this);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getTransport() {
        return this.transport;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getProductId() {
        return this.productId;
    }

    public String getProductName() {
        return this.productName;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public DeviceState getState() {
        return this.state;
    }

    public String getAddress() {
        return this.address;
    }

    public long getOnlineTime() {
        return this.onlineTime;
    }

    public long getOfflineTime() {
        return this.offlineTime;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getRegisterTime() {
        return this.registerTime;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public boolean isIndependentMetadata() {
        return this.independentMetadata;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public Map<String, Object> getCachedConfiguration() {
        return this.cachedConfiguration;
    }

    public boolean isAloneConfiguration() {
        return this.aloneConfiguration;
    }

    public String getParentId() {
        return this.parentId;
    }

    public List<DeviceTagEntity> getTags() {
        return this.tags;
    }

    public String getDescription() {
        return this.description;
    }

    public List<RelatedInfo> getRelations() {
        return this.relations;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public String getAccessId() {
        return this.accessId;
    }

    public String getAccessProvider() {
        return this.accessProvider;
    }

    public String getAccessName() {
        return this.accessName;
    }

    public String getClassifiedId() {
        return this.classifiedId;
    }

    public String getClassifiedName() {
        return this.classifiedName;
    }

    public String getWarehouseId() {
        return this.warehouseId;
    }

    public String getCode() {
        return this.code;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getModel() {
        return this.model;
    }

    public String getCustodian() {
        return this.custodian;
    }

    public String getPhone() {
        return this.phone;
    }

    public LocalDate getManufactureDate() {
        return this.manufactureDate;
    }

    public String getLocation() {
        return this.location;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPhotoUrl(String photoUrl) {
        this.photoUrl = photoUrl;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setProtocolName(String protocolName) {
        this.protocolName = protocolName;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public void setState(DeviceState state) {
        this.state = state;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setOnlineTime(long onlineTime) {
        this.onlineTime = onlineTime;
    }

    public void setOfflineTime(long offlineTime) {
        this.offlineTime = offlineTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setRegisterTime(long registerTime) {
        this.registerTime = registerTime;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    public void setIndependentMetadata(boolean independentMetadata) {
        this.independentMetadata = independentMetadata;
    }

    public void setConfiguration(Map<String, Object> configuration) {
        this.configuration = configuration;
    }

    public void setCachedConfiguration(Map<String, Object> cachedConfiguration) {
        this.cachedConfiguration = cachedConfiguration;
    }

    public void setAloneConfiguration(boolean aloneConfiguration) {
        this.aloneConfiguration = aloneConfiguration;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setTags(List<DeviceTagEntity> tags) {
        this.tags = tags;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRelations(List<RelatedInfo> relations) {
        this.relations = relations;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public void setAccessProvider(String accessProvider) {
        this.accessProvider = accessProvider;
    }

    public void setAccessName(String accessName) {
        this.accessName = accessName;
    }

    public void setClassifiedId(String classifiedId) {
        this.classifiedId = classifiedId;
    }

    public void setClassifiedName(String classifiedName) {
        this.classifiedName = classifiedName;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setCustodian(String custodian) {
        this.custodian = custodian;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @JsonFormat(pattern="yyyy-MM-dd")
    public void setManufactureDate(LocalDate manufactureDate) {
        this.manufactureDate = manufactureDate;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

