/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.events.handler;

import javax.annotation.PreDestroy;
import org.jetlinks.community.device.events.DeviceProductDeployEvent;
import org.jetlinks.community.device.service.LocalDeviceProductService;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.community.device.service.data.DeviceLatestDataService;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.DeviceMetadataCodec;
import org.jetlinks.supports.official.JetLinksDeviceMetadataCodec;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@Order(value=1)
public class DeviceProductDeployHandler
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(DeviceProductDeployHandler.class);
    private final LocalDeviceProductService productService;
    private final DeviceMetadataCodec codec = new JetLinksDeviceMetadataCodec();
    private final DeviceDataService dataService;
    private final DeviceLatestDataService latestDataService;
    private final EventBus eventBus;
    private final Disposable disposable;

    @Autowired
    public DeviceProductDeployHandler(LocalDeviceProductService productService, DeviceDataService dataService, EventBus eventBus, DeviceLatestDataService latestDataService) {
        this.productService = productService;
        this.dataService = dataService;
        this.eventBus = eventBus;
        this.latestDataService = latestDataService;
        this.disposable = eventBus.subscribe(Subscription.builder().subscriberId("product-metadata-upgrade").topics(new String[]{"/_sys/product-upgrade"}).justBroker().build(), String.class).flatMap(id -> this.reloadMetadata((String)id).onErrorResume(err -> {
            log.warn("handle product upgrade event error", err);
            return Mono.empty();
        })).subscribe();
    }

    @PreDestroy
    public void shutdown() {
        this.disposable.dispose();
    }

    @EventListener
    public void handlerEvent(DeviceProductDeployEvent event) {
        event.async((Publisher)this.doRegisterMetadata(event.getId(), event.getMetadata()).then(this.eventBus.publish("/_sys/product-upgrade", (Object)event.getId())));
    }

    protected Mono<Void> reloadMetadata(String productId) {
        return this.productService.findById(productId).flatMap(product -> this.doReloadMetadata(productId, product.getMetadata())).then();
    }

    protected Mono<Void> doReloadMetadata(String productId, String metadataString) {
        return this.codec.decode(metadataString).flatMap(metadata -> Flux.mergeDelayError((int)2, (Publisher[])new Publisher[]{this.dataService.reloadMetadata(productId, (DeviceMetadata)metadata), this.latestDataService.reloadMetadata(productId, (DeviceMetadata)metadata)}).then());
    }

    protected Mono<Void> doRegisterMetadata(String productId, String metadataString) {
        return this.codec.decode(metadataString).flatMap(metadata -> Flux.mergeDelayError((int)2, (Publisher[])new Publisher[]{this.dataService.registerMetadata(productId, (DeviceMetadata)metadata), this.latestDataService.upgradeMetadata(productId, (DeviceMetadata)metadata)}).then());
    }

    public void run(String ... args) {
        this.productService.createQuery().fetch().filter(product -> new Byte(1).equals(product.getState())).flatMap(deviceProductEntity -> this.doRegisterMetadata(deviceProductEntity.getId(), deviceProductEntity.getMetadata()).onErrorResume(err -> {
            log.warn("register product [{}] metadata error", (Object)deviceProductEntity.getId(), err);
            return Mono.empty();
        })).subscribe();
    }
}

