package net.zstong.awump.base.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import org.springframework.beans.BeanUtils;

import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import java.time.LocalDate;

/**
 * @author yuanhc
 * @date 2023-06-06
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class AwIntensiveFrameInfo extends BaseEntity<String> {


    /**
     * 所属库房
     */
    @Schema(description = "所属库房")
    private String warehouseId;

    private AwWarehouseEntity warehouse;

    /**
     * 设备编码
     */
    @Schema(description = "设备编码")
    private String code;


    /**
     * 设备名称
     */
    @Schema(description = "设备名称")
    private String name;


    /**
     * 存储类别（库、区）
     */
    @Schema(description = "存储类别（库、区）")
    private String storageType;


    /**
     * 连接地址
     */
    @Schema(description = "连接地址")
    private String linkAddress;


    /**
     * 品牌
     */
    @Schema(description = "品牌")
    @Column(name = "brand_", length = 200)
    private String brand;


    /**
     * 列
     */
    @Schema(description = "列")
    private String cols;


    /**
     * 层
     */
    @Schema(description = "层")
    private String layers;


    /**
     * 组
     */
    @Schema(description = "组")
    private String groups;


    /**
     * 负责人
     */
    @Schema(description = "负责人")
    private String custodian;


    /**
     * 负责人联系方式
     */
    @Schema(description = "负责人联系方式")
    private String phone;


    /**
     * 设备图片
     */
    @Schema(description = "设备图片")
    private String img;


    /**
     * 出厂日期
     */
    @Schema(description = "出厂日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate manufactureDate;


    public static AwIntensiveFrameInfo of(AwIntensiveFrameEntity entity) {
        AwIntensiveFrameInfo info = new AwIntensiveFrameInfo();
        BeanUtils.copyProperties(entity, info);
        return info;
    }


}