/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service.data;

import java.util.Optional;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.community.device.service.data.DeviceDataStorageProperties;
import org.jetlinks.community.device.spi.DeviceConfigMetadataSupplier;
import org.jetlinks.community.things.data.ThingsDataRepositoryStrategies;
import org.jetlinks.community.things.data.ThingsDataRepositoryStrategy;
import org.jetlinks.core.Value;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.ConfigScope;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.DeviceConfigScope;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.Feature;
import org.jetlinks.core.metadata.types.EnumType;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class StorageDeviceConfigMetadataSupplier
implements DeviceConfigMetadataSupplier {
    private final DeviceRegistry registry;
    private final DeviceDataStorageProperties properties;
    private final ConfigMetadata objectConf = new DefaultConfigMetadata("\u5b58\u50a8\u914d\u7f6e", "").scope(new ConfigScope[]{DeviceConfigScope.product}).add("storageType", "\u5b58\u50a8\u65b9\u5f0f", (DataType)new EnumType().addElement(EnumType.Element.of((String)"direct", (String)"\u76f4\u63a5\u5b58\u50a8", (String)"\u76f4\u63a5\u5b58\u50a8\u4e0a\u62a5\u7684\u6570\u636e")).addElement(EnumType.Element.of((String)"ignore", (String)"\u4e0d\u5b58\u50a8", (String)"\u4e0d\u5b58\u50a8\u6b64\u5c5e\u6027\u503c")).addElement(EnumType.Element.of((String)"json-string", (String)"JSON\u5b57\u7b26", (String)"\u5c06\u6570\u636e\u5e8f\u5217\u8bdd\u4e3aJSON\u5b57\u7b26\u4e32\u8fdb\u884c\u5b58\u50a8")));
    private final ConfigMetadata anotherConf = new DefaultConfigMetadata("\u5b58\u50a8\u914d\u7f6e", "").scope(new ConfigScope[]{DeviceConfigScope.product}).add("storageType", "\u5b58\u50a8\u65b9\u5f0f", (DataType)new EnumType().addElement(EnumType.Element.of((String)"direct", (String)"\u5b58\u50a8", (String)"\u5c06\u4e0a\u62a5\u7684\u5c5e\u6027\u503c\u4fdd\u5b58\u5230\u914d\u7f6e\u5230\u5b58\u50a8\u7b56\u7565\u4e2d")).addElement(EnumType.Element.of((String)"ignore", (String)"\u4e0d\u5b58\u50a8", (String)"\u4e0d\u5b58\u50a8\u6b64\u5c5e\u6027\u503c")));

    @Override
    public Flux<ConfigMetadata> getDeviceConfigMetadata(String deviceId) {
        return Flux.empty();
    }

    @Override
    public Flux<ConfigMetadata> getDeviceConfigMetadataByProductId(String productId) {
        return Flux.empty();
    }

    @Override
    public Flux<ConfigMetadata> getProductConfigMetadata(String productId) {
        return Flux.empty();
    }

    @Override
    public Flux<Feature> getProductFeatures(String productId) {
        return this.registry.getProduct(productId).flatMap(prod -> prod.getConfig(DeviceDataService.STORE_POLICY_CONFIG_KEY)).defaultIfEmpty((Object)this.properties.getDefaultPolicy()).flatMap(this::getStoragePolicy).flatMapMany(strategy -> strategy.opsForSave(ThingsDataRepositoryStrategy.OperationsContext.DEFAULT).getFeatures());
    }

    private Mono<ThingsDataRepositoryStrategy> getStoragePolicy(String policy) {
        return Mono.justOrEmpty((Optional)ThingsDataRepositoryStrategies.getStrategy((String)policy));
    }

    @Override
    public Flux<ConfigMetadata> getMetadataExpandsConfig(String productId, DeviceMetadataType metadataType, String metadataId, String typeId) {
        if (metadataType == DeviceMetadataType.property) {
            if ("object".equals(typeId) || "array".equals(typeId)) {
                return this.registry.getProduct(productId).flatMap(prod -> prod.getConfig("storePolicy").map(Value::asString)).defaultIfEmpty((Object)this.properties.getDefaultPolicy()).filter(policy -> policy.startsWith("default-")).map(ignore -> this.objectConf).flux();
            }
            return Flux.just((Object)this.anotherConf);
        }
        return Flux.empty();
    }

    public StorageDeviceConfigMetadataSupplier(DeviceRegistry registry, DeviceDataStorageProperties properties) {
        this.registry = registry;
        this.properties = properties;
    }
}

