/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service.data;

import com.google.common.collect.Maps;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.sql.JDBCType;
import java.sql.SQLType;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.ValueCodec;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.codec.ClobValueCodec;
import org.hswebframework.ezorm.rdb.codec.DateTimeCodec;
import org.hswebframework.ezorm.rdb.codec.JsonValueCodec;
import org.hswebframework.ezorm.rdb.codec.NumberValueCodec;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.defaults.record.Record;
import org.hswebframework.ezorm.rdb.metadata.RDBColumnMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBSchemaMetadata;
import org.hswebframework.ezorm.rdb.metadata.RDBTableMetadata;
import org.hswebframework.ezorm.rdb.metadata.TableOrViewMetadata;
import org.hswebframework.ezorm.rdb.operator.DatabaseOperator;
import org.hswebframework.ezorm.rdb.operator.ddl.TableBuilder;
import org.hswebframework.ezorm.rdb.operator.dml.SelectColumnSupplier;
import org.hswebframework.ezorm.rdb.operator.dml.query.Selects;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.exception.ValidationException;
import org.jetlinks.community.ConfigMetadataConstants;
import org.jetlinks.community.buffer.BufferProperties;
import org.jetlinks.community.buffer.BufferSettings;
import org.jetlinks.community.buffer.PersistenceBuffer;
import org.jetlinks.community.device.entity.DeviceLatestData;
import org.jetlinks.community.device.service.data.DeviceLatestDataService;
import org.jetlinks.community.gateway.DeviceMessageUtils;
import org.jetlinks.community.gateway.annotation.Subscribe;
import org.jetlinks.community.timeseries.query.Aggregation;
import org.jetlinks.community.timeseries.query.AggregationColumn;
import org.jetlinks.core.event.Subscription;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.DoubleType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.FloatType;
import org.jetlinks.core.metadata.types.GeoPoint;
import org.jetlinks.core.metadata.types.GeoType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.LongType;
import org.jetlinks.core.metadata.types.NumberType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.utils.Reactors;
import org.jetlinks.core.utils.SerializeUtils;
import org.jetlinks.core.utils.StringBuilderUtils;
import org.jetlinks.reactor.ql.utils.CastUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.math.MathFlux;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class DatabaseDeviceLatestDataService
implements DeviceLatestDataService {
    private static final Logger log = LoggerFactory.getLogger(DatabaseDeviceLatestDataService.class);
    private final DatabaseOperator databaseOperator;
    private final BufferProperties buffer;
    private PersistenceBuffer<Buffer> writer;
    static GeoCodec geoCodec = new GeoCodec();
    static StringCodec stringCodec = new StringCodec();
    static Map<Aggregation, Function<Flux<Object>, Mono<? extends Number>>> aggMappers = new HashMap<Aggregation, Function<Flux<Object>, Mono<? extends Number>>>();
    static Function<Flux<Object>, Mono<? extends Number>> avg = flux -> MathFlux.averageDouble((Publisher)flux.map(CastUtils::castNumber).map(Number::doubleValue));
    static Function<Flux<Object>, Mono<? extends Number>> max = flux -> MathFlux.max((Publisher)flux.map(CastUtils::castNumber).map(Number::doubleValue));
    static Function<Flux<Object>, Mono<? extends Number>> min = flux -> MathFlux.min((Publisher)flux.map(CastUtils::castNumber).map(Number::doubleValue));
    static Function<Flux<Object>, Mono<? extends Number>> sum = flux -> MathFlux.sumDouble((Publisher)flux.map(CastUtils::castNumber).map(Number::doubleValue));

    public DatabaseDeviceLatestDataService(DatabaseOperator databaseOperator, BufferProperties properties) {
        this.databaseOperator = databaseOperator;
        this.buffer = properties;
        this.init();
    }

    public static String getLatestTableTableName(String productId) {
        return StringBuilderUtils.buildString((Object)productId, (p, b) -> {
            b.append("dev_lst_");
            for (char c : productId.toCharArray()) {
                if (c == '-' || c == '.') {
                    b.append('_');
                    continue;
                }
                b.append(Character.toLowerCase(c));
            }
        });
    }

    private String getEventColumn(String event, String property) {
        return event + "_" + property;
    }

    private Mono<Boolean> doWrite(Flux<Buffer> flux) {
        return flux.groupBy(Buffer::getTable, Integer.MAX_VALUE).concatMap(group -> group.groupBy(Buffer::getDeviceId, Integer.MAX_VALUE).flatMap(sameDevice -> sameDevice.reduce(Buffer::merge)).buffer(200).flatMap(sameTableData -> {
            Buffer first = (Buffer)sameTableData.get(0);
            List<Map<String, Object>> data = sameTableData.stream().map(Buffer::getProperties).collect(Collectors.toList());
            return this.doUpdateLatestData(first.table, data).onErrorResume(err -> {
                log.error("save device latest data error", err);
                return Mono.empty();
            });
        })).then(Reactors.ALWAYS_FALSE);
    }

    public void init() {
        this.writer = new PersistenceBuffer(BufferSettings.create((String)"./data/buffer", (BufferProperties)this.buffer), Buffer::new, this::doWrite).name("device-latest-data").settings(setting -> setting.bufferSize(100000));
        this.writer.start();
    }

    public void destroy() {
        this.writer.dispose();
    }

    Class<?> getJavaType(DataType dataType) {
        if (null == dataType) {
            return Map.class;
        }
        switch (dataType.getType()) {
            case "int": {
                return Integer.class;
            }
            case "long": {
                return Long.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
            case "boolean": {
                return Boolean.class;
            }
            case "date": {
                return Date.class;
            }
            case "array": {
                return List.class;
            }
            case "geoPoint": 
            case "object": {
                return Map.class;
            }
        }
        return String.class;
    }

    RDBColumnMetadata convertColumn(PropertyMetadata metadata) {
        RDBColumnMetadata column = new RDBColumnMetadata();
        column.setName(metadata.getId());
        column.setComment(metadata.getName());
        DataType type = metadata.getValueType();
        if (type instanceof NumberType) {
            column.setLength(32);
            column.setPrecision(32);
            if (type instanceof DoubleType) {
                column.setScale(Optional.ofNullable(((DoubleType)type).getScale()).orElse(2).intValue());
                column.setValueCodec((ValueCodec)new NumberValueCodec(Double.class));
                column.setJdbcType((SQLType)JDBCType.NUMERIC, Double.class);
            } else if (type instanceof FloatType) {
                column.setScale(Optional.ofNullable(((FloatType)type).getScale()).orElse(2).intValue());
                column.setValueCodec((ValueCodec)new NumberValueCodec(Float.class));
                column.setJdbcType((SQLType)JDBCType.NUMERIC, Float.class);
            } else if (type instanceof LongType) {
                column.setValueCodec((ValueCodec)new NumberValueCodec(Long.class));
                column.setJdbcType((SQLType)JDBCType.NUMERIC, Long.class);
            } else {
                column.setValueCodec((ValueCodec)new NumberValueCodec(IntType.class));
                column.setJdbcType((SQLType)JDBCType.NUMERIC, Integer.class);
            }
        } else if (type instanceof ObjectType) {
            column.setJdbcType((SQLType)JDBCType.CLOB, String.class);
            column.setValueCodec((ValueCodec)JsonValueCodec.of(Map.class));
        } else if (type instanceof ArrayType) {
            column.setJdbcType((SQLType)JDBCType.CLOB, String.class);
            ArrayType arrayType = (ArrayType)type;
            column.setValueCodec((ValueCodec)JsonValueCodec.ofCollection(ArrayList.class, this.getJavaType(arrayType.getElementType())));
        } else if (type instanceof DateTimeType) {
            column.setJdbcType((SQLType)JDBCType.TIMESTAMP, Long.class);
            String format = ((DateTimeType)type).getFormat();
            if ("timestamp".equals(format)) {
                format = "yyyy-MM-dd HH:mm:ss";
            }
            column.setValueCodec((ValueCodec)new DateTimeCodec(format, Long.class));
        } else if (type instanceof GeoType) {
            column.setJdbcType((SQLType)JDBCType.VARCHAR, String.class);
            column.setValueCodec((ValueCodec)geoCodec);
            column.setLength(128);
        } else if (type instanceof EnumType) {
            column.setJdbcType((SQLType)JDBCType.VARCHAR, String.class);
            column.setValueCodec((ValueCodec)stringCodec);
            column.setLength(64);
        } else {
            int len = type.getExpand(ConfigMetadataConstants.maxLength.getKey()).filter(o -> !StringUtils.isEmpty((Object)o)).map(CastUtils::castNumber).map(Number::intValue).orElse(255);
            if (len > 2048) {
                column.setJdbcType((SQLType)JDBCType.LONGVARBINARY, String.class);
                column.setValueCodec((ValueCodec)ClobValueCodec.INSTANCE);
            } else {
                column.setJdbcType((SQLType)JDBCType.VARCHAR, String.class);
                column.setLength(len);
                column.setValueCodec((ValueCodec)stringCodec);
            }
        }
        return column;
    }

    @Override
    public Mono<Void> reloadMetadata(String productId, DeviceMetadata metadata) {
        return Mono.defer(() -> {
            String tableName = DatabaseDeviceLatestDataService.getLatestTableTableName(productId);
            log.debug("reload product[{}] metadata,table name:[{}] ", (Object)productId, (Object)tableName);
            RDBSchemaMetadata schema = (RDBSchemaMetadata)this.databaseOperator.getMetadata().getCurrentSchema();
            RDBTableMetadata table = schema.newTable(tableName);
            RDBColumnMetadata id = table.newColumn();
            id.setName("id");
            id.setLength(64);
            id.setPrimaryKey(true);
            id.setJdbcType((SQLType)JDBCType.VARCHAR, String.class);
            table.addColumn(id);
            RDBColumnMetadata deviceName = table.newColumn();
            deviceName.setLength(128);
            deviceName.setName("device_name");
            deviceName.setAlias("deviceName");
            deviceName.setJdbcType((SQLType)JDBCType.VARCHAR, String.class);
            table.addColumn(deviceName);
            for (PropertyMetadata property : metadata.getProperties()) {
                table.addColumn(this.convertColumn(property));
            }
            for (EventMetadata event : metadata.getEvents()) {
                DataType type = event.getType();
                if (!(type instanceof ObjectType)) continue;
                for (PropertyMetadata property : ((ObjectType)type).getProperties()) {
                    RDBColumnMetadata column = this.convertColumn(property);
                    column.setName(this.getEventColumn(event.getId(), property.getId()));
                    table.addColumn(column);
                }
            }
            return schema.getTableReactive(tableName, false).doOnNext(oldTable -> oldTable.replace((TableOrViewMetadata)table)).switchIfEmpty(Mono.fromRunnable(() -> schema.addTable(table))).then();
        });
    }

    @Transactional(propagation=Propagation.NEVER)
    public Mono<Void> upgradeMetadata(String productId, DeviceMetadata metadata, boolean ddl) {
        return Mono.defer(() -> {
            String tableName = DatabaseDeviceLatestDataService.getLatestTableTableName(productId);
            log.debug("upgrade product[{}] metadata,table name:[{}] ", (Object)productId, (Object)tableName);
            TableBuilder builder = this.databaseOperator.ddl().createOrAlter(tableName).addColumn("id").primaryKey().varchar(64).commit().addColumn("device_name").alias("deviceName").varchar(128).notNull().commit().merge(true).allowAlter(ddl);
            for (PropertyMetadata property : metadata.getProperties()) {
                builder.addColumn(this.convertColumn(property));
            }
            for (EventMetadata event : metadata.getEvents()) {
                DataType type = event.getType();
                if (!(type instanceof ObjectType)) continue;
                for (PropertyMetadata property : ((ObjectType)type).getProperties()) {
                    RDBColumnMetadata column = this.convertColumn(property);
                    column.setName(this.getEventColumn(event.getId(), property.getId()));
                    builder.addColumn(column);
                }
            }
            return builder.commit().reactive().subscribeOn(Schedulers.boundedElastic()).then();
        });
    }

    @Override
    public Mono<Void> upgradeMetadata(String productId, DeviceMetadata metadata) {
        return this.upgradeMetadata(productId, metadata, true);
    }

    @Override
    @Subscribe(topics={"/device/**"}, features={Subscription.Feature.local})
    public void save(DeviceMessage message) {
        try {
            Map properties = DeviceMessageUtils.tryGetProperties((DeviceMessage)message).orElseGet(() -> {
                if (message instanceof EventMessage) {
                    Object data = ((EventMessage)message).getData();
                    String event = ((EventMessage)message).getEvent();
                    if (data instanceof Map) {
                        Map mapValue = (Map)data;
                        HashMap val = Maps.newHashMapWithExpectedSize((int)mapValue.size());
                        ((Map)data).forEach((k, v) -> val.put(this.getEventColumn(event, String.valueOf(k)), v));
                        return val;
                    }
                    return Collections.singletonMap(this.getEventColumn(event, "value"), data);
                }
                return null;
            });
            if (CollectionUtils.isEmpty((Map)properties)) {
                return;
            }
            String productId = message.getHeader("productId").map(String::valueOf).orElse("null");
            String deviceName = message.getHeader("deviceName").map(String::valueOf).orElse(message.getDeviceId());
            String tableName = DatabaseDeviceLatestDataService.getLatestTableTableName(productId);
            HashMap<String, Object> prob = new HashMap<String, Object>(properties);
            prob.put("id", message.getDeviceId());
            prob.put("deviceName", deviceName);
            Buffer buffer = Buffer.of(tableName, message.getDeviceId(), deviceName, prob, message.getTimestamp());
            this.writer.write((Serializable)buffer);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Mono<Void> doUpdateLatestData(String table, List<Map<String, Object>> properties) {
        return ((RDBSchemaMetadata)this.databaseOperator.getMetadata().getCurrentSchema()).getTableReactive(table, false).flatMap(ignore -> {
            if (!ignore.getColumn("deviceName").isPresent()) {
                log.warn("\u8bbe\u5907\u6700\u65b0\u6570\u636e\u8868[{}]\u7ed3\u6784\u9519\u8bef", (Object)table);
                return Mono.empty();
            }
            return this.databaseOperator.dml().upsert(table).ignoreUpdate(new String[]{"id"}).values(properties).execute().reactive().then();
        });
    }

    public ReactiveRepository<Record, String> getRepository(String productId) {
        return this.databaseOperator.dml().createReactiveRepository(DatabaseDeviceLatestDataService.getLatestTableTableName(productId));
    }

    @Override
    public Flux<DeviceLatestData> query(String productId, QueryParamEntity param) {
        return ((ReactiveQuery)this.getRepository(productId).createQuery().setParam((QueryParam)param)).fetch().map(DeviceLatestData::new);
    }

    @Override
    public Mono<DeviceLatestData> queryDeviceData(String productId, String deviceId) {
        return this.getRepository(productId).findById((Object)deviceId).map(DeviceLatestData::new);
    }

    @Override
    public Mono<Integer> count(String productId, QueryParamEntity param) {
        return ((ReactiveQuery)this.getRepository(productId).createQuery().setParam((QueryParam)param)).count();
    }

    private SelectColumnSupplier createAggColumn(AggregationColumn column) {
        switch (column.getAggregation()) {
            case COUNT: {
                return Selects.count((String)column.getProperty()).as(column.getAlias());
            }
            case AVG: {
                return Selects.avg((String)column.getProperty()).as(column.getAlias());
            }
            case MAX: {
                return Selects.max((String)column.getProperty()).as(column.getAlias());
            }
            case MIN: {
                return Selects.min((String)column.getProperty()).as(column.getAlias());
            }
            case SUM: {
                return Selects.sum((String)column.getProperty()).as(column.getAlias());
            }
        }
        throw new UnsupportedOperationException("unsupported agg:" + column.getAggregation());
    }

    private SelectColumnSupplier[] createAggColumns(List<AggregationColumn> columns) {
        return (SelectColumnSupplier[])columns.stream().map(this::createAggColumn).toArray(SelectColumnSupplier[]::new);
    }

    @Override
    public Mono<Map<String, Object>> aggregation(String productId, List<AggregationColumn> columns, QueryParamEntity paramEntity) {
        if (CollectionUtils.isEmpty(columns)) {
            return Mono.error((Throwable)new ValidationException("columns", "error.aggregate_column_cannot_be_empty", new Object[0]));
        }
        String table = DatabaseDeviceLatestDataService.getLatestTableTableName(productId);
        return this.databaseOperator.getMetadata().getTableReactive(table).flatMap(tableMetadata -> {
            ArrayList illegals = new ArrayList();
            List<AggregationColumn> columnList = columns.stream().filter(column -> {
                if (tableMetadata.getColumn(column.getProperty()).isPresent()) {
                    return true;
                }
                illegals.add(column.getProperty());
                return false;
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(columnList)) {
                return Mono.error((Throwable)new ValidationException("columns", "error.invalid_product_attribute_or_event", new Object[]{productId, illegals}));
            }
            return this.databaseOperator.dml().query(table).select(this.createAggColumns(columnList)).setParam((QueryParam)paramEntity.clone().noPaging()).fetch(ResultWrappers.map()).reactive().take(1L).singleOrEmpty().doOnNext(map -> {
                for (AggregationColumn column : columns) {
                    map.putIfAbsent(column.getAlias(), 0);
                }
            }).onErrorReturn(e -> StringUtils.hasText((String)e.getMessage()) && e.getMessage().contains("doesn't exist "), Collections.emptyMap());
        });
    }

    @Override
    public Flux<Map<String, Object>> aggregation(Flux<DeviceLatestDataService.QueryProductLatestDataRequest> param, boolean merge) {
        Flux cached = param.cache();
        return (Flux)cached.flatMap(request -> this.aggregation(request.getProductId(), request.getColumns(), request.getQuery()).doOnNext(map -> {
            if (!merge) {
                map.put("productId", request.getProductId());
            }
        })).as(flux -> {
            if (!merge) {
                return flux;
            }
            return cached.take(1L).flatMapIterable(DeviceLatestDataService.QueryLatestDataRequest::getColumns).collectMap(AggregationColumn::getAlias, agg -> aggMappers.getOrDefault(agg.getAggregation(), sum)).flatMap(mappers -> flux.flatMapIterable(Map::entrySet).groupBy(Map.Entry::getKey, Integer.MAX_VALUE).flatMap(group -> mappers.getOrDefault(group.key(), sum).apply((Flux<Object>)group.map(Map.Entry::getValue)).map(val -> Tuples.of((Object)String.valueOf(group.key()), (Object)val))).collectMap(Tuple2::getT1, Tuple2::getT2)).flux();
        });
    }

    static {
        aggMappers.put(Aggregation.AVG, avg);
        aggMappers.put(Aggregation.MAX, max);
        aggMappers.put(Aggregation.MIN, min);
        aggMappers.put(Aggregation.SUM, sum);
        aggMappers.put(Aggregation.COUNT, sum);
    }

    private static class Buffer
    implements Externalizable {
        private static final long expires = Duration.ofSeconds(30L).toMillis();
        private String table;
        private String deviceId;
        private String deviceName;
        private Map<String, Object> properties;
        private long timestamp;

        public boolean isEffective() {
            return System.currentTimeMillis() - this.timestamp < expires;
        }

        public static Buffer of(String table, String deviceId, String deviceName, Map<String, Object> properties, long timestamp) {
            Buffer buffer = new Buffer();
            buffer.table = table;
            buffer.deviceId = deviceId;
            buffer.deviceName = deviceName;
            buffer.properties = properties;
            buffer.timestamp = timestamp;
            return buffer;
        }

        public Buffer merge(Buffer buffer) {
            if (buffer.timestamp > this.timestamp) {
                return buffer.merge(this);
            }
            buffer.properties.forEach(this.properties::putIfAbsent);
            return this;
        }

        int size() {
            return this.properties == null ? 0 : this.properties.size();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.table);
            out.writeUTF(this.deviceId);
            out.writeUTF(this.deviceName);
            out.writeLong(this.timestamp);
            SerializeUtils.writeObject(this.properties, (ObjectOutput)out);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.table = in.readUTF();
            this.deviceId = in.readUTF();
            this.deviceName = in.readUTF();
            this.timestamp = in.readLong();
            this.properties = (Map)SerializeUtils.readObject((ObjectInput)in);
        }

        public String getTable() {
            return this.table;
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }

    static class StringCodec
    implements ValueCodec<String, String> {
        StringCodec() {
        }

        public String encode(Object value) {
            return String.valueOf(value);
        }

        public String decode(Object data) {
            return String.valueOf(data);
        }
    }

    static class GeoCodec
    implements ValueCodec<String, GeoPoint> {
        GeoCodec() {
        }

        public String encode(Object value) {
            return String.valueOf(value);
        }

        public GeoPoint decode(Object data) {
            return GeoPoint.of((Object)data);
        }
    }
}

