package net.zstong.awump.device.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import org.hswebframework.ezorm.rdb.mapping.annotation.*;
import org.hswebframework.web.crud.generator.Generators;
import org.hswebframework.web.validator.CreateGroup;
import org.jetlinks.community.device.enums.DeviceFeature;
import org.jetlinks.community.device.enums.DeviceState;
import org.jetlinks.community.device.enums.DeviceType;
import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.util.*;
import org.springframework.data.relational.core.mapping.Table;


@Getter
@Setter
@Table(name = "dev_device_instance")
@Comment("设备信息表")
public class DeviceInstance {

    private String id;

    /**
     * 所属库房
     */
    @Schema(description = "所属库房")
    @Column(name = "warehouse_id_", length = 64)
    private String warehouseId;

    /**
     * 设备编码
     */
    @Schema(description = "设备编码")
    @Column(name = "code_", length = 64)
    private String code;

    /**
     * 品牌
     */
    @Schema(description = "品牌")
    @Column(name = "brand_", length = 200)
    private String brand;

    /**
     * 设备型号
     */
    @Schema(description = "设备型号")
    @Column(name = "model_", length = 200)
    private String model;

    /**
     * 负责人
     */
    @Schema(description = "负责人")
    @Column(name = "custodian_", length = 32)
    private String custodian;


    /**
     * 负责人联系方式
     */
    @Schema(description = "负责人联系方式")
    @Column(name = "phone_", length = 32)
    private String phone;

    /**
     * 设备位置
     */
    @Schema(description = "设备位置")
    @Column(name = "location_", length = 64)
    private String location;

    /**
     * 出厂日期
     */
    @Schema(description = "出厂日期")
    @Column(name = "manufacture_date_")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private LocalDate manufactureDate;


    @Column(name = "photo_url", length = 2048)
    @Schema(description = "图片地址")
    private String photoUrl;

    @Column(name = "name")
    @NotBlank(message = "设备名称不能为空", groups = CreateGroup.class)
    @Schema(description = "设备名称")
    private String name;

    @Column
    @ColumnType(javaType = String.class)
    @EnumCodec
    @Schema(description = "设备类型")
    private DeviceType deviceType;

    @Comment("说明")
    @Column(name = "describe")
    @Schema(description = "说明")
    private String describe;

    @Column(name = "product_id", length = 64)
    @NotBlank(message = "产品ID不能为空", groups = CreateGroup.class)
    @Schema(description = "产品ID")
    private String productId;

    @Column(name = "product_name")
    @NotBlank(message = "产品名称不能为空", groups = CreateGroup.class)
    @Schema(description = "产品名称")
    private String productName;

    @Column(name = "configuration")
    @ColumnType(jdbcType = JDBCType.LONGVARCHAR)
    @JsonCodec
    @Schema(description = "配置信息")
    private Map<String, Object> configuration;

    @Column(name = "derive_metadata")
    @ColumnType(jdbcType = JDBCType.LONGVARCHAR)
    @Schema(description = "派生(独立)物模型")
    private String deriveMetadata;

    @Column(name = "state", length = 16)
    @EnumCodec
    @ColumnType(javaType = String.class)
    @DefaultValue("notActive")
    @Schema(
        description = "状态(只读)"
        , accessMode = Schema.AccessMode.READ_ONLY
        , defaultValue = "notActive"
    )
    private DeviceState state;

    @Column(name = "creator_id", updatable = false)
    @Schema(
        description = "创建者ID(只读)"
        , accessMode = Schema.AccessMode.READ_ONLY
    )
    private String creatorId;

    @Column(name = "creator_name", updatable = false)
    @Schema(
        description = "创建者名称(只读)"
        , accessMode = Schema.AccessMode.READ_ONLY
    )
    private String creatorName;

    @Column(name = "create_time", updatable = false)
    @DefaultValue(generator = Generators.CURRENT_TIME)
    @Schema(
        description = "创建时间(只读)"
        , accessMode = Schema.AccessMode.READ_ONLY
    )
    private Long createTime;

    @Column(name = "registry_time")
    @Schema(description = "激活时间"
        , accessMode = Schema.AccessMode.READ_ONLY
    )
    private Long registryTime;

    @Column(name = "org_id", length = 64)
    @Schema(description = "机构ID", hidden = true)
    //已弃用,机构和设备存在多对多关系,已由资产功能统一管理
    @Deprecated
    private String orgId;

    @Column(name = "parent_id", length = 64)
    @Schema(description = "父级设备ID")
    private String parentId;

    //拓展特性,比如是否为子设备独立状态管理。
    @Column
    @ColumnType(javaType = Long.class, jdbcType = JDBCType.BIGINT)
    @EnumCodec(toMask = true)
    @Schema(description = "设备特性")
    @DefaultValue("0")
    private DeviceFeature[] features;

    @Column
    @DefaultValue(generator = Generators.CURRENT_TIME)
    @Schema(
        description = "修改时间"
        , accessMode = Schema.AccessMode.READ_ONLY
    )
    private Long modifyTime;

    @Column(length = 64)
    @Schema(
        description = "修改人ID"
        , accessMode = Schema.AccessMode.READ_ONLY
    )
    private String modifierId;

    @Column(length = 64)
    @Schema(
        description = "修改人名称"
        , accessMode = Schema.AccessMode.READ_ONLY
    )
    private String modifierName;


}
