package net.zstong.awump.base.entity;


import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.zstong.awump.dimension.InstitutionDimensionType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.simple.SimpleDimension;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;


import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

/**
 * @author yuanhc
 * @date 2023-05-25
 */
@Getter
@Setter
@Table(name = "aw_institution")
@Comment("单位信息")
@EnableEntityEvent
public class AwInstitutionEntity extends BaseEntity<String> {


    /**
     * 所属区域
     */
    @Schema(description = "所属区域")
    @Column(name = "region_id_", nullable = false, length = 64)
    @NotBlank(message = "所属区域不能为空", groups = CreateGroup.class)
    private String regionId;

    /**
     * 单位名称
     */
    @Schema(description = "单位名称")
    @Column(name = "name_", nullable = false, length = 256)
    @NotBlank(message = "单位名称不能为空", groups = CreateGroup.class)
    private String name;

    /**
     * 单位编码
     */
    @Schema(description = "单位编码")
    @Column(name = "code_", length = 64)
    private String code;

    /**
     * 单位类型
     */
    @Schema(description = "单位类型")
    @Column(name = "institution_type_", length = 32)
    private String institutionType;

    /**
     * 描述
     */
    @Schema(description = "描述")
    @Column(name = "describe_", length = 200)
    private String describe;


    public Dimension toDimension(boolean direct) {
        Map<String, Object> options = new HashMap<>();
        options.put("direct", direct);
        return SimpleDimension.of(getId(), getName(), InstitutionDimensionType.institution, options);
    }
}