/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.rdb.exception.DuplicateKeyException;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.reactor.excel.ReactorExcel;
import org.hswebframework.reactor.excel.converter.RowWrapper;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryNoPagingOperation;
import org.hswebframework.web.api.crud.entity.QueryOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.DeleteAction;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.exception.NotFoundException;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.device.entity.DeviceEvent;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.entity.DeviceOperationLogEntity;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.entity.DeviceProperty;
import org.jetlinks.community.device.entity.DeviceTagEntity;
import org.jetlinks.community.device.enums.DeviceState;
import org.jetlinks.community.device.response.DeviceDeployResult;
import org.jetlinks.community.device.response.DeviceDetail;
import org.jetlinks.community.device.response.ImportDeviceInstanceResult;
import org.jetlinks.community.device.service.DeviceConfigMetadataManager;
import org.jetlinks.community.device.service.LocalDeviceInstanceService;
import org.jetlinks.community.device.service.LocalDeviceProductService;
import org.jetlinks.community.device.service.data.DeviceDataService;
import org.jetlinks.community.device.web.excel.DeviceExcelInfo;
import org.jetlinks.community.device.web.excel.DeviceWrapper;
import org.jetlinks.community.device.web.excel.PropertyMetadataExcelInfo;
import org.jetlinks.community.device.web.excel.PropertyMetadataWrapper;
import org.jetlinks.community.device.web.request.AggRequest;
import org.jetlinks.community.io.excel.ImportExportService;
import org.jetlinks.community.io.utils.FileUtils;
import org.jetlinks.community.relation.service.RelationService;
import org.jetlinks.community.relation.service.request.SaveRelationRequest;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.community.web.response.ValidationResult;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceMessageSender;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.manager.DeviceBindHolder;
import org.jetlinks.core.device.manager.DeviceBindProvider;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.RepayableDeviceMessage;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.ConfigPropertyMetadata;
import org.jetlinks.core.metadata.ConfigScope;
import org.jetlinks.core.metadata.DeviceConfigScope;
import org.jetlinks.core.metadata.DeviceMetadata;
import org.jetlinks.core.metadata.DeviceMetadataType;
import org.jetlinks.core.metadata.SimpleDeviceMetadata;
import org.jetlinks.supports.official.JetLinksDeviceMetadataCodec;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.data.util.Lazy;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuple4;
import reactor.util.function.Tuples;

@RestController
@RequestMapping(value={"/device-instance", "/device/instance"})
@Authorize
@Resource(id="device-instance", name="\u8bbe\u5907\u5b9e\u4f8b")
@Tag(name="\u8bbe\u5907\u5b9e\u4f8b\u63a5\u53e3")
public class DeviceInstanceController
implements ReactiveServiceCrudController<DeviceInstanceEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(DeviceInstanceController.class);
    private final LocalDeviceInstanceService service;
    private final DeviceRegistry registry;
    private final LocalDeviceProductService productService;
    private final ImportExportService importExportService;
    private final ReactiveRepository<DeviceTagEntity, String> tagRepository;
    private final DeviceDataService deviceDataService;
    private final DeviceConfigMetadataManager metadataManager;
    private final RelationService relationService;
    DataBufferFactory bufferFactory = new DefaultDataBufferFactory();

    public DeviceInstanceController(LocalDeviceInstanceService service, DeviceRegistry registry, LocalDeviceProductService productService, ImportExportService importExportService, ReactiveRepository<DeviceTagEntity, String> tagRepository, DeviceDataService deviceDataService, DeviceConfigMetadataManager metadataManager, RelationService relationService) {
        this.service = service;
        this.registry = registry;
        this.productService = productService;
        this.importExportService = importExportService;
        this.tagRepository = tagRepository;
        this.deviceDataService = deviceDataService;
        this.metadataManager = metadataManager;
        this.relationService = relationService;
    }

    @GetMapping(value={"/{id:.+}/detail"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u6307\u5b9aID\u8bbe\u5907\u8be6\u60c5")
    public Mono<DeviceDetail> getDeviceDetailInfo(@PathVariable @Parameter(description="\u8bbe\u5907ID") String id) {
        return this.service.getDeviceDetail(id);
    }

    @PostMapping(value={"/{deviceId:.+}/properties/_read"})
    @QueryAction
    @Operation(summary="\u53d1\u9001\u8bfb\u53d6\u5c5e\u6027\u6307\u4ee4\u5230\u8bbe\u5907", description="\u8bf7\u6c42\u793a\u4f8b: [\"\u5c5e\u6027ID\"]")
    public Mono<?> readProperties(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @RequestBody Mono<List<String>> properties) {
        return properties.flatMap(props -> this.service.readProperties(deviceId, (List<String>)props));
    }

    @GetMapping(value={"/{id:.+}/config-metadata"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u8bbe\u5907\u9700\u8981\u7684\u914d\u7f6e\u5b9a\u4e49\u4fe1\u606f")
    public Flux<ConfigMetadata> getDeviceConfigMetadata(@PathVariable @Parameter(description="\u8bbe\u5907ID") String id) {
        return this.metadataManager.getDeviceConfigMetadata(id);
    }

    @GetMapping(value={"/{id:.+}/config-metadata/{metadataType}/{metadataId}/{typeId}"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u8bbe\u5907\u7269\u6a21\u578b\u7684\u62d3\u5c55\u914d\u7f6e\u5b9a\u4e49")
    public Flux<ConfigMetadata> getExpandsConfigMetadata(@PathVariable @Parameter(description="\u8bbe\u5907ID") String id, @PathVariable @Parameter(description="\u7269\u6a21\u578b\u7c7b\u578b") DeviceMetadataType metadataType, @PathVariable @Parameter(description="\u7269\u6a21\u578bID") String metadataId, @PathVariable @Parameter(description="\u7c7b\u578bID") String typeId) {
        return this.service.findById(id).flatMapMany(device -> this.metadataManager.getMetadataExpandsConfig(device.getProductId(), metadataType, metadataId, typeId, new ConfigScope[]{DeviceConfigScope.device}));
    }

    @GetMapping(value={"/bind-providers"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u652f\u6301\u7684\u4e91\u4e91\u5bf9\u63a5")
    public Flux<DeviceBindProvider> getBindProviders() {
        return Flux.fromIterable((Iterable)DeviceBindHolder.getAllProvider());
    }

    @GetMapping(value={"/{id:.+}/state"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u6307\u5b9aID\u8bbe\u5907\u5728\u7ebf\u72b6\u6001")
    public Mono<DeviceState> getDeviceState(@PathVariable @Parameter(description="\u8bbe\u5907ID") String id) {
        return this.service.getDeviceState(id);
    }

    @PostMapping(value={"/{deviceId:.+}/deploy"})
    @SaveAction
    @Operation(summary="\u6fc0\u6d3b\u6307\u5b9aID\u8bbe\u5907")
    public Mono<DeviceDeployResult> deviceDeploy(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId) {
        return this.service.deploy(deviceId);
    }

    @PutMapping(value={"/{deviceId:.+}/configuration/_reset"})
    @SaveAction
    @Operation(summary="\u91cd\u7f6e\u8bbe\u5907\u914d\u7f6e\u4fe1\u606f")
    public Mono<Map<String, Object>> resetConfiguration(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId) {
        return this.service.resetConfiguration(deviceId);
    }

    @GetMapping(value={"/deploy"}, produces={"text/event-stream"})
    @SaveAction
    @QueryOperation(summary="\u67e5\u8be2\u5e76\u6279\u91cf\u6fc0\u6d3b\u8bbe\u5907")
    public Flux<DeviceDeployResult> deployAll(@Parameter(hidden=true) QueryParamEntity query) {
        query.setPaging(false);
        return (Flux)this.service.query(query).as(this.service::deploy);
    }

    @PostMapping(value={"/{deviceId:.+}/undeploy"})
    @SaveAction
    @Operation(summary="\u6ce8\u9500\u6307\u5b9aID\u7684\u8bbe\u5907")
    public Mono<Integer> unDeploy(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId) {
        return this.service.unregisterDevice(deviceId);
    }

    @PostMapping(value={"/{deviceId:.+}/disconnect"})
    @SaveAction
    @Operation(summary="\u65ad\u5f00\u6307\u5b9aID\u7684\u8bbe\u5907\u8fde\u63a5")
    public Mono<Boolean> disconnect(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId) {
        return this.registry.getDevice(deviceId).flatMapMany(DeviceOperator::disconnect).singleOrEmpty();
    }

    @PostMapping
    @Operation(summary="\u65b0\u5efa\u8bbe\u5907")
    public Mono<DeviceInstanceEntity> add(@RequestBody Mono<DeviceInstanceEntity> payload) {
        return Mono.zip(payload, (Mono)Authentication.currentReactive(), (arg_0, arg_1) -> ((DeviceInstanceController)this).applyAuthentication(arg_0, arg_1)).flatMap(entity -> this.service.insert((Publisher<DeviceInstanceEntity>)Mono.just((Object)entity)).thenReturn((Object)entity)).onErrorMap(DuplicateKeyException.class, err -> new BusinessException("\u8bbe\u5907ID\u5df2\u5b58\u5728", (Throwable)err));
    }

    @GetMapping(value={"/state/_sync"}, produces={"text/event-stream"})
    @SaveAction
    @QueryNoPagingOperation(summary="\u540c\u6b65\u8bbe\u5907\u72b6\u6001")
    public Flux<Integer> syncDeviceState(@Parameter(hidden=true) QueryParamEntity query) {
        query.setPaging(false);
        return this.service.query((QueryParamEntity)query.includes(new String[]{"id"})).map(DeviceInstanceEntity::getId).buffer(200).publishOn(Schedulers.single()).concatMap(flux -> this.service.syncStateBatch((Flux<List<String>>)Flux.just((Object)flux), true).map(List::size)).defaultIfEmpty((Object)0);
    }

    @GetMapping(value={"/{deviceId:.+}/properties/latest"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u6307\u5b9aID\u8bbe\u5907\u6700\u65b0\u7684\u5168\u90e8\u5c5e\u6027")
    public Flux<DeviceProperty> getDeviceLatestProperties(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId) {
        return this.deviceDataService.queryEachOneProperties(deviceId, QueryParamEntity.of(), new String[0]);
    }

    @GetMapping(value={"/{deviceId:.+}/properties"})
    @QueryAction
    @QueryNoPagingOperation(summary="\u6309\u6761\u4ef6\u67e5\u8be2\u6307\u5b9aID\u8bbe\u5907\u7684\u5168\u90e8\u5c5e\u6027")
    public Flux<DeviceProperty> getDeviceLatestProperties(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @Parameter(hidden=true) QueryParamEntity queryParamEntity) {
        return this.deviceDataService.queryEachProperties(deviceId, queryParamEntity, new String[0]);
    }

    @GetMapping(value={"/{deviceId:.+}/property/{property:.+}"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u6307\u5b9aID\u8bbe\u5907\u6700\u65b0\u7684\u5c5e\u6027")
    public Mono<DeviceProperty> getDeviceLatestProperty(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @PathVariable @Parameter(description="\u5c5e\u6027ID") String property) {
        return this.deviceDataService.queryEachOneProperties(deviceId, QueryParamEntity.of(), property).take(1L).singleOrEmpty();
    }

    @PostMapping(value={"/{deviceId:.+}/property/{property}/_query"})
    @QueryAction
    @QueryOperation(summary="\u67e5\u8be2\u8bbe\u5907\u6307\u5b9a\u5c5e\u6027\u5217\u8868")
    public Mono<PagerResult<DeviceProperty>> queryDeviceProperties(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @PathVariable @Parameter(description="\u5c5e\u6027ID") String property, @Parameter(hidden=true) QueryParamEntity entity) {
        return this.deviceDataService.queryPropertyPage(deviceId, property, entity);
    }

    @GetMapping(value={"/{deviceId:.+}/properties/_query"})
    @QueryAction
    @QueryOperation(summary="\u67e5\u8be2\u8bbe\u5907\u6307\u5b9a\u5c5e\u6027\u5217\u8868(\u5df2\u5f03\u7528)")
    @Deprecated
    public Mono<PagerResult<DeviceProperty>> queryDeviceProperties(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @Parameter(hidden=true) QueryParamEntity entity) {
        return entity.getTerms().stream().filter(term -> "property".equals(term.getColumn())).findFirst().map(term -> {
            String val = String.valueOf(term.getValue());
            term.setValue(null);
            return val;
        }).map(property -> this.deviceDataService.queryPropertyPage(deviceId, (String)property, entity)).orElseThrow(() -> new ValidationException("\u8bf7\u8bbe\u7f6e[property]\u53c2\u6570"));
    }

    @GetMapping(value={"/{deviceId:.+}/event/{eventId}"})
    @QueryAction
    @QueryOperation(summary="(GET)\u67e5\u8be2\u8bbe\u5907\u4e8b\u4ef6\u6570\u636e")
    public Mono<PagerResult<DeviceEvent>> queryPagerByDeviceEvent(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @PathVariable @Parameter(description="\u4e8b\u4ef6ID") String eventId, @Parameter(hidden=true) QueryParamEntity queryParam, @RequestParam(defaultValue="false") @Parameter(description="\u662f\u5426\u683c\u5f0f\u5316\u8fd4\u56de\u7ed3\u679c,\u683c\u5f0f\u5316\u5bf9\u5b57\u6bb5\u6dfb\u52a0_format\u540e\u7f00") boolean format) {
        return this.deviceDataService.queryEventPage(deviceId, eventId, queryParam, format);
    }

    @PostMapping(value={"/{deviceId:.+}/event/{eventId}"})
    @QueryAction
    @Operation(summary="(POST)\u67e5\u8be2\u8bbe\u5907\u4e8b\u4ef6\u6570\u636e")
    public Mono<PagerResult<DeviceEvent>> queryPagerByDeviceEvent(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @PathVariable @Parameter(description="\u4e8b\u4ef6ID") String eventId, @RequestBody Mono<QueryParamEntity> queryParam, @RequestParam(defaultValue="false") @Parameter(description="\u662f\u5426\u683c\u5f0f\u5316\u8fd4\u56de\u7ed3\u679c,\u683c\u5f0f\u5316\u5bf9\u5b57\u6bb5\u6dfb\u52a0_format\u540e\u7f00") boolean format) {
        return queryParam.flatMap(q -> this.deviceDataService.queryEventPage(deviceId, eventId, (QueryParamEntity)q, format));
    }

    @GetMapping(value={"/{deviceId:.+}/logs"})
    @QueryAction
    @QueryOperation(summary="(GET)\u67e5\u8be2\u8bbe\u5907\u65e5\u5fd7\u6570\u636e")
    public Mono<PagerResult<DeviceOperationLogEntity>> queryDeviceLog(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @Parameter(hidden=true) QueryParamEntity entity) {
        return this.deviceDataService.queryDeviceMessageLog(deviceId, entity);
    }

    @PostMapping(value={"/{deviceId:.+}/logs"})
    @QueryAction
    @Operation(summary="(POST)\u67e5\u8be2\u8bbe\u5907\u65e5\u5fd7\u6570\u636e")
    public Mono<PagerResult<DeviceOperationLogEntity>> queryDeviceLog(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @RequestBody @Parameter(hidden=true) Mono<QueryParamEntity> queryParam) {
        return queryParam.flatMap(param -> this.deviceDataService.queryDeviceMessageLog(deviceId, (QueryParamEntity)param));
    }

    @DeleteMapping(value={"/{deviceId}/tag/{tagId:.+}"})
    @SaveAction
    @Operation(summary="\u5220\u9664\u8bbe\u5907\u6807\u7b7e")
    public Mono<Void> deleteDeviceTag(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @PathVariable @Parameter(description="\u6807\u7b7eID") String tagId) {
        return ((ReactiveDelete)((ReactiveDelete)this.tagRepository.createDelete().where(DeviceTagEntity::getDeviceId, (Object)deviceId)).and(GenericEntity::getId, (Object)tagId)).execute().then();
    }

    @PutMapping(value={"/batch/_delete"})
    @DeleteAction
    @Operation(summary="\u6279\u91cf\u5220\u9664\u8bbe\u5907")
    public Mono<Integer> deleteBatch(@RequestBody Mono<List<String>> idList) {
        return (Mono)idList.flatMapMany(Flux::fromIterable).as(this.service::deleteById);
    }

    @PutMapping(value={"/batch/_unDeploy"})
    @SaveAction
    @Operation(summary="\u6279\u91cf\u6ce8\u9500\u8bbe\u5907")
    public Mono<Integer> unDeployBatch(@RequestBody Mono<List<String>> idList) {
        return idList.flatMap(list -> this.service.unregisterDevice((Publisher<String>)Flux.fromIterable((Iterable)list)));
    }

    @PutMapping(value={"/batch/_deploy"})
    @SaveAction
    @Operation(summary="\u6279\u91cf\u6fc0\u6d3b\u8bbe\u5907")
    public Mono<Integer> deployBatch(@RequestBody Mono<List<String>> idList) {
        return ((Flux)idList.flatMapMany(arg_0 -> ((LocalDeviceInstanceService)this.service).findById(arg_0)).as(this.service::deploy)).map(DeviceDeployResult::getTotal).reduce(Math::addExact);
    }

    @GetMapping(value={"/{deviceId}/tags"})
    @SaveAction
    @Operation(summary="\u83b7\u53d6\u8bbe\u5907\u5168\u90e8\u6807\u7b7e\u6570\u636e")
    public Flux<DeviceTagEntity> getDeviceTags(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId) {
        return ((ReactiveQuery)this.tagRepository.createQuery().where(DeviceTagEntity::getDeviceId, (Object)deviceId)).fetch();
    }

    @PatchMapping(value={"/{deviceId}/tag"})
    @SaveAction
    @Operation(summary="\u4fdd\u5b58\u8bbe\u5907\u6807\u7b7e")
    public Flux<DeviceTagEntity> saveDeviceTag(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @RequestBody Flux<DeviceTagEntity> tags) {
        return ((Mono)tags.doOnNext(tag -> {
            tag.setId(DeviceTagEntity.createTagId(deviceId, tag.getKey()));
            tag.setDeviceId(deviceId);
            tag.tryValidate(new Class[0]);
        }).as(arg_0 -> this.tagRepository.save(arg_0))).thenMany(this.getDeviceTags(deviceId));
    }

    private Mono<Tuple4<DeviceProductEntity, DeviceProductOperator, DeviceMetadata, List<ConfigPropertyMetadata>>> getDeviceProductDetail(String productId) {
        return Mono.zip((Mono)this.productService.findById(productId), (Mono)this.registry.getProduct(productId), (Mono)this.registry.getProduct(productId).flatMap(DeviceProductOperator::getMetadata), (Mono)this.metadataManager.getDeviceConfigMetadataByProductId(productId).flatMapIterable(ConfigMetadata::getProperties).collectList().defaultIfEmpty(Collections.emptyList()));
    }

    @GetMapping(value={"/{productId}/import"}, produces={"text/event-stream"})
    @SaveAction
    @Operation(summary="\u5bfc\u5165\u8bbe\u5907\u6570\u636e")
    public Flux<ImportDeviceInstanceResult> doBatchImportByProduct(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String productId, @RequestParam(required=false) @Parameter(description="\u6587\u4ef6\u5730\u5740,\u652f\u6301csv,xlsx\u6587\u4ef6\u683c\u5f0f") String fileUrl, @RequestParam(required=false) @Parameter(description="\u6587\u4ef6Id") String fileId) {
        return Authentication.currentReactive().flatMapMany(auth -> {
            Map<String, String> orgMapping = auth.getDimensions("org").stream().collect(Collectors.toMap(Dimension::getName, Dimension::getId, (_1, _2) -> _1));
            return this.getDeviceProductDetail(productId).map(tp4 -> Tuples.of((Object)((Object)new DeviceWrapper(((DeviceMetadata)tp4.getT3()).getTags(), (List)tp4.getT4())), (Object)tp4.getT1())).flatMapMany(wrapper -> this.importExportService.readData(fileUrl, fileId, (RowWrapper)wrapper.getT1()).doOnNext(info -> info.setProductName(((DeviceProductEntity)((Object)((Object)((Object)((Object)wrapper.getT2()))))).getName()))).map(info -> {
                DeviceInstanceEntity entity = (DeviceInstanceEntity)((Object)((Object)((Object)FastBeanCopier.copy((Object)info, (Object)((Object)new DeviceInstanceEntity()), (String[])new String[0]))));
                entity.setProductId(productId);
                entity.setOrgId((String)orgMapping.get(info.getOrgName()));
                if (StringUtils.isEmpty((Object)entity.getId())) {
                    throw new BusinessException("\u7b2c" + (info.getRowNumber() + 1L) + "\u884c:\u8bbe\u5907ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                return Tuples.of((Object)((Object)entity), info.getTags());
            }).buffer(100).publishOn(Schedulers.single()).concatMap(buffer -> Mono.zip(this.service.save((Publisher<DeviceInstanceEntity>)Flux.fromIterable((Iterable)buffer).map(Tuple2::getT1)), (Mono)this.tagRepository.save((Publisher)Flux.fromIterable((Iterable)buffer).flatMapIterable(Tuple2::getT2)).defaultIfEmpty((Object)SaveResult.of((int)0, (int)0)))).map(res -> ImportDeviceInstanceResult.success((SaveResult)res.getT1())).onErrorResume(err -> Mono.just((Object)ImportDeviceInstanceResult.error(err)));
        });
    }

    @GetMapping(value={"/{productId}/template.{format}"})
    @QueryAction
    @Operation(summary="\u4e0b\u8f7d\u8bbe\u5907\u5bfc\u5165\u6a21\u7248")
    public Mono<Void> downloadExportTemplate(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String productId, ServerHttpResponse response, @PathVariable @Parameter(description="\u6587\u4ef6\u683c\u5f0f,\u652f\u6301csv,xlsx") String format) throws IOException {
        response.getHeaders().set("Content-Disposition", "attachment; filename=".concat(URLEncoder.encode("\u8bbe\u5907\u5bfc\u5165\u6a21\u7248." + format, StandardCharsets.UTF_8.displayName())));
        return (Mono)this.getDeviceProductDetail(productId).map(tp4 -> DeviceExcelInfo.getTemplateHeaderMapping(((DeviceMetadata)tp4.getT3()).getTags(), (List)tp4.getT4())).defaultIfEmpty(DeviceExcelInfo.getTemplateHeaderMapping(Collections.emptyList(), Collections.emptyList())).flatMapMany(headers -> ReactorExcel.writer((String)format).headers((Collection)headers).converter(DeviceExcelInfo::toMap).writeBuffer(Flux.empty())).doOnError(err -> log.error(err.getMessage(), err)).map(arg_0 -> ((DataBufferFactory)this.bufferFactory).wrap(arg_0)).as(arg_0 -> ((ServerHttpResponse)response).writeWith(arg_0));
    }

    @GetMapping(value={"/{productId}/export.{format}"})
    @QueryAction
    @QueryNoPagingOperation(summary="\u6309\u4ea7\u54c1\u5bfc\u51fa\u8bbe\u5907\u5b9e\u4f8b\u6570\u636e")
    public Mono<Void> export(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String productId, ServerHttpResponse response, @Parameter(hidden=true) QueryParamEntity parameter, @PathVariable @Parameter(description="\u6587\u4ef6\u683c\u5f0f,\u652f\u6301csv,xlsx") String format) throws IOException {
        response.getHeaders().set("Content-Disposition", "attachment; filename=".concat(URLEncoder.encode("\u8bbe\u5907\u5b9e\u4f8b." + format, StandardCharsets.UTF_8.displayName())));
        parameter.setPaging(false);
        parameter.toNestQuery(q -> {
            Query cfr_ignored_0 = (Query)q.is(DeviceInstanceEntity::getProductId, (Object)productId);
        });
        return Authentication.currentReactive().flatMap(auth -> {
            Map<String, String> orgMapping = auth.getDimensions("org").stream().collect(Collectors.toMap(Dimension::getId, Dimension::getName, (_1, _2) -> _1));
            return (Mono)this.getDeviceProductDetail(productId).map(tp4 -> Tuples.of(DeviceExcelInfo.getExportHeaderMapping(((DeviceMetadata)tp4.getT3()).getTags(), (List)tp4.getT4()), ((List)tp4.getT4()).stream().map(ConfigPropertyMetadata::getProperty).collect(Collectors.toList()))).defaultIfEmpty((Object)Tuples.of(DeviceExcelInfo.getExportHeaderMapping(Collections.emptyList(), Collections.emptyList()), Collections.emptyList())).flatMapMany(headerAndConfigKey -> ReactorExcel.writer((String)format).headers((Collection)headerAndConfigKey.getT1()).converter(DeviceExcelInfo::toMap).writeBuffer(this.service.query(parameter).flatMap(entity -> {
                DeviceExcelInfo exportEntity = (DeviceExcelInfo)FastBeanCopier.copy((Object)entity, (Object)new DeviceExcelInfo(), (String[])new String[]{"state"});
                exportEntity.setOrgName((String)orgMapping.get(entity.getOrgId()));
                exportEntity.setState(entity.getState().getText());
                return this.registry.getDevice(entity.getId()).flatMap(deviceOperator -> deviceOperator.getSelfConfigs((Collection)headerAndConfigKey.getT2()).map(Values::getAllValues)).doOnNext(configs -> exportEntity.getConfiguration().putAll((Map<String, Object>)configs)).thenReturn((Object)exportEntity);
            }).buffer(200).flatMap(list -> {
                Map importInfo = list.stream().collect(Collectors.toMap(DeviceExcelInfo::getId, Function.identity()));
                return ((ReactiveQuery)((ReactiveQuery)this.tagRepository.createQuery().where()).in(DeviceTagEntity::getDeviceId, importInfo.keySet())).fetch().collect(Collectors.groupingBy(DeviceTagEntity::getDeviceId)).flatMapIterable(Map::entrySet).doOnNext(entry -> ((DeviceExcelInfo)importInfo.get(entry.getKey())).setTags((List)entry.getValue())).thenMany((Publisher)Flux.fromIterable((Iterable)list));
            }), 524288)).doOnError(err -> log.error(err.getMessage(), err)).map(arg_0 -> ((DataBufferFactory)this.bufferFactory).wrap(arg_0)).as(arg_0 -> ((ServerHttpResponse)response).writeWith(arg_0));
        });
    }

    @GetMapping(value={"/export.{format}"})
    @QueryAction
    @QueryNoPagingOperation(summary="\u5bfc\u51fa\u8bbe\u5907\u5b9e\u4f8b\u6570\u636e", description="\u6b64\u64cd\u4f5c\u4e0d\u652f\u6301\u5bfc\u51fa\u8bbe\u5907\u6807\u7b7e\u548c\u914d\u7f6e\u4fe1\u606f")
    public Mono<Void> export(ServerHttpResponse response, @Parameter(hidden=true) QueryParamEntity parameter, @PathVariable @Parameter(description="\u6587\u4ef6\u683c\u5f0f,\u652f\u6301csv,xlsx") String format) throws IOException {
        response.getHeaders().set("Content-Disposition", "attachment; filename=".concat(URLEncoder.encode("\u8bbe\u5907\u5b9e\u4f8b." + format, StandardCharsets.UTF_8.displayName())));
        return (Mono)ReactorExcel.writer((String)format).headers(DeviceExcelInfo.getExportHeaderMapping(Collections.emptyList(), Collections.emptyList())).converter(DeviceExcelInfo::toMap).writeBuffer(this.service.query(parameter).map(entity -> {
            DeviceExcelInfo exportEntity = (DeviceExcelInfo)FastBeanCopier.copy((Object)entity, (Object)new DeviceExcelInfo(), (String[])new String[]{"state"});
            exportEntity.setState(entity.getState().getText());
            return exportEntity;
        }), 524288).doOnError(err -> log.error(err.getMessage(), err)).map(arg_0 -> ((DataBufferFactory)this.bufferFactory).wrap(arg_0)).as(arg_0 -> ((ServerHttpResponse)response).writeWith(arg_0));
    }

    @PutMapping(value={"/{deviceId:.+}/shadow"})
    @SaveAction
    @Operation(summary="\u8bbe\u7f6e\u8bbe\u5907\u5f71\u5b50")
    public Mono<String> setDeviceShadow(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @RequestBody Mono<String> shadow) {
        return Mono.zip((Mono)this.registry.getDevice(deviceId), shadow).flatMap(tp2 -> ((DeviceOperator)tp2.getT1()).setConfig((ConfigKey)DeviceConfigKey.shadow, tp2.getT2()).thenReturn(tp2.getT2()));
    }

    @GetMapping(value={"/{deviceId:.+}/shadow"})
    @SaveAction
    @Operation(summary="\u83b7\u53d6\u8bbe\u5907\u5f71\u5b50")
    public Mono<String> getDeviceShadow(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId) {
        return this.registry.getDevice(deviceId).flatMap(operator -> operator.getSelfConfig((ConfigKey)DeviceConfigKey.shadow)).defaultIfEmpty((Object)"{\n}");
    }

    @PutMapping(value={"/{deviceId:.+}/property"})
    @QueryAction
    @Operation(summary="\u53d1\u9001\u8bbe\u7f6e\u5c5e\u6027\u6307\u4ee4\u5230\u8bbe\u5907", description="\u8bf7\u6c42\u793a\u4f8b: {\"\u5c5e\u6027ID\":\"\u503c\"}")
    public Flux<?> writeProperties(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @RequestBody Mono<Map<String, Object>> properties) {
        return properties.flatMapMany(props -> this.service.writeProperties(deviceId, (Map<String, Object>)props));
    }

    @PostMapping(value={"/{deviceId:.+}/function/{functionId}"})
    @QueryAction
    @Operation(summary="\u53d1\u9001\u8c03\u7528\u8bbe\u5907\u529f\u80fd\u6307\u4ee4\u5230\u8bbe\u5907", description="\u8bf7\u6c42\u793a\u4f8b: {\"\u53c2\u6570\":\"\u503c\"}")
    public Flux<?> invokedFunction(@PathVariable String deviceId, @PathVariable String functionId, @RequestBody Mono<Map<String, Object>> properties) {
        return properties.flatMapMany(props -> this.service.invokeFunction(deviceId, functionId, (Map<String, Object>)props));
    }

    @PostMapping(value={"/{deviceId:.+}/agg/_query"})
    @QueryAction
    @Operation(summary="\u805a\u5408\u67e5\u8be2\u8bbe\u5907\u5c5e\u6027")
    public Flux<Map<String, Object>> aggDeviceProperty(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @RequestBody Mono<AggRequest> param) {
        return param.flatMapMany(request -> this.deviceDataService.aggregationPropertiesByDevice(deviceId, request.getQuery(), request.getColumns().toArray(new DeviceDataService.DevicePropertyAggregation[0]))).map(AggregationData::values);
    }

    @PostMapping(value={"/{deviceId:.+}/message"})
    @QueryAction
    @Operation(summary="\u53d1\u9001\u6307\u4ee4\u5230\u8bbe\u5907")
    public Flux<?> sendMessage(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, @RequestBody Mono<Map<String, Object>> properties) {
        return properties.flatMapMany(props -> Mono.zip((Mono)this.registry.getDevice(deviceId).map(DeviceOperator::messageSender).switchIfEmpty(Mono.error(() -> new NotFoundException("\u8bbe\u5907\u4e0d\u5b58\u5728\u6216\u672a\u6fc0\u6d3b", new Object[0]))), (Mono)Mono.justOrEmpty((Optional)MessageType.convertMessage((Map)props)).cast(DeviceMessage.class).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u683c\u5f0f")))).flatMapMany(tp2 -> {
            DeviceMessageSender sender = (DeviceMessageSender)tp2.getT1();
            DeviceMessage message = (DeviceMessage)tp2.getT2();
            HashMap<String, Object> copy = new HashMap<String, Object>();
            copy.put("deviceId", deviceId);
            if (!StringUtils.hasText((String)message.getMessageId())) {
                copy.put("messageId", IDGenerator.SNOW_FLAKE_STRING.generate());
            }
            FastBeanCopier.copy(copy, (Object)message, (String[])new String[0]);
            return sender.send(message).onErrorResume(DeviceOperationException.class, error -> {
                if (message instanceof RepayableDeviceMessage) {
                    return Mono.just((Object)((RepayableDeviceMessage)message).newReply().error((Throwable)error));
                }
                return Mono.error((Throwable)error);
            });
        }));
    }

    @PostMapping(value={"/messages"})
    @QueryAction
    @Operation(summary="\u6279\u91cf\u53d1\u9001\u6307\u4ee4\u5230\u8bbe\u5907")
    public Flux<?> sendMessage(@RequestParam(required=false) @Parameter(description="\u6309\u67e5\u8be2\u6761\u4ef6\u53d1\u9001\u6307\u4ee4") String where, @RequestBody Flux<Map<String, Object>> messages) {
        Lazy operators = Lazy.of(() -> {
            if (StringUtils.isEmpty((Object)where)) {
                throw new ValidationException("where", "[where]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", new Object[0]);
            }
            QueryParamEntity entity = new QueryParamEntity();
            entity.setWhere(where);
            entity.includes(new String[]{"id"});
            return this.service.query(entity).flatMap(device -> this.registry.getDevice(device.getId())).cache();
        });
        return messages.flatMap(message -> {
            DeviceMessage msg = MessageType.convertMessage((Map)message).filter(DeviceMessage.class::isInstance).map(DeviceMessage.class::cast).orElseThrow(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u683c\u5f0f:" + message));
            String deviceId = msg.getDeviceId();
            Flux devices = StringUtils.isEmpty((Object)deviceId) ? (Flux)operators.get() : this.registry.getDevice(deviceId).flux();
            return devices.flatMap(device -> {
                HashMap<String, Object> copy = new HashMap<String, Object>((Map<String, Object>)message);
                copy.put("deviceId", device.getDeviceId());
                copy.putIfAbsent("messageId", IDGenerator.SNOW_FLAKE_STRING.generate());
                DeviceMessage copiedMessage = MessageType.convertMessage(copy).map(DeviceMessage.class::cast).orElseThrow(() -> new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u683c\u5f0f"));
                return device.messageSender().send(copiedMessage).onErrorResume(Exception.class, error -> {
                    if (copiedMessage instanceof RepayableDeviceMessage) {
                        return Mono.just((Object)((RepayableDeviceMessage)copiedMessage).newReply().error((Throwable)error));
                    }
                    return Mono.error((Throwable)error);
                });
            });
        });
    }

    @PutMapping(value={"/{id}/metadata"})
    @SaveAction
    @Operation(summary="\u66f4\u65b0\u7269\u6a21\u578b")
    public Mono<Void> updateMetadata(@PathVariable String id, @RequestBody Mono<String> metadata) {
        return metadata.flatMap(metadata_ -> ((ReactiveUpdate)((ReactiveUpdate)this.service.createUpdate().set(DeviceInstanceEntity::getDeriveMetadata, metadata_)).where(DeviceInstanceEntity::getId, (Object)id)).execute().then(this.registry.getDevice(id)).flatMap(device -> device.updateMetadata(metadata_))).then();
    }

    @DeleteMapping(value={"/{id}/metadata"})
    @SaveAction
    @Operation(summary="\u91cd\u7f6e\u7269\u6a21\u578b")
    public Mono<Void> resetMetadata(@PathVariable String id) {
        return this.registry.getDevice(id).flatMap(DeviceOperator::resetMetadata).then(((ReactiveUpdate)((ReactiveUpdate)this.service.createUpdate().setNull(DeviceInstanceEntity::getDeriveMetadata)).where(DeviceInstanceEntity::getId, (Object)id)).execute().then());
    }

    @PutMapping(value={"/{id}/metadata/merge-product"})
    @SaveAction
    @Operation(summary="\u5408\u5e76\u4ea7\u54c1\u7684\u7269\u6a21\u578b")
    public Mono<Void> mergeProductMetadata(@PathVariable String id) {
        return this.service.findById(id).filter(deviceInstance -> StringUtils.hasText((String)deviceInstance.getDeriveMetadata())).flatMap(deviceInstance -> this.productService.findById(deviceInstance.getProductId()).flatMap(product -> deviceInstance.mergeMetadata(product.getMetadata())).then(Mono.defer(() -> ((ReactiveUpdate)((ReactiveUpdate)this.service.createUpdate().set(deviceInstance::getDeriveMetadata)).where(deviceInstance::getId)).execute().then(this.registry.getDevice(deviceInstance.getId())).flatMap(device -> device.updateMetadata(deviceInstance.getDeriveMetadata())).then())));
    }

    @GetMapping(value={"/{id:.+}/exists"})
    @QueryAction
    @Operation(summary="\u9a8c\u8bc1\u8bbe\u5907ID\u662f\u5426\u5b58\u5728")
    public Mono<Boolean> deviceIdValidate(@PathVariable @Parameter(description="\u8bbe\u5907ID") String id) {
        return this.service.findById(id).hasElement();
    }

    @GetMapping(value={"/id/_validate"})
    @QueryAction
    @Operation(summary="\u9a8c\u8bc1\u8bbe\u5907ID\u662f\u5426\u5408\u6cd5")
    public Mono<ValidationResult> deviceIdValidate2(@RequestParam @Parameter(description="\u8bbe\u5907ID") String id) {
        return LocaleUtils.currentReactive().flatMap(locale -> {
            DeviceInstanceEntity entity = new DeviceInstanceEntity();
            entity.setId(id);
            entity.validateId();
            return this.service.findById(id).map(device -> ValidationResult.error((String)LocaleUtils.resolveMessage((String)"error.device_ID_already_exists", (Object[])new Object[]{locale}))).defaultIfEmpty((Object)ValidationResult.success());
        }).onErrorResume(ValidationException.class, e -> Mono.just((Object)e.getI18nCode()).map(ValidationResult::error));
    }

    @PostMapping(value={"/{productId}/property-metadata/import"})
    @SaveAction
    @Operation(summary="\u89e3\u6790\u6587\u4ef6\u4e3a\u5c5e\u6027\u7269\u6a21\u578b")
    public Mono<String> importPropertyMetadata(@PathVariable @Parameter(description="\u4ea7\u54c1ID") String productId, @RequestParam @Parameter(description="\u6587\u4ef6\u5730\u5740,\u652f\u6301csv,xlsx\u6587\u4ef6\u683c\u5f0f") String fileUrl) {
        return this.metadataManager.getMetadataExpandsConfig(productId, DeviceMetadataType.property, "*", "*", new ConfigScope[]{DeviceConfigScope.device}).collectList().map(PropertyMetadataWrapper::new).flatMap(wrapper -> this.importExportService.getInputStream(fileUrl).flatMapMany(inputStream -> ReactorExcel.read((InputStream)inputStream, (String)FileUtils.getExtension((String)fileUrl), (RowWrapper)wrapper)).map(PropertyMetadataExcelInfo::toMetadata).collectList()).filter(CollectionUtils::isNotEmpty).map(list -> {
            SimpleDeviceMetadata metadata = new SimpleDeviceMetadata();
            list.forEach(arg_0 -> ((SimpleDeviceMetadata)metadata).addProperty(arg_0));
            return JetLinksDeviceMetadataCodec.getInstance().doEncode((DeviceMetadata)metadata);
        });
    }

    @GetMapping(value={"/{deviceId}/property-metadata/template.{format}"})
    @QueryAction
    @Operation(summary="\u4e0b\u8f7d\u8bbe\u5907\u7269\u6a21\u578b\u5c5e\u6027\u5bfc\u5165\u6a21\u5757")
    public Mono<Void> downloadMetadataExportTemplate(@PathVariable @Parameter(description="\u8bbe\u5907ID") String deviceId, ServerHttpResponse response, @PathVariable @Parameter(description="\u6587\u4ef6\u683c\u5f0f,\u652f\u6301csv,xlsx") String format) throws IOException {
        response.getHeaders().set("Content-Disposition", "attachment; filename=".concat(URLEncoder.encode("\u7269\u6a21\u578b\u5bfc\u5165\u6a21\u5757." + format, StandardCharsets.UTF_8.displayName())));
        return (Mono)this.metadataManager.getMetadataExpandsConfig(deviceId, DeviceMetadataType.property, "*", "*", new ConfigScope[]{DeviceConfigScope.device}).collectList().map(PropertyMetadataExcelInfo::getTemplateHeaderMapping).flatMapMany(headers -> ReactorExcel.writer((String)format).headers((Collection)headers).converter(DeviceExcelInfo::toMap).writeBuffer(Flux.empty())).doOnError(err -> log.error(err.getMessage(), err)).map(arg_0 -> ((DataBufferFactory)this.bufferFactory).wrap(arg_0)).as(arg_0 -> ((ServerHttpResponse)response).writeWith(arg_0));
    }

    @PatchMapping(value={"/{deviceId}/relations"})
    @Operation(summary="\u4fdd\u5b58\u8bbe\u5907\u7684\u5173\u7cfb\u4fe1\u606f")
    @SaveAction
    public Mono<Void> saveRelation(@PathVariable String deviceId, @RequestBody Flux<SaveRelationRequest> requestFlux) {
        return this.relationService.saveRelated("device", deviceId, requestFlux);
    }

    public LocalDeviceInstanceService getService() {
        return this.service;
    }
}

