/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.api.crud.entity.QueryNoPagingOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.jetlinks.community.device.entity.DeviceCategoryEntity;
import org.jetlinks.community.device.service.DeviceCategoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/device/category"})
@Tag(name="\u4ea7\u54c1\u5206\u7c7b\u7ba1\u7406")
@Resource(id="device-category", name="\u4ea7\u54c1\u5206\u7c7b")
public class DeviceCategoryController
implements ReactiveServiceCrudController<DeviceCategoryEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(DeviceCategoryController.class);
    private final DeviceCategoryService categoryService;

    @GetMapping
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u5168\u90e8\u5206\u7c7b")
    @Authorize(merge=false)
    public Flux<DeviceCategoryEntity> getAllCategory(@Parameter(hidden=true) QueryParamEntity query) {
        return ((ReactiveQuery)this.categoryService.createQuery().setParam((QueryParam)query)).fetch();
    }

    @GetMapping(value={"/_tree"})
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u5168\u90e8\u5206\u7c7b(\u6811\u7ed3\u6784)")
    @Authorize(merge=false)
    public Flux<DeviceCategoryEntity> getAllCategoryTree(@Parameter(hidden=true) QueryParamEntity query) {
        return ((ReactiveQuery)this.categoryService.createQuery().setParam((QueryParam)query)).fetch().collectList().flatMapMany(all -> Flux.fromIterable((Iterable)TreeSupportEntity.list2tree((Collection)all, DeviceCategoryEntity::setChildren)));
    }

    @PostMapping(value={"/_tree"})
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u5168\u90e8\u5206\u7c7b(\u6811\u7ed3\u6784)")
    @Authorize(merge=false)
    public Flux<DeviceCategoryEntity> getAllCategoryTreeByQueryParam(@RequestBody Mono<QueryParamEntity> query) {
        return this.categoryService.query(query).collectList().flatMapMany(all -> Flux.fromIterable((Iterable)TreeSupportEntity.list2tree((Collection)all, DeviceCategoryEntity::setChildren)));
    }

    public ReactiveCrudService<DeviceCategoryEntity, String> getService() {
        return this.categoryService;
    }

    public DeviceCategoryController(DeviceCategoryService categoryService) {
        this.categoryService = categoryService;
    }
}

