/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.message;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.PropertyConstants;
import org.jetlinks.core.Values;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.session.DeviceSessionEvent;
import org.jetlinks.core.device.session.DeviceSessionManager;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.message.ChildDeviceMessage;
import org.jetlinks.core.message.ChildDeviceMessageReply;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.DeviceMessageReply;
import org.jetlinks.core.message.DeviceOfflineMessage;
import org.jetlinks.core.message.DeviceOnlineMessage;
import org.jetlinks.core.message.HeaderKey;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;
import org.jetlinks.core.message.event.EventMessage;
import org.jetlinks.core.server.MessageHandler;
import org.jetlinks.core.server.session.ChildrenDeviceSession;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.supports.server.DecodedClientMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DeviceMessageConnector
implements DecodedClientMessageHandler {
    private static final Logger log = LoggerFactory.getLogger(DeviceMessageConnector.class);
    private static final String[] allConfigHeader = new String[]{PropertyConstants.productId.getKey(), PropertyConstants.deviceName.getKey(), PropertyConstants.orgId.getKey()};
    private static final Function<Throwable, Mono<Void>> doOnError = error -> {
        log.error(error.getMessage(), error);
        return Mono.empty();
    };
    private static final Function<DeviceOperator, Mono<Values>> configGetter = operator -> operator.getSelfConfigs(allConfigHeader);
    private static final Values emptyValues = Values.of(Collections.emptyMap());
    private static final BiConsumer<Message, StringBuilder>[] fastTopicBuilder = new BiConsumer[MessageType.values().length];
    private final DeviceRegistry registry;
    private final EventBus eventBus;
    private final MessageHandler messageHandler;

    public DeviceMessageConnector(EventBus eventBus, DeviceRegistry registry, MessageHandler messageHandler, DeviceSessionManager sessionManager) {
        this.registry = registry;
        this.eventBus = eventBus;
        this.messageHandler = messageHandler;
        sessionManager.listenEvent(event -> {
            if (event.isClusterExists()) {
                return Mono.empty();
            }
            if (event.getType() == DeviceSessionEvent.Type.unregister) {
                return this.handleSessionUnregister(event.getSession());
            }
            if (event.getType() == DeviceSessionEvent.Type.register) {
                return this.handleSessionRegister(event.getSession());
            }
            return Mono.empty();
        });
    }

    protected Mono<Void> handleSessionRegister(DeviceSession session) {
        DeviceOnlineMessage message = new DeviceOnlineMessage();
        message.addHeader("from", (Object)"session-register");
        message.addHeader("address", (Object)session.getClientAddress().map(InetSocketAddress::toString).orElse(""));
        message.setDeviceId(session.getDeviceId());
        message.setTimestamp(System.currentTimeMillis());
        return this.onMessage((Message)message).onErrorResume(doOnError);
    }

    protected Mono<Void> handleSessionUnregister(DeviceSession session) {
        DeviceOfflineMessage message = new DeviceOfflineMessage();
        message.addHeader("from", (Object)"session-unregister");
        message.setDeviceId(session.getDeviceId());
        message.setTimestamp(System.currentTimeMillis());
        if (session.isWrapFrom(ChildrenDeviceSession.class)) {
            ChildrenDeviceSession child = (ChildrenDeviceSession)session.unwrap(ChildrenDeviceSession.class);
            message.addHeader("parentId", (Object)child.getParentDevice().getDeviceId());
        }
        return this.onMessage((Message)message).onErrorResume(doOnError);
    }

    public static Flux<String> createDeviceMessageTopic(DeviceRegistry deviceRegistry, Message message) {
        return Flux.defer(() -> {
            if (message instanceof DeviceMessage) {
                DeviceMessage deviceMessage = (DeviceMessage)message;
                String deviceId = deviceMessage.getDeviceId();
                if (deviceId == null) {
                    log.warn("\u65e0\u6cd5\u4ece\u6d88\u606f\u4e2d\u83b7\u53d6\u8bbe\u5907ID:{}", (Object)deviceMessage);
                    return Mono.empty();
                }
                return deviceRegistry.getDevice(deviceId).flatMap(configGetter).defaultIfEmpty((Object)emptyValues).flatMapIterable(configs -> {
                    configs.getAllValues().forEach((arg_0, arg_1) -> ((DeviceMessage)deviceMessage).addHeader(arg_0, arg_1));
                    String productId = deviceMessage.getHeader((HeaderKey)PropertyConstants.productId).orElse("null");
                    String topic = DeviceMessageConnector.createDeviceMessageTopic(productId, deviceId, deviceMessage);
                    ArrayList<String> topics = new ArrayList<String>(2);
                    topics.add(topic);
                    configs.getValue((ConfigKey)PropertyConstants.orgId).ifPresent(orgId -> topics.add("/org/" + orgId + topic));
                    return topics;
                });
            }
            return Mono.just((Object)"/device/unknown/message/unknown");
        });
    }

    public static String createDeviceMessageTopic(String productId, String deviceId, DeviceMessage message) {
        StringBuilder builder = new StringBuilder(64).append("/device/").append(productId).append("/").append(deviceId);
        DeviceMessageConnector.appendDeviceMessageTopic((Message)message, builder);
        return builder.toString();
    }

    private static void createFastBuilder(MessageType messageType, String topic) {
        DeviceMessageConnector.fastTopicBuilder[messageType.ordinal()] = (ignore, builder) -> builder.append(topic);
    }

    private static void createFastBuilder(MessageType messageType, BiConsumer<Message, StringBuilder> builderBiConsumer) {
        DeviceMessageConnector.fastTopicBuilder[messageType.ordinal()] = builderBiConsumer;
    }

    public static void appendDeviceMessageTopic(Message message, StringBuilder builder) {
        BiConsumer<Message, StringBuilder> fastBuilder = fastTopicBuilder[message.getMessageType().ordinal()];
        if (null != fastBuilder) {
            fastBuilder.accept(message, builder);
        } else {
            builder.append("/message/").append(message.getMessageType().name().toLowerCase());
        }
    }

    public Mono<Void> onMessage(Message message) {
        if (null == message) {
            return Mono.empty();
        }
        message.addHeader((HeaderKey)PropertyConstants.uid, IDGenerator.SNOW_FLAKE_STRING.generate());
        return this.getTopic(message).flatMap(topic -> this.eventBus.publish(topic, (Object)message).then()).onErrorResume(doOnError).then();
    }

    private Flux<String> getTopic(Message message) {
        Flux<String> topicsStream = DeviceMessageConnector.createDeviceMessageTopic(this.registry, message);
        if (message instanceof ChildDeviceMessage) {
            return this.onMessage(((ChildDeviceMessage)message).getChildDeviceMessage()).thenMany(topicsStream);
        }
        if (message instanceof ChildDeviceMessageReply) {
            return this.onMessage(((ChildDeviceMessageReply)message).getChildDeviceMessage()).thenMany(topicsStream);
        }
        return topicsStream;
    }

    protected Mono<Boolean> handleChildrenDeviceMessage(Message message) {
        if (message instanceof DeviceMessageReply) {
            return this.doReply((DeviceMessageReply)message);
        }
        return Mono.just((Object)true);
    }

    protected Mono<Boolean> handleChildrenDeviceMessageReply(ChildDeviceMessage reply) {
        return this.handleChildrenDeviceMessage(reply.getChildDeviceMessage());
    }

    protected Mono<Boolean> handleChildrenDeviceMessageReply(ChildDeviceMessageReply reply) {
        return this.handleChildrenDeviceMessage(reply.getChildDeviceMessage());
    }

    public Mono<Boolean> handleMessage(DeviceOperator device, @Nonnull Message message) {
        Object then = message instanceof ChildDeviceMessageReply ? this.doReply((DeviceMessageReply)((ChildDeviceMessageReply)message)).then(this.handleChildrenDeviceMessageReply((ChildDeviceMessageReply)message)) : (message instanceof ChildDeviceMessage ? this.handleChildrenDeviceMessageReply((ChildDeviceMessage)message) : (message instanceof DeviceMessageReply ? this.doReply((DeviceMessageReply)message) : Mono.just((Object)true)));
        return this.onMessage(message).then(then).defaultIfEmpty((Object)false);
    }

    private Mono<Boolean> doReply(DeviceMessageReply reply) {
        if (log.isDebugEnabled()) {
            log.debug("reply message {}", (Object)reply.getMessageId());
        }
        return this.messageHandler.reply(reply).thenReturn((Object)true).doOnError(error -> log.error("reply message error", error));
    }

    static {
        DeviceMessageConnector.createFastBuilder(MessageType.EVENT, (Message message, StringBuilder builder) -> {
            EventMessage event = (EventMessage)message;
            builder.append("/message/event/").append(event.getEvent());
        });
        DeviceMessageConnector.createFastBuilder(MessageType.REPORT_PROPERTY, "/message/property/report");
        DeviceMessageConnector.createFastBuilder(MessageType.READ_PROPERTY, "/message/send/property/read");
        DeviceMessageConnector.createFastBuilder(MessageType.READ_PROPERTY_REPLY, "/message/property/read/reply");
        DeviceMessageConnector.createFastBuilder(MessageType.WRITE_PROPERTY, "/message/send/property/write");
        DeviceMessageConnector.createFastBuilder(MessageType.WRITE_PROPERTY_REPLY, "/message/property/write/reply");
        DeviceMessageConnector.createFastBuilder(MessageType.INVOKE_FUNCTION, "/message/send/function");
        DeviceMessageConnector.createFastBuilder(MessageType.INVOKE_FUNCTION_REPLY, "/message/function/reply");
        DeviceMessageConnector.createFastBuilder(MessageType.REGISTER, "/register");
        DeviceMessageConnector.createFastBuilder(MessageType.UN_REGISTER, "/unregister");
        DeviceMessageConnector.createFastBuilder(MessageType.REQUEST_FIRMWARE, "/firmware/pull");
        DeviceMessageConnector.createFastBuilder(MessageType.REQUEST_FIRMWARE_REPLY, "/firmware/pull/reply");
        DeviceMessageConnector.createFastBuilder(MessageType.REPORT_FIRMWARE, "/firmware/report");
        DeviceMessageConnector.createFastBuilder(MessageType.UPGRADE_FIRMWARE_PROGRESS, "/firmware/progress");
        DeviceMessageConnector.createFastBuilder(MessageType.UPGRADE_FIRMWARE, "/firmware/push");
        DeviceMessageConnector.createFastBuilder(MessageType.UPGRADE_FIRMWARE_REPLY, "/firmware/push/reply");
        DeviceMessageConnector.createFastBuilder(MessageType.UNKNOWN, "/message/unknown");
        DeviceMessageConnector.createFastBuilder(MessageType.LOG, "/message/log");
        DeviceMessageConnector.createFastBuilder(MessageType.DIRECT, "/message/direct");
        DeviceMessageConnector.createFastBuilder(MessageType.UPDATE_TAG, "/message/tags/update");
        DeviceMessageConnector.createFastBuilder(MessageType.ONLINE, "/online");
        DeviceMessageConnector.createFastBuilder(MessageType.OFFLINE, "/offline");
        DeviceMessageConnector.createFastBuilder(MessageType.DISCONNECT, "/disconnect");
        DeviceMessageConnector.createFastBuilder(MessageType.DISCONNECT_REPLY, "/disconnect/reply");
        DeviceMessageConnector.createFastBuilder(MessageType.CHILD, (Message message, StringBuilder builder) -> {
            Message msg = ((ChildDeviceMessage)message).getChildDeviceMessage();
            if (msg instanceof DeviceMessage) {
                builder.append("/message/children/").append(((DeviceMessage)msg).getDeviceId());
            } else {
                builder.append("/message/children");
            }
            DeviceMessageConnector.appendDeviceMessageTopic(msg, builder);
        });
        DeviceMessageConnector.createFastBuilder(MessageType.CHILD_REPLY, (Message message, StringBuilder builder) -> {
            Message msg = ((ChildDeviceMessageReply)message).getChildDeviceMessage();
            if (msg instanceof DeviceMessage) {
                builder.append("/message/children/reply/").append(((DeviceMessage)msg).getDeviceId());
            } else {
                builder.append("/message/children/reply");
            }
            DeviceMessageConnector.appendDeviceMessageTopic(msg, builder);
        });
        DeviceMessageConnector.createFastBuilder(MessageType.DERIVED_METADATA, "/metadata/derived");
    }
}

