/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.measurements.status;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.jetlinks.community.Interval;
import org.jetlinks.community.dashboard.CommonDimensionDefinition;
import org.jetlinks.community.dashboard.DimensionDefinition;
import org.jetlinks.community.dashboard.MeasurementDefinition;
import org.jetlinks.community.dashboard.MeasurementDimension;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.dashboard.MeasurementValue;
import org.jetlinks.community.dashboard.SimpleMeasurementValue;
import org.jetlinks.community.dashboard.supports.StaticMeasurement;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.enums.DeviceState;
import org.jetlinks.community.device.service.LocalDeviceInstanceService;
import org.jetlinks.community.device.timeseries.DeviceTimeSeriesMetric;
import org.jetlinks.community.timeseries.TimeSeriesManager;
import org.jetlinks.community.timeseries.TimeSeriesService;
import org.jetlinks.community.timeseries.query.AggregationQueryParam;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.StringType;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DeviceStatusRecordMeasurement
extends StaticMeasurement {
    public LocalDeviceInstanceService instanceService;
    private TimeSeriesManager timeSeriesManager;
    static MeasurementDefinition definition = MeasurementDefinition.of((String)"record", (String)"\u8bbe\u5907\u72b6\u6001\u8bb0\u5f55");
    static ConfigMetadata aggConfigMetadata = new DefaultConfigMetadata().add("productId", "\u8bbe\u5907\u578b\u53f7", "", (DataType)new StringType()).add("time", "\u5468\u671f", "\u4f8b\u5982: 1h,10m,30s", (DataType)new StringType()).add("format", "\u65f6\u95f4\u683c\u5f0f", "\u5982: MM-dd:HH", (DataType)new StringType()).add("limit", "\u6700\u5927\u6570\u636e\u91cf", "", (DataType)new IntType()).add("from", "\u65f6\u95f4\u4ece", "", (DataType)new DateTimeType()).add("to", "\u65f6\u95f4\u81f3", "", (DataType)new DateTimeType());
    static ConfigMetadata currentMetadata = new DefaultConfigMetadata().add("productId", "\u8bbe\u5907\u578b\u53f7", "", (DataType)new StringType()).add("state", "\u72b6\u6001", "online", (DataType)new EnumType().addElement(EnumType.Element.of((String)DeviceState.online.getValue(), (String)DeviceState.online.getText())).addElement(EnumType.Element.of((String)DeviceState.offline.getValue(), (String)DeviceState.offline.getText())).addElement(EnumType.Element.of((String)DeviceState.notActive.getValue(), (String)DeviceState.notActive.getText())));

    public DeviceStatusRecordMeasurement(LocalDeviceInstanceService deviceInstanceService, TimeSeriesManager timeSeriesManager) {
        super(definition);
        this.timeSeriesManager = timeSeriesManager;
        this.instanceService = deviceInstanceService;
        this.addDimension(new CurrentNumberOfDeviceDimension());
        this.addDimension(new AggNumberOfOnlineDeviceDimension());
    }

    class CurrentNumberOfDeviceDimension
    implements MeasurementDimension {
        CurrentNumberOfDeviceDimension() {
        }

        public DimensionDefinition getDefinition() {
            return CommonDimensionDefinition.current;
        }

        public DataType getValueType() {
            return new IntType();
        }

        public ConfigMetadata getParams() {
            return currentMetadata;
        }

        public boolean isRealTime() {
            return false;
        }

        public Mono<MeasurementValue> getValue(MeasurementParameter parameter) {
            return ((ReactiveQuery)((ReactiveQuery)DeviceStatusRecordMeasurement.this.instanceService.createQuery().and(DeviceInstanceEntity::getProductId, parameter.getString("productId").orElse(null))).and(DeviceInstanceEntity::getState, parameter.get("state", DeviceState.class).orElse(null))).count().map(val -> SimpleMeasurementValue.of((Object)val, (long)System.currentTimeMillis()));
        }
    }

    class AggNumberOfOnlineDeviceDimension
    implements MeasurementDimension {
        AggNumberOfOnlineDeviceDimension() {
        }

        public DimensionDefinition getDefinition() {
            return DimensionDefinition.of((String)"aggOnline", (String)"\u5386\u53f2\u5728\u7ebf\u6570");
        }

        public DataType getValueType() {
            return new IntType();
        }

        public ConfigMetadata getParams() {
            return aggConfigMetadata;
        }

        public boolean isRealTime() {
            return false;
        }

        public Flux<SimpleMeasurementValue> getValue(MeasurementParameter parameter) {
            String format = parameter.getString("format").orElse("yyyy\u5e74MM\u6708dd\u65e5");
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
            return ((Flux)AggregationQueryParam.of().max("value").filter(query -> {
                Query cfr_ignored_0 = (Query)query.where("name", (Object)"gateway-server-session");
            }).from(parameter.getDate("from").orElse(Date.from(LocalDateTime.now().plusDays(-30L).atZone(ZoneId.systemDefault()).toInstant()))).to(parameter.getDate("to").orElse(new Date())).groupBy(parameter.getInterval("time").orElse(Interval.ofDays((int)1)), parameter.getString("format").orElse("yyyy\u5e74MM\u6708dd\u65e5")).limit(parameter.getInt("limit").orElse(10).intValue()).execute(arg_0 -> ((TimeSeriesService)DeviceStatusRecordMeasurement.this.timeSeriesManager.getService(DeviceTimeSeriesMetric.deviceMetrics())).aggregation(arg_0))).map(data -> {
                long ts = data.getString("time").map(time -> DateTime.parse((String)time, (DateTimeFormatter)formatter).getMillis()).orElse(System.currentTimeMillis());
                return SimpleMeasurementValue.of((Object)data.get("value").orElse(0), (String)data.getString("time", ""), (long)ts);
            }).sort();
        }
    }
}

