/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.measurements.sys;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetlinks.community.dashboard.measurements.sys.MonitorInfo;
import org.jetlinks.community.dashboard.measurements.sys.MonitorUtils;

public class CpuInfo
implements MonitorInfo<CpuInfo> {
    private static final long serialVersionUID = 1L;
    @Schema(description="JVM\u8fdb\u7a0bCPU\u4f7f\u7528\u7387,0-100")
    private float jvmUsage;
    @Schema(description="\u7cfb\u7edfCPU\u4f7f\u7528\u7387,0-100")
    private float systemUsage;

    @Override
    public CpuInfo add(CpuInfo info) {
        return new CpuInfo(MonitorUtils.round(info.jvmUsage + this.jvmUsage), MonitorUtils.round(info.systemUsage + this.systemUsage));
    }

    @Override
    public CpuInfo division(int num) {
        return new CpuInfo(MonitorUtils.round(this.jvmUsage / (float)num), MonitorUtils.round(this.systemUsage / (float)num));
    }

    public float getJvmUsage() {
        return this.jvmUsage;
    }

    public float getSystemUsage() {
        return this.systemUsage;
    }

    public void setJvmUsage(float jvmUsage) {
        this.jvmUsage = jvmUsage;
    }

    public void setSystemUsage(float systemUsage) {
        this.systemUsage = systemUsage;
    }

    public String toString() {
        return "CpuInfo(jvmUsage=" + this.getJvmUsage() + ", systemUsage=" + this.getSystemUsage() + ")";
    }

    public CpuInfo(float jvmUsage, float systemUsage) {
        this.jvmUsage = jvmUsage;
        this.systemUsage = systemUsage;
    }

    public CpuInfo() {
    }
}

